/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.transform.LoadBasedAutoScalingConfigurationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a layer's load-based auto scaling configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class LoadBasedAutoScalingConfiguration implements StructuredPojo,
        ToCopyableBuilder<LoadBasedAutoScalingConfiguration.Builder, LoadBasedAutoScalingConfiguration> {
    private final String layerId;

    private final Boolean enable;

    private final AutoScalingThresholds upScaling;

    private final AutoScalingThresholds downScaling;

    private LoadBasedAutoScalingConfiguration(BuilderImpl builder) {
        this.layerId = builder.layerId;
        this.enable = builder.enable;
        this.upScaling = builder.upScaling;
        this.downScaling = builder.downScaling;
    }

    /**
     * <p>
     * The layer ID.
     * </p>
     * 
     * @return The layer ID.
     */
    public String layerId() {
        return layerId;
    }

    /**
     * <p>
     * Whether load-based auto scaling is enabled for the layer.
     * </p>
     * 
     * @return Whether load-based auto scaling is enabled for the layer.
     */
    public Boolean enable() {
        return enable;
    }

    /**
     * <p>
     * An <code>AutoScalingThresholds</code> object that describes the upscaling configuration, which defines how and
     * when AWS OpsWorks Stacks increases the number of instances.
     * </p>
     * 
     * @return An <code>AutoScalingThresholds</code> object that describes the upscaling configuration, which defines
     *         how and when AWS OpsWorks Stacks increases the number of instances.
     */
    public AutoScalingThresholds upScaling() {
        return upScaling;
    }

    /**
     * <p>
     * An <code>AutoScalingThresholds</code> object that describes the downscaling configuration, which defines how and
     * when AWS OpsWorks Stacks reduces the number of instances.
     * </p>
     * 
     * @return An <code>AutoScalingThresholds</code> object that describes the downscaling configuration, which defines
     *         how and when AWS OpsWorks Stacks reduces the number of instances.
     */
    public AutoScalingThresholds downScaling() {
        return downScaling;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(layerId());
        hashCode = 31 * hashCode + Objects.hashCode(enable());
        hashCode = 31 * hashCode + Objects.hashCode(upScaling());
        hashCode = 31 * hashCode + Objects.hashCode(downScaling());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoadBasedAutoScalingConfiguration)) {
            return false;
        }
        LoadBasedAutoScalingConfiguration other = (LoadBasedAutoScalingConfiguration) obj;
        return Objects.equals(layerId(), other.layerId()) && Objects.equals(enable(), other.enable())
                && Objects.equals(upScaling(), other.upScaling()) && Objects.equals(downScaling(), other.downScaling());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (layerId() != null) {
            sb.append("LayerId: ").append(layerId()).append(",");
        }
        if (enable() != null) {
            sb.append("Enable: ").append(enable()).append(",");
        }
        if (upScaling() != null) {
            sb.append("UpScaling: ").append(upScaling()).append(",");
        }
        if (downScaling() != null) {
            sb.append("DownScaling: ").append(downScaling()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LayerId":
            return Optional.of(clazz.cast(layerId()));
        case "Enable":
            return Optional.of(clazz.cast(enable()));
        case "UpScaling":
            return Optional.of(clazz.cast(upScaling()));
        case "DownScaling":
            return Optional.of(clazz.cast(downScaling()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LoadBasedAutoScalingConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, LoadBasedAutoScalingConfiguration> {
        /**
         * <p>
         * The layer ID.
         * </p>
         * 
         * @param layerId
         *        The layer ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layerId(String layerId);

        /**
         * <p>
         * Whether load-based auto scaling is enabled for the layer.
         * </p>
         * 
         * @param enable
         *        Whether load-based auto scaling is enabled for the layer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enable(Boolean enable);

        /**
         * <p>
         * An <code>AutoScalingThresholds</code> object that describes the upscaling configuration, which defines how
         * and when AWS OpsWorks Stacks increases the number of instances.
         * </p>
         * 
         * @param upScaling
         *        An <code>AutoScalingThresholds</code> object that describes the upscaling configuration, which defines
         *        how and when AWS OpsWorks Stacks increases the number of instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upScaling(AutoScalingThresholds upScaling);

        /**
         * <p>
         * An <code>AutoScalingThresholds</code> object that describes the upscaling configuration, which defines how
         * and when AWS OpsWorks Stacks increases the number of instances.
         * </p>
         * This is a convenience that creates an instance of the {@link AutoScalingThresholds.Builder} avoiding the need
         * to create one manually via {@link AutoScalingThresholds#builder()}.
         *
         * When the {@link Consumer} completes, {@link AutoScalingThresholds.Builder#build()} is called immediately and
         * its result is passed to {@link #upScaling(AutoScalingThresholds)}.
         * 
         * @param upScaling
         *        a consumer that will call methods on {@link AutoScalingThresholds.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #upScaling(AutoScalingThresholds)
         */
        default Builder upScaling(Consumer<AutoScalingThresholds.Builder> upScaling) {
            return upScaling(AutoScalingThresholds.builder().apply(upScaling).build());
        }

        /**
         * <p>
         * An <code>AutoScalingThresholds</code> object that describes the downscaling configuration, which defines how
         * and when AWS OpsWorks Stacks reduces the number of instances.
         * </p>
         * 
         * @param downScaling
         *        An <code>AutoScalingThresholds</code> object that describes the downscaling configuration, which
         *        defines how and when AWS OpsWorks Stacks reduces the number of instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder downScaling(AutoScalingThresholds downScaling);

        /**
         * <p>
         * An <code>AutoScalingThresholds</code> object that describes the downscaling configuration, which defines how
         * and when AWS OpsWorks Stacks reduces the number of instances.
         * </p>
         * This is a convenience that creates an instance of the {@link AutoScalingThresholds.Builder} avoiding the need
         * to create one manually via {@link AutoScalingThresholds#builder()}.
         *
         * When the {@link Consumer} completes, {@link AutoScalingThresholds.Builder#build()} is called immediately and
         * its result is passed to {@link #downScaling(AutoScalingThresholds)}.
         * 
         * @param downScaling
         *        a consumer that will call methods on {@link AutoScalingThresholds.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #downScaling(AutoScalingThresholds)
         */
        default Builder downScaling(Consumer<AutoScalingThresholds.Builder> downScaling) {
            return downScaling(AutoScalingThresholds.builder().apply(downScaling).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String layerId;

        private Boolean enable;

        private AutoScalingThresholds upScaling;

        private AutoScalingThresholds downScaling;

        private BuilderImpl() {
        }

        private BuilderImpl(LoadBasedAutoScalingConfiguration model) {
            layerId(model.layerId);
            enable(model.enable);
            upScaling(model.upScaling);
            downScaling(model.downScaling);
        }

        public final String getLayerId() {
            return layerId;
        }

        @Override
        public final Builder layerId(String layerId) {
            this.layerId = layerId;
            return this;
        }

        public final void setLayerId(String layerId) {
            this.layerId = layerId;
        }

        public final Boolean getEnable() {
            return enable;
        }

        @Override
        public final Builder enable(Boolean enable) {
            this.enable = enable;
            return this;
        }

        public final void setEnable(Boolean enable) {
            this.enable = enable;
        }

        public final AutoScalingThresholds.Builder getUpScaling() {
            return upScaling != null ? upScaling.toBuilder() : null;
        }

        @Override
        public final Builder upScaling(AutoScalingThresholds upScaling) {
            this.upScaling = upScaling;
            return this;
        }

        public final void setUpScaling(AutoScalingThresholds.BuilderImpl upScaling) {
            this.upScaling = upScaling != null ? upScaling.build() : null;
        }

        public final AutoScalingThresholds.Builder getDownScaling() {
            return downScaling != null ? downScaling.toBuilder() : null;
        }

        @Override
        public final Builder downScaling(AutoScalingThresholds downScaling) {
            this.downScaling = downScaling;
            return this;
        }

        public final void setDownScaling(AutoScalingThresholds.BuilderImpl downScaling) {
            this.downScaling = downScaling != null ? downScaling.build() : null;
        }

        @Override
        public LoadBasedAutoScalingConfiguration build() {
            return new LoadBasedAutoScalingConfiguration(this);
        }
    }
}
