/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class RegisterRdsDbInstanceRequest extends OpsWorksRequest implements
        ToCopyableBuilder<RegisterRdsDbInstanceRequest.Builder, RegisterRdsDbInstanceRequest> {
    private final String stackId;

    private final String rdsDbInstanceArn;

    private final String dbUser;

    private final String dbPassword;

    private RegisterRdsDbInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.stackId = builder.stackId;
        this.rdsDbInstanceArn = builder.rdsDbInstanceArn;
        this.dbUser = builder.dbUser;
        this.dbPassword = builder.dbPassword;
    }

    /**
     * <p>
     * The stack ID.
     * </p>
     * 
     * @return The stack ID.
     */
    public String stackId() {
        return stackId;
    }

    /**
     * <p>
     * The Amazon RDS instance's ARN.
     * </p>
     * 
     * @return The Amazon RDS instance's ARN.
     */
    public String rdsDbInstanceArn() {
        return rdsDbInstanceArn;
    }

    /**
     * <p>
     * The database's master user name.
     * </p>
     * 
     * @return The database's master user name.
     */
    public String dbUser() {
        return dbUser;
    }

    /**
     * <p>
     * The database password.
     * </p>
     * 
     * @return The database password.
     */
    public String dbPassword() {
        return dbPassword;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stackId());
        hashCode = 31 * hashCode + Objects.hashCode(rdsDbInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(dbUser());
        hashCode = 31 * hashCode + Objects.hashCode(dbPassword());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterRdsDbInstanceRequest)) {
            return false;
        }
        RegisterRdsDbInstanceRequest other = (RegisterRdsDbInstanceRequest) obj;
        return Objects.equals(stackId(), other.stackId()) && Objects.equals(rdsDbInstanceArn(), other.rdsDbInstanceArn())
                && Objects.equals(dbUser(), other.dbUser()) && Objects.equals(dbPassword(), other.dbPassword());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (stackId() != null) {
            sb.append("StackId: ").append(stackId()).append(",");
        }
        if (rdsDbInstanceArn() != null) {
            sb.append("RdsDbInstanceArn: ").append(rdsDbInstanceArn()).append(",");
        }
        if (dbUser() != null) {
            sb.append("DbUser: ").append(dbUser()).append(",");
        }
        if (dbPassword() != null) {
            sb.append("DbPassword: ").append(dbPassword()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackId":
            return Optional.of(clazz.cast(stackId()));
        case "RdsDbInstanceArn":
            return Optional.of(clazz.cast(rdsDbInstanceArn()));
        case "DbUser":
            return Optional.of(clazz.cast(dbUser()));
        case "DbPassword":
            return Optional.of(clazz.cast(dbPassword()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends OpsWorksRequest.Builder, CopyableBuilder<Builder, RegisterRdsDbInstanceRequest> {
        /**
         * <p>
         * The stack ID.
         * </p>
         * 
         * @param stackId
         *        The stack ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * The Amazon RDS instance's ARN.
         * </p>
         * 
         * @param rdsDbInstanceArn
         *        The Amazon RDS instance's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rdsDbInstanceArn(String rdsDbInstanceArn);

        /**
         * <p>
         * The database's master user name.
         * </p>
         * 
         * @param dbUser
         *        The database's master user name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbUser(String dbUser);

        /**
         * <p>
         * The database password.
         * </p>
         * 
         * @param dbPassword
         *        The database password.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbPassword(String dbPassword);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends OpsWorksRequest.BuilderImpl implements Builder {
        private String stackId;

        private String rdsDbInstanceArn;

        private String dbUser;

        private String dbPassword;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterRdsDbInstanceRequest model) {
            stackId(model.stackId);
            rdsDbInstanceArn(model.rdsDbInstanceArn);
            dbUser(model.dbUser);
            dbPassword(model.dbPassword);
        }

        public final String getStackId() {
            return stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getRdsDbInstanceArn() {
            return rdsDbInstanceArn;
        }

        @Override
        public final Builder rdsDbInstanceArn(String rdsDbInstanceArn) {
            this.rdsDbInstanceArn = rdsDbInstanceArn;
            return this;
        }

        public final void setRdsDbInstanceArn(String rdsDbInstanceArn) {
            this.rdsDbInstanceArn = rdsDbInstanceArn;
        }

        public final String getDbUser() {
            return dbUser;
        }

        @Override
        public final Builder dbUser(String dbUser) {
            this.dbUser = dbUser;
            return this;
        }

        public final void setDbUser(String dbUser) {
            this.dbUser = dbUser;
        }

        public final String getDbPassword() {
            return dbPassword;
        }

        @Override
        public final Builder dbPassword(String dbPassword) {
            this.dbPassword = dbPassword;
            return this;
        }

        public final void setDbPassword(String dbPassword) {
            this.dbPassword = dbPassword;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public RegisterRdsDbInstanceRequest build() {
            return new RegisterRdsDbInstanceRequest(this);
        }
    }
}
