/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a <code>RegisterVolume</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RegisterVolumeResponse extends OpsWorksResponse implements
        ToCopyableBuilder<RegisterVolumeResponse.Builder, RegisterVolumeResponse> {
    private final String volumeId;

    private RegisterVolumeResponse(BuilderImpl builder) {
        super(builder);
        this.volumeId = builder.volumeId;
    }

    /**
     * <p>
     * The volume ID.
     * </p>
     * 
     * @return The volume ID.
     */
    public String volumeId() {
        return volumeId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(volumeId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterVolumeResponse)) {
            return false;
        }
        RegisterVolumeResponse other = (RegisterVolumeResponse) obj;
        return Objects.equals(volumeId(), other.volumeId());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (volumeId() != null) {
            sb.append("VolumeId: ").append(volumeId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VolumeId":
            return Optional.of(clazz.cast(volumeId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends OpsWorksResponse.Builder, CopyableBuilder<Builder, RegisterVolumeResponse> {
        /**
         * <p>
         * The volume ID.
         * </p>
         * 
         * @param volumeId
         *        The volume ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeId(String volumeId);
    }

    static final class BuilderImpl extends OpsWorksResponse.BuilderImpl implements Builder {
        private String volumeId;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterVolumeResponse model) {
            volumeId(model.volumeId);
        }

        public final String getVolumeId() {
            return volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        @Override
        public RegisterVolumeResponse build() {
            return new RegisterVolumeResponse(this);
        }
    }
}
