/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.transform.SslConfigurationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an app's SSL configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class SslConfiguration implements StructuredPojo, ToCopyableBuilder<SslConfiguration.Builder, SslConfiguration> {
    private final String certificate;

    private final String privateKey;

    private final String chain;

    private SslConfiguration(BuilderImpl builder) {
        this.certificate = builder.certificate;
        this.privateKey = builder.privateKey;
        this.chain = builder.chain;
    }

    /**
     * <p>
     * The contents of the certificate's domain.crt file.
     * </p>
     * 
     * @return The contents of the certificate's domain.crt file.
     */
    public String certificate() {
        return certificate;
    }

    /**
     * <p>
     * The private key; the contents of the certificate's domain.kex file.
     * </p>
     * 
     * @return The private key; the contents of the certificate's domain.kex file.
     */
    public String privateKey() {
        return privateKey;
    }

    /**
     * <p>
     * Optional. Can be used to specify an intermediate certificate authority key or client authentication.
     * </p>
     * 
     * @return Optional. Can be used to specify an intermediate certificate authority key or client authentication.
     */
    public String chain() {
        return chain;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(certificate());
        hashCode = 31 * hashCode + Objects.hashCode(privateKey());
        hashCode = 31 * hashCode + Objects.hashCode(chain());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SslConfiguration)) {
            return false;
        }
        SslConfiguration other = (SslConfiguration) obj;
        return Objects.equals(certificate(), other.certificate()) && Objects.equals(privateKey(), other.privateKey())
                && Objects.equals(chain(), other.chain());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (certificate() != null) {
            sb.append("Certificate: ").append(certificate()).append(",");
        }
        if (privateKey() != null) {
            sb.append("PrivateKey: ").append(privateKey()).append(",");
        }
        if (chain() != null) {
            sb.append("Chain: ").append(chain()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Certificate":
            return Optional.of(clazz.cast(certificate()));
        case "PrivateKey":
            return Optional.of(clazz.cast(privateKey()));
        case "Chain":
            return Optional.of(clazz.cast(chain()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SslConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, SslConfiguration> {
        /**
         * <p>
         * The contents of the certificate's domain.crt file.
         * </p>
         * 
         * @param certificate
         *        The contents of the certificate's domain.crt file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificate(String certificate);

        /**
         * <p>
         * The private key; the contents of the certificate's domain.kex file.
         * </p>
         * 
         * @param privateKey
         *        The private key; the contents of the certificate's domain.kex file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateKey(String privateKey);

        /**
         * <p>
         * Optional. Can be used to specify an intermediate certificate authority key or client authentication.
         * </p>
         * 
         * @param chain
         *        Optional. Can be used to specify an intermediate certificate authority key or client authentication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chain(String chain);
    }

    static final class BuilderImpl implements Builder {
        private String certificate;

        private String privateKey;

        private String chain;

        private BuilderImpl() {
        }

        private BuilderImpl(SslConfiguration model) {
            certificate(model.certificate);
            privateKey(model.privateKey);
            chain(model.chain);
        }

        public final String getCertificate() {
            return certificate;
        }

        @Override
        public final Builder certificate(String certificate) {
            this.certificate = certificate;
            return this;
        }

        public final void setCertificate(String certificate) {
            this.certificate = certificate;
        }

        public final String getPrivateKey() {
            return privateKey;
        }

        @Override
        public final Builder privateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public final void setPrivateKey(String privateKey) {
            this.privateKey = privateKey;
        }

        public final String getChain() {
            return chain;
        }

        @Override
        public final Builder chain(String chain) {
            this.chain = chain;
            return this;
        }

        public final void setChain(String chain) {
            this.chain = chain;
        }

        @Override
        public SslConfiguration build() {
            return new SslConfiguration(this);
        }
    }
}
