/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.transform;

import java.util.List;
import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.opsworks.model.*;

import software.amazon.awssdk.core.protocol.*;
import software.amazon.awssdk.annotations.SdkInternalApi;

/**
 * RecipesMarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
@SdkInternalApi
public class RecipesMarshaller {

    private static final MarshallingInfo<List> SETUP_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Setup").build();
    private static final MarshallingInfo<List> CONFIGURE_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Configure").build();
    private static final MarshallingInfo<List> DEPLOY_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Deploy").build();
    private static final MarshallingInfo<List> UNDEPLOY_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Undeploy").build();
    private static final MarshallingInfo<List> SHUTDOWN_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Shutdown").build();

    private static final RecipesMarshaller INSTANCE = new RecipesMarshaller();

    public static RecipesMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(Recipes recipes, ProtocolMarshaller protocolMarshaller) {

        if (recipes == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {

            protocolMarshaller.marshall(recipes.setup(), SETUP_BINDING);

            protocolMarshaller.marshall(recipes.configure(), CONFIGURE_BINDING);

            protocolMarshaller.marshall(recipes.deploy(), DEPLOY_BINDING);

            protocolMarshaller.marshall(recipes.undeploy(), UNDEPLOY_BINDING);

            protocolMarshaller.marshall(recipes.shutdown(), SHUTDOWN_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
