/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.transform.CommandMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Command
implements StructuredPojo,
ToCopyableBuilder<Builder, Command> {
    private final String commandId;
    private final String instanceId;
    private final String deploymentId;
    private final String createdAt;
    private final String acknowledgedAt;
    private final String completedAt;
    private final String status;
    private final Integer exitCode;
    private final String logUrl;
    private final String type;

    private Command(BuilderImpl builder) {
        this.commandId = builder.commandId;
        this.instanceId = builder.instanceId;
        this.deploymentId = builder.deploymentId;
        this.createdAt = builder.createdAt;
        this.acknowledgedAt = builder.acknowledgedAt;
        this.completedAt = builder.completedAt;
        this.status = builder.status;
        this.exitCode = builder.exitCode;
        this.logUrl = builder.logUrl;
        this.type = builder.type;
    }

    public String commandId() {
        return this.commandId;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String deploymentId() {
        return this.deploymentId;
    }

    public String createdAt() {
        return this.createdAt;
    }

    public String acknowledgedAt() {
        return this.acknowledgedAt;
    }

    public String completedAt() {
        return this.completedAt;
    }

    public String status() {
        return this.status;
    }

    public Integer exitCode() {
        return this.exitCode;
    }

    public String logUrl() {
        return this.logUrl;
    }

    public String type() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.commandId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.acknowledgedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.completedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.exitCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.logUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Command)) {
            return false;
        }
        Command other = (Command)obj;
        return Objects.equals(this.commandId(), other.commandId()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.deploymentId(), other.deploymentId()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.acknowledgedAt(), other.acknowledgedAt()) && Objects.equals(this.completedAt(), other.completedAt()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.exitCode(), other.exitCode()) && Objects.equals(this.logUrl(), other.logUrl()) && Objects.equals(this.type(), other.type());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.commandId() != null) {
            sb.append("CommandId: ").append(this.commandId()).append(",");
        }
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.deploymentId() != null) {
            sb.append("DeploymentId: ").append(this.deploymentId()).append(",");
        }
        if (this.createdAt() != null) {
            sb.append("CreatedAt: ").append(this.createdAt()).append(",");
        }
        if (this.acknowledgedAt() != null) {
            sb.append("AcknowledgedAt: ").append(this.acknowledgedAt()).append(",");
        }
        if (this.completedAt() != null) {
            sb.append("CompletedAt: ").append(this.completedAt()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.exitCode() != null) {
            sb.append("ExitCode: ").append(this.exitCode()).append(",");
        }
        if (this.logUrl() != null) {
            sb.append("LogUrl: ").append(this.logUrl()).append(",");
        }
        if (this.type() != null) {
            sb.append("Type: ").append(this.type()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CommandId": {
                return Optional.of(clazz.cast(this.commandId()));
            }
            case "InstanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
            case "DeploymentId": {
                return Optional.of(clazz.cast(this.deploymentId()));
            }
            case "CreatedAt": {
                return Optional.of(clazz.cast(this.createdAt()));
            }
            case "AcknowledgedAt": {
                return Optional.of(clazz.cast(this.acknowledgedAt()));
            }
            case "CompletedAt": {
                return Optional.of(clazz.cast(this.completedAt()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.status()));
            }
            case "ExitCode": {
                return Optional.of(clazz.cast(this.exitCode()));
            }
            case "LogUrl": {
                return Optional.of(clazz.cast(this.logUrl()));
            }
            case "Type": {
                return Optional.of(clazz.cast(this.type()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CommandMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String commandId;
        private String instanceId;
        private String deploymentId;
        private String createdAt;
        private String acknowledgedAt;
        private String completedAt;
        private String status;
        private Integer exitCode;
        private String logUrl;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(Command model) {
            this.commandId(model.commandId);
            this.instanceId(model.instanceId);
            this.deploymentId(model.deploymentId);
            this.createdAt(model.createdAt);
            this.acknowledgedAt(model.acknowledgedAt);
            this.completedAt(model.completedAt);
            this.status(model.status);
            this.exitCode(model.exitCode);
            this.logUrl(model.logUrl);
            this.type(model.type);
        }

        public final String getCommandId() {
            return this.commandId;
        }

        @Override
        public final Builder commandId(String commandId) {
            this.commandId = commandId;
            return this;
        }

        public final void setCommandId(String commandId) {
            this.commandId = commandId;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getDeploymentId() {
            return this.deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        public final String getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        public final String getAcknowledgedAt() {
            return this.acknowledgedAt;
        }

        @Override
        public final Builder acknowledgedAt(String acknowledgedAt) {
            this.acknowledgedAt = acknowledgedAt;
            return this;
        }

        public final void setAcknowledgedAt(String acknowledgedAt) {
            this.acknowledgedAt = acknowledgedAt;
        }

        public final String getCompletedAt() {
            return this.completedAt;
        }

        @Override
        public final Builder completedAt(String completedAt) {
            this.completedAt = completedAt;
            return this;
        }

        public final void setCompletedAt(String completedAt) {
            this.completedAt = completedAt;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Integer getExitCode() {
            return this.exitCode;
        }

        @Override
        public final Builder exitCode(Integer exitCode) {
            this.exitCode = exitCode;
            return this;
        }

        public final void setExitCode(Integer exitCode) {
            this.exitCode = exitCode;
        }

        public final String getLogUrl() {
            return this.logUrl;
        }

        @Override
        public final Builder logUrl(String logUrl) {
            this.logUrl = logUrl;
            return this;
        }

        public final void setLogUrl(String logUrl) {
            this.logUrl = logUrl;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public Command build() {
            return new Command(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Command> {
        public Builder commandId(String var1);

        public Builder instanceId(String var1);

        public Builder deploymentId(String var1);

        public Builder createdAt(String var1);

        public Builder acknowledgedAt(String var1);

        public Builder completedAt(String var1);

        public Builder status(String var1);

        public Builder exitCode(Integer var1);

        public Builder logUrl(String var1);

        public Builder type(String var1);
    }
}

