/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.opsworks.model.AgentVersion;
import software.amazon.awssdk.services.opsworks.model.AgentVersionsCopier;
import software.amazon.awssdk.services.opsworks.model.OpsWorksResponse;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeAgentVersionsResponse
extends OpsWorksResponse
implements ToCopyableBuilder<Builder, DescribeAgentVersionsResponse> {
    private final List<AgentVersion> agentVersions;

    private DescribeAgentVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.agentVersions = builder.agentVersions;
    }

    public List<AgentVersion> agentVersions() {
        return this.agentVersions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.agentVersions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAgentVersionsResponse)) {
            return false;
        }
        DescribeAgentVersionsResponse other = (DescribeAgentVersionsResponse)((Object)obj);
        return Objects.equals(this.agentVersions(), other.agentVersions());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.agentVersions() != null) {
            sb.append("AgentVersions: ").append(this.agentVersions()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AgentVersions": {
                return Optional.of(clazz.cast(this.agentVersions()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends OpsWorksResponse.BuilderImpl
    implements Builder {
        private List<AgentVersion> agentVersions;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAgentVersionsResponse model) {
            this.agentVersions(model.agentVersions);
        }

        public final Collection<AgentVersion.Builder> getAgentVersions() {
            return this.agentVersions != null ? (Collection)this.agentVersions.stream().map(AgentVersion::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder agentVersions(Collection<AgentVersion> agentVersions) {
            this.agentVersions = AgentVersionsCopier.copy(agentVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentVersions(AgentVersion ... agentVersions) {
            this.agentVersions(Arrays.asList(agentVersions));
            return this;
        }

        public final void setAgentVersions(Collection<AgentVersion.BuilderImpl> agentVersions) {
            this.agentVersions = AgentVersionsCopier.copyFromBuilder(agentVersions);
        }

        @Override
        public DescribeAgentVersionsResponse build() {
            return new DescribeAgentVersionsResponse(this);
        }
    }

    public static interface Builder
    extends OpsWorksResponse.Builder,
    CopyableBuilder<Builder, DescribeAgentVersionsResponse> {
        public Builder agentVersions(Collection<AgentVersion> var1);

        public Builder agentVersions(AgentVersion ... var1);
    }
}

