/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.opsworks.model.Deployment;
import software.amazon.awssdk.services.opsworks.model.DeploymentsCopier;
import software.amazon.awssdk.services.opsworks.model.OpsWorksResponse;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeDeploymentsResponse
extends OpsWorksResponse
implements ToCopyableBuilder<Builder, DescribeDeploymentsResponse> {
    private final List<Deployment> deployments;

    private DescribeDeploymentsResponse(BuilderImpl builder) {
        super(builder);
        this.deployments = builder.deployments;
    }

    public List<Deployment> deployments() {
        return this.deployments;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deployments());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDeploymentsResponse)) {
            return false;
        }
        DescribeDeploymentsResponse other = (DescribeDeploymentsResponse)((Object)obj);
        return Objects.equals(this.deployments(), other.deployments());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.deployments() != null) {
            sb.append("Deployments: ").append(this.deployments()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Deployments": {
                return Optional.of(clazz.cast(this.deployments()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends OpsWorksResponse.BuilderImpl
    implements Builder {
        private List<Deployment> deployments;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDeploymentsResponse model) {
            this.deployments(model.deployments);
        }

        public final Collection<Deployment.Builder> getDeployments() {
            return this.deployments != null ? (Collection)this.deployments.stream().map(Deployment::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder deployments(Collection<Deployment> deployments) {
            this.deployments = DeploymentsCopier.copy(deployments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deployments(Deployment ... deployments) {
            this.deployments(Arrays.asList(deployments));
            return this;
        }

        public final void setDeployments(Collection<Deployment.BuilderImpl> deployments) {
            this.deployments = DeploymentsCopier.copyFromBuilder(deployments);
        }

        @Override
        public DescribeDeploymentsResponse build() {
            return new DescribeDeploymentsResponse(this);
        }
    }

    public static interface Builder
    extends OpsWorksResponse.Builder,
    CopyableBuilder<Builder, DescribeDeploymentsResponse> {
        public Builder deployments(Collection<Deployment> var1);

        public Builder deployments(Deployment ... var1);
    }
}

