/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.opsworks.model.OpsWorksRequest;
import software.amazon.awssdk.services.opsworks.model.StringsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeServiceErrorsRequest
extends OpsWorksRequest
implements ToCopyableBuilder<Builder, DescribeServiceErrorsRequest> {
    private final String stackId;
    private final String instanceId;
    private final List<String> serviceErrorIds;

    private DescribeServiceErrorsRequest(BuilderImpl builder) {
        super(builder);
        this.stackId = builder.stackId;
        this.instanceId = builder.instanceId;
        this.serviceErrorIds = builder.serviceErrorIds;
    }

    public String stackId() {
        return this.stackId;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public List<String> serviceErrorIds() {
        return this.serviceErrorIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceErrorIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeServiceErrorsRequest)) {
            return false;
        }
        DescribeServiceErrorsRequest other = (DescribeServiceErrorsRequest)((Object)obj);
        return Objects.equals(this.stackId(), other.stackId()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.serviceErrorIds(), other.serviceErrorIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.stackId() != null) {
            sb.append("StackId: ").append(this.stackId()).append(",");
        }
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.serviceErrorIds() != null) {
            sb.append("ServiceErrorIds: ").append(this.serviceErrorIds()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackId": {
                return Optional.of(clazz.cast(this.stackId()));
            }
            case "InstanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
            case "ServiceErrorIds": {
                return Optional.of(clazz.cast(this.serviceErrorIds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends OpsWorksRequest.BuilderImpl
    implements Builder {
        private String stackId;
        private String instanceId;
        private List<String> serviceErrorIds;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeServiceErrorsRequest model) {
            this.stackId(model.stackId);
            this.instanceId(model.instanceId);
            this.serviceErrorIds(model.serviceErrorIds);
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Collection<String> getServiceErrorIds() {
            return this.serviceErrorIds;
        }

        @Override
        public final Builder serviceErrorIds(Collection<String> serviceErrorIds) {
            this.serviceErrorIds = StringsCopier.copy(serviceErrorIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceErrorIds(String ... serviceErrorIds) {
            this.serviceErrorIds(Arrays.asList(serviceErrorIds));
            return this;
        }

        public final void setServiceErrorIds(Collection<String> serviceErrorIds) {
            this.serviceErrorIds = StringsCopier.copy(serviceErrorIds);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeServiceErrorsRequest build() {
            return new DescribeServiceErrorsRequest(this);
        }
    }

    public static interface Builder
    extends OpsWorksRequest.Builder,
    CopyableBuilder<Builder, DescribeServiceErrorsRequest> {
        public Builder stackId(String var1);

        public Builder instanceId(String var1);

        public Builder serviceErrorIds(Collection<String> var1);

        public Builder serviceErrorIds(String ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

