/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.opsworks.model.OpsWorksResponse;
import software.amazon.awssdk.services.opsworks.model.Stack;
import software.amazon.awssdk.services.opsworks.model.StacksCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeStacksResponse
extends OpsWorksResponse
implements ToCopyableBuilder<Builder, DescribeStacksResponse> {
    private final List<Stack> stacks;

    private DescribeStacksResponse(BuilderImpl builder) {
        super(builder);
        this.stacks = builder.stacks;
    }

    public List<Stack> stacks() {
        return this.stacks;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stacks());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStacksResponse)) {
            return false;
        }
        DescribeStacksResponse other = (DescribeStacksResponse)((Object)obj);
        return Objects.equals(this.stacks(), other.stacks());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.stacks() != null) {
            sb.append("Stacks: ").append(this.stacks()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Stacks": {
                return Optional.of(clazz.cast(this.stacks()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends OpsWorksResponse.BuilderImpl
    implements Builder {
        private List<Stack> stacks;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStacksResponse model) {
            this.stacks(model.stacks);
        }

        public final Collection<Stack.Builder> getStacks() {
            return this.stacks != null ? (Collection)this.stacks.stream().map(Stack::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder stacks(Collection<Stack> stacks) {
            this.stacks = StacksCopier.copy(stacks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stacks(Stack ... stacks) {
            this.stacks(Arrays.asList(stacks));
            return this;
        }

        public final void setStacks(Collection<Stack.BuilderImpl> stacks) {
            this.stacks = StacksCopier.copyFromBuilder(stacks);
        }

        @Override
        public DescribeStacksResponse build() {
            return new DescribeStacksResponse(this);
        }
    }

    public static interface Builder
    extends OpsWorksResponse.Builder,
    CopyableBuilder<Builder, DescribeStacksResponse> {
        public Builder stacks(Collection<Stack> var1);

        public Builder stacks(Stack ... var1);
    }
}

