/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.transform.RdsDbInstanceMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RdsDbInstance
implements StructuredPojo,
ToCopyableBuilder<Builder, RdsDbInstance> {
    private final String rdsDbInstanceArn;
    private final String dbInstanceIdentifier;
    private final String dbUser;
    private final String dbPassword;
    private final String region;
    private final String address;
    private final String engine;
    private final String stackId;
    private final Boolean missingOnRds;

    private RdsDbInstance(BuilderImpl builder) {
        this.rdsDbInstanceArn = builder.rdsDbInstanceArn;
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.dbUser = builder.dbUser;
        this.dbPassword = builder.dbPassword;
        this.region = builder.region;
        this.address = builder.address;
        this.engine = builder.engine;
        this.stackId = builder.stackId;
        this.missingOnRds = builder.missingOnRds;
    }

    public String rdsDbInstanceArn() {
        return this.rdsDbInstanceArn;
    }

    public String dbInstanceIdentifier() {
        return this.dbInstanceIdentifier;
    }

    public String dbUser() {
        return this.dbUser;
    }

    public String dbPassword() {
        return this.dbPassword;
    }

    public String region() {
        return this.region;
    }

    public String address() {
        return this.address;
    }

    public String engine() {
        return this.engine;
    }

    public String stackId() {
        return this.stackId;
    }

    public Boolean missingOnRds() {
        return this.missingOnRds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.rdsDbInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbUser());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbPassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.address());
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.missingOnRds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RdsDbInstance)) {
            return false;
        }
        RdsDbInstance other = (RdsDbInstance)obj;
        return Objects.equals(this.rdsDbInstanceArn(), other.rdsDbInstanceArn()) && Objects.equals(this.dbInstanceIdentifier(), other.dbInstanceIdentifier()) && Objects.equals(this.dbUser(), other.dbUser()) && Objects.equals(this.dbPassword(), other.dbPassword()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.address(), other.address()) && Objects.equals(this.engine(), other.engine()) && Objects.equals(this.stackId(), other.stackId()) && Objects.equals(this.missingOnRds(), other.missingOnRds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.rdsDbInstanceArn() != null) {
            sb.append("RdsDbInstanceArn: ").append(this.rdsDbInstanceArn()).append(",");
        }
        if (this.dbInstanceIdentifier() != null) {
            sb.append("DbInstanceIdentifier: ").append(this.dbInstanceIdentifier()).append(",");
        }
        if (this.dbUser() != null) {
            sb.append("DbUser: ").append(this.dbUser()).append(",");
        }
        if (this.dbPassword() != null) {
            sb.append("DbPassword: ").append(this.dbPassword()).append(",");
        }
        if (this.region() != null) {
            sb.append("Region: ").append(this.region()).append(",");
        }
        if (this.address() != null) {
            sb.append("Address: ").append(this.address()).append(",");
        }
        if (this.engine() != null) {
            sb.append("Engine: ").append(this.engine()).append(",");
        }
        if (this.stackId() != null) {
            sb.append("StackId: ").append(this.stackId()).append(",");
        }
        if (this.missingOnRds() != null) {
            sb.append("MissingOnRds: ").append(this.missingOnRds()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RdsDbInstanceArn": {
                return Optional.of(clazz.cast(this.rdsDbInstanceArn()));
            }
            case "DbInstanceIdentifier": {
                return Optional.of(clazz.cast(this.dbInstanceIdentifier()));
            }
            case "DbUser": {
                return Optional.of(clazz.cast(this.dbUser()));
            }
            case "DbPassword": {
                return Optional.of(clazz.cast(this.dbPassword()));
            }
            case "Region": {
                return Optional.of(clazz.cast(this.region()));
            }
            case "Address": {
                return Optional.of(clazz.cast(this.address()));
            }
            case "Engine": {
                return Optional.of(clazz.cast(this.engine()));
            }
            case "StackId": {
                return Optional.of(clazz.cast(this.stackId()));
            }
            case "MissingOnRds": {
                return Optional.of(clazz.cast(this.missingOnRds()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RdsDbInstanceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String rdsDbInstanceArn;
        private String dbInstanceIdentifier;
        private String dbUser;
        private String dbPassword;
        private String region;
        private String address;
        private String engine;
        private String stackId;
        private Boolean missingOnRds;

        private BuilderImpl() {
        }

        private BuilderImpl(RdsDbInstance model) {
            this.rdsDbInstanceArn(model.rdsDbInstanceArn);
            this.dbInstanceIdentifier(model.dbInstanceIdentifier);
            this.dbUser(model.dbUser);
            this.dbPassword(model.dbPassword);
            this.region(model.region);
            this.address(model.address);
            this.engine(model.engine);
            this.stackId(model.stackId);
            this.missingOnRds(model.missingOnRds);
        }

        public final String getRdsDbInstanceArn() {
            return this.rdsDbInstanceArn;
        }

        @Override
        public final Builder rdsDbInstanceArn(String rdsDbInstanceArn) {
            this.rdsDbInstanceArn = rdsDbInstanceArn;
            return this;
        }

        public final void setRdsDbInstanceArn(String rdsDbInstanceArn) {
            this.rdsDbInstanceArn = rdsDbInstanceArn;
        }

        public final String getDbInstanceIdentifier() {
            return this.dbInstanceIdentifier;
        }

        @Override
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final void setDbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        public final String getDbUser() {
            return this.dbUser;
        }

        @Override
        public final Builder dbUser(String dbUser) {
            this.dbUser = dbUser;
            return this;
        }

        public final void setDbUser(String dbUser) {
            this.dbUser = dbUser;
        }

        public final String getDbPassword() {
            return this.dbPassword;
        }

        @Override
        public final Builder dbPassword(String dbPassword) {
            this.dbPassword = dbPassword;
            return this;
        }

        public final void setDbPassword(String dbPassword) {
            this.dbPassword = dbPassword;
        }

        public final String getRegion() {
            return this.region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final String getAddress() {
            return this.address;
        }

        @Override
        public final Builder address(String address) {
            this.address = address;
            return this;
        }

        public final void setAddress(String address) {
            this.address = address;
        }

        public final String getEngine() {
            return this.engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final Boolean getMissingOnRds() {
            return this.missingOnRds;
        }

        @Override
        public final Builder missingOnRds(Boolean missingOnRds) {
            this.missingOnRds = missingOnRds;
            return this;
        }

        public final void setMissingOnRds(Boolean missingOnRds) {
            this.missingOnRds = missingOnRds;
        }

        public RdsDbInstance build() {
            return new RdsDbInstance(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RdsDbInstance> {
        public Builder rdsDbInstanceArn(String var1);

        public Builder dbInstanceIdentifier(String var1);

        public Builder dbUser(String var1);

        public Builder dbPassword(String var1);

        public Builder region(String var1);

        public Builder address(String var1);

        public Builder engine(String var1);

        public Builder stackId(String var1);

        public Builder missingOnRds(Boolean var1);
    }
}

