/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.opsworks.model.DescribeCommandsRequest;

@SdkInternalApi
public class DescribeCommandsRequestModelMarshaller {
    private static final MarshallingInfo<String> DEPLOYMENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeploymentId").build();
    private static final MarshallingInfo<String> INSTANCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceId").build();
    private static final MarshallingInfo<List> COMMANDIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CommandIds").build();
    private static final DescribeCommandsRequestModelMarshaller INSTANCE = new DescribeCommandsRequestModelMarshaller();

    public static DescribeCommandsRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DescribeCommandsRequest describeCommandsRequest, ProtocolMarshaller protocolMarshaller) {
        if (describeCommandsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)describeCommandsRequest.deploymentId(), DEPLOYMENTID_BINDING);
            protocolMarshaller.marshall((Object)describeCommandsRequest.instanceId(), INSTANCEID_BINDING);
            protocolMarshaller.marshall(describeCommandsRequest.commandIds(), COMMANDIDS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

