/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.opsworks.model.Permission;

@SdkInternalApi
public class PermissionMarshaller {
    private static final MarshallingInfo<String> STACKID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StackId").build();
    private static final MarshallingInfo<String> IAMUSERARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IamUserArn").build();
    private static final MarshallingInfo<Boolean> ALLOWSSH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AllowSsh").build();
    private static final MarshallingInfo<Boolean> ALLOWSUDO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AllowSudo").build();
    private static final MarshallingInfo<String> LEVEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Level").build();
    private static final PermissionMarshaller INSTANCE = new PermissionMarshaller();

    public static PermissionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Permission permission, ProtocolMarshaller protocolMarshaller) {
        if (permission == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)permission.stackId(), STACKID_BINDING);
            protocolMarshaller.marshall((Object)permission.iamUserArn(), IAMUSERARN_BINDING);
            protocolMarshaller.marshall((Object)permission.allowSsh(), ALLOWSSH_BINDING);
            protocolMarshaller.marshall((Object)permission.allowSudo(), ALLOWSUDO_BINDING);
            protocolMarshaller.marshall((Object)permission.level(), LEVEL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

