/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.transform.CloudWatchLogsConfigurationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the Amazon CloudWatch logs configuration for a layer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CloudWatchLogsConfiguration implements StructuredPojo,
        ToCopyableBuilder<CloudWatchLogsConfiguration.Builder, CloudWatchLogsConfiguration> {
    private final Boolean enabled;

    private final List<CloudWatchLogsLogStream> logStreams;

    private CloudWatchLogsConfiguration(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.logStreams = builder.logStreams;
    }

    /**
     * <p>
     * Whether CloudWatch Logs is enabled for a layer.
     * </p>
     * 
     * @return Whether CloudWatch Logs is enabled for a layer.
     */
    public Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * A list of configuration options for CloudWatch Logs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of configuration options for CloudWatch Logs.
     */
    public List<CloudWatchLogsLogStream> logStreams() {
        return logStreams;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(logStreams());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchLogsConfiguration)) {
            return false;
        }
        CloudWatchLogsConfiguration other = (CloudWatchLogsConfiguration) obj;
        return Objects.equals(enabled(), other.enabled()) && Objects.equals(logStreams(), other.logStreams());
    }

    @Override
    public String toString() {
        return ToString.builder("CloudWatchLogsConfiguration").add("Enabled", enabled()).add("LogStreams", logStreams()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Enabled":
            return Optional.of(clazz.cast(enabled()));
        case "LogStreams":
            return Optional.of(clazz.cast(logStreams()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CloudWatchLogsConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, CloudWatchLogsConfiguration> {
        /**
         * <p>
         * Whether CloudWatch Logs is enabled for a layer.
         * </p>
         * 
         * @param enabled
         *        Whether CloudWatch Logs is enabled for a layer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * A list of configuration options for CloudWatch Logs.
         * </p>
         * 
         * @param logStreams
         *        A list of configuration options for CloudWatch Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logStreams(Collection<CloudWatchLogsLogStream> logStreams);

        /**
         * <p>
         * A list of configuration options for CloudWatch Logs.
         * </p>
         * 
         * @param logStreams
         *        A list of configuration options for CloudWatch Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logStreams(CloudWatchLogsLogStream... logStreams);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private List<CloudWatchLogsLogStream> logStreams;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudWatchLogsConfiguration model) {
            enabled(model.enabled);
            logStreams(model.logStreams);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final Collection<CloudWatchLogsLogStream.Builder> getLogStreams() {
            return logStreams != null ? logStreams.stream().map(CloudWatchLogsLogStream::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder logStreams(Collection<CloudWatchLogsLogStream> logStreams) {
            this.logStreams = CloudWatchLogsLogStreamsCopier.copy(logStreams);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logStreams(CloudWatchLogsLogStream... logStreams) {
            logStreams(Arrays.asList(logStreams));
            return this;
        }

        public final void setLogStreams(Collection<CloudWatchLogsLogStream.BuilderImpl> logStreams) {
            this.logStreams = CloudWatchLogsLogStreamsCopier.copyFromBuilder(logStreams);
        }

        @Override
        public CloudWatchLogsConfiguration build() {
            return new CloudWatchLogsConfiguration(this);
        }
    }
}
