/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a <code>DescribeAgentVersions</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeAgentVersionsResponse extends OpsWorksResponse implements
        ToCopyableBuilder<DescribeAgentVersionsResponse.Builder, DescribeAgentVersionsResponse> {
    private final List<AgentVersion> agentVersions;

    private DescribeAgentVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.agentVersions = builder.agentVersions;
    }

    /**
     * <p>
     * The agent versions for the specified stack or configuration manager. Note that this value is the complete version
     * number, not the abbreviated number used by the console.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The agent versions for the specified stack or configuration manager. Note that this value is the complete
     *         version number, not the abbreviated number used by the console.
     */
    public List<AgentVersion> agentVersions() {
        return agentVersions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(agentVersions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAgentVersionsResponse)) {
            return false;
        }
        DescribeAgentVersionsResponse other = (DescribeAgentVersionsResponse) obj;
        return Objects.equals(agentVersions(), other.agentVersions());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeAgentVersionsResponse").add("AgentVersions", agentVersions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AgentVersions":
            return Optional.of(clazz.cast(agentVersions()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends OpsWorksResponse.Builder, CopyableBuilder<Builder, DescribeAgentVersionsResponse> {
        /**
         * <p>
         * The agent versions for the specified stack or configuration manager. Note that this value is the complete
         * version number, not the abbreviated number used by the console.
         * </p>
         * 
         * @param agentVersions
         *        The agent versions for the specified stack or configuration manager. Note that this value is the
         *        complete version number, not the abbreviated number used by the console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentVersions(Collection<AgentVersion> agentVersions);

        /**
         * <p>
         * The agent versions for the specified stack or configuration manager. Note that this value is the complete
         * version number, not the abbreviated number used by the console.
         * </p>
         * 
         * @param agentVersions
         *        The agent versions for the specified stack or configuration manager. Note that this value is the
         *        complete version number, not the abbreviated number used by the console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentVersions(AgentVersion... agentVersions);
    }

    static final class BuilderImpl extends OpsWorksResponse.BuilderImpl implements Builder {
        private List<AgentVersion> agentVersions;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAgentVersionsResponse model) {
            agentVersions(model.agentVersions);
        }

        public final Collection<AgentVersion.Builder> getAgentVersions() {
            return agentVersions != null ? agentVersions.stream().map(AgentVersion::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder agentVersions(Collection<AgentVersion> agentVersions) {
            this.agentVersions = AgentVersionsCopier.copy(agentVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentVersions(AgentVersion... agentVersions) {
            agentVersions(Arrays.asList(agentVersions));
            return this;
        }

        public final void setAgentVersions(Collection<AgentVersion.BuilderImpl> agentVersions) {
            this.agentVersions = AgentVersionsCopier.copyFromBuilder(agentVersions);
        }

        @Override
        public DescribeAgentVersionsResponse build() {
            return new DescribeAgentVersionsResponse(this);
        }
    }
}
