/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a <code>DescribeLayers</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeLayersResponse extends OpsWorksResponse implements
        ToCopyableBuilder<DescribeLayersResponse.Builder, DescribeLayersResponse> {
    private final List<Layer> layers;

    private DescribeLayersResponse(BuilderImpl builder) {
        super(builder);
        this.layers = builder.layers;
    }

    /**
     * <p>
     * An array of <code>Layer</code> objects that describe the layers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of <code>Layer</code> objects that describe the layers.
     */
    public List<Layer> layers() {
        return layers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(layers());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLayersResponse)) {
            return false;
        }
        DescribeLayersResponse other = (DescribeLayersResponse) obj;
        return Objects.equals(layers(), other.layers());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeLayersResponse").add("Layers", layers()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Layers":
            return Optional.of(clazz.cast(layers()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends OpsWorksResponse.Builder, CopyableBuilder<Builder, DescribeLayersResponse> {
        /**
         * <p>
         * An array of <code>Layer</code> objects that describe the layers.
         * </p>
         * 
         * @param layers
         *        An array of <code>Layer</code> objects that describe the layers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layers(Collection<Layer> layers);

        /**
         * <p>
         * An array of <code>Layer</code> objects that describe the layers.
         * </p>
         * 
         * @param layers
         *        An array of <code>Layer</code> objects that describe the layers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layers(Layer... layers);
    }

    static final class BuilderImpl extends OpsWorksResponse.BuilderImpl implements Builder {
        private List<Layer> layers;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLayersResponse model) {
            layers(model.layers);
        }

        public final Collection<Layer.Builder> getLayers() {
            return layers != null ? layers.stream().map(Layer::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder layers(Collection<Layer> layers) {
            this.layers = LayersCopier.copy(layers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layers(Layer... layers) {
            layers(Arrays.asList(layers));
            return this;
        }

        public final void setLayers(Collection<Layer.BuilderImpl> layers) {
            this.layers = LayersCopier.copyFromBuilder(layers);
        }

        @Override
        public DescribeLayersResponse build() {
            return new DescribeLayersResponse(this);
        }
    }
}
