/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeRaidArraysRequest extends OpsWorksRequest implements
        ToCopyableBuilder<DescribeRaidArraysRequest.Builder, DescribeRaidArraysRequest> {
    private final String instanceId;

    private final String stackId;

    private final List<String> raidArrayIds;

    private DescribeRaidArraysRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.stackId = builder.stackId;
        this.raidArrayIds = builder.raidArrayIds;
    }

    /**
     * <p>
     * The instance ID. If you use this parameter, <code>DescribeRaidArrays</code> returns descriptions of the RAID
     * arrays associated with the specified instance.
     * </p>
     * 
     * @return The instance ID. If you use this parameter, <code>DescribeRaidArrays</code> returns descriptions of the
     *         RAID arrays associated with the specified instance.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The stack ID.
     * </p>
     * 
     * @return The stack ID.
     */
    public String stackId() {
        return stackId;
    }

    /**
     * <p>
     * An array of RAID array IDs. If you use this parameter, <code>DescribeRaidArrays</code> returns descriptions of
     * the specified arrays. Otherwise, it returns a description of every array.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of RAID array IDs. If you use this parameter, <code>DescribeRaidArrays</code> returns
     *         descriptions of the specified arrays. Otherwise, it returns a description of every array.
     */
    public List<String> raidArrayIds() {
        return raidArrayIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(stackId());
        hashCode = 31 * hashCode + Objects.hashCode(raidArrayIds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRaidArraysRequest)) {
            return false;
        }
        DescribeRaidArraysRequest other = (DescribeRaidArraysRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(stackId(), other.stackId())
                && Objects.equals(raidArrayIds(), other.raidArrayIds());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeRaidArraysRequest").add("InstanceId", instanceId()).add("StackId", stackId())
                .add("RaidArrayIds", raidArrayIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.of(clazz.cast(instanceId()));
        case "StackId":
            return Optional.of(clazz.cast(stackId()));
        case "RaidArrayIds":
            return Optional.of(clazz.cast(raidArrayIds()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends OpsWorksRequest.Builder, CopyableBuilder<Builder, DescribeRaidArraysRequest> {
        /**
         * <p>
         * The instance ID. If you use this parameter, <code>DescribeRaidArrays</code> returns descriptions of the RAID
         * arrays associated with the specified instance.
         * </p>
         * 
         * @param instanceId
         *        The instance ID. If you use this parameter, <code>DescribeRaidArrays</code> returns descriptions of
         *        the RAID arrays associated with the specified instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The stack ID.
         * </p>
         * 
         * @param stackId
         *        The stack ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * An array of RAID array IDs. If you use this parameter, <code>DescribeRaidArrays</code> returns descriptions
         * of the specified arrays. Otherwise, it returns a description of every array.
         * </p>
         * 
         * @param raidArrayIds
         *        An array of RAID array IDs. If you use this parameter, <code>DescribeRaidArrays</code> returns
         *        descriptions of the specified arrays. Otherwise, it returns a description of every array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder raidArrayIds(Collection<String> raidArrayIds);

        /**
         * <p>
         * An array of RAID array IDs. If you use this parameter, <code>DescribeRaidArrays</code> returns descriptions
         * of the specified arrays. Otherwise, it returns a description of every array.
         * </p>
         * 
         * @param raidArrayIds
         *        An array of RAID array IDs. If you use this parameter, <code>DescribeRaidArrays</code> returns
         *        descriptions of the specified arrays. Otherwise, it returns a description of every array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder raidArrayIds(String... raidArrayIds);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends OpsWorksRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String stackId;

        private List<String> raidArrayIds;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRaidArraysRequest model) {
            instanceId(model.instanceId);
            stackId(model.stackId);
            raidArrayIds(model.raidArrayIds);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getStackId() {
            return stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final Collection<String> getRaidArrayIds() {
            return raidArrayIds;
        }

        @Override
        public final Builder raidArrayIds(Collection<String> raidArrayIds) {
            this.raidArrayIds = StringsCopier.copy(raidArrayIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder raidArrayIds(String... raidArrayIds) {
            raidArrayIds(Arrays.asList(raidArrayIds));
            return this;
        }

        public final void setRaidArrayIds(Collection<String> raidArrayIds) {
            this.raidArrayIds = StringsCopier.copy(raidArrayIds);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeRaidArraysRequest build() {
            return new DescribeRaidArraysRequest(this);
        }
    }
}
