/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class RegisterEcsClusterRequest extends OpsWorksRequest implements
        ToCopyableBuilder<RegisterEcsClusterRequest.Builder, RegisterEcsClusterRequest> {
    private final String ecsClusterArn;

    private final String stackId;

    private RegisterEcsClusterRequest(BuilderImpl builder) {
        super(builder);
        this.ecsClusterArn = builder.ecsClusterArn;
        this.stackId = builder.stackId;
    }

    /**
     * <p>
     * The cluster's ARN.
     * </p>
     * 
     * @return The cluster's ARN.
     */
    public String ecsClusterArn() {
        return ecsClusterArn;
    }

    /**
     * <p>
     * The stack ID.
     * </p>
     * 
     * @return The stack ID.
     */
    public String stackId() {
        return stackId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ecsClusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(stackId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterEcsClusterRequest)) {
            return false;
        }
        RegisterEcsClusterRequest other = (RegisterEcsClusterRequest) obj;
        return Objects.equals(ecsClusterArn(), other.ecsClusterArn()) && Objects.equals(stackId(), other.stackId());
    }

    @Override
    public String toString() {
        return ToString.builder("RegisterEcsClusterRequest").add("EcsClusterArn", ecsClusterArn()).add("StackId", stackId())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EcsClusterArn":
            return Optional.of(clazz.cast(ecsClusterArn()));
        case "StackId":
            return Optional.of(clazz.cast(stackId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends OpsWorksRequest.Builder, CopyableBuilder<Builder, RegisterEcsClusterRequest> {
        /**
         * <p>
         * The cluster's ARN.
         * </p>
         * 
         * @param ecsClusterArn
         *        The cluster's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecsClusterArn(String ecsClusterArn);

        /**
         * <p>
         * The stack ID.
         * </p>
         * 
         * @param stackId
         *        The stack ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends OpsWorksRequest.BuilderImpl implements Builder {
        private String ecsClusterArn;

        private String stackId;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterEcsClusterRequest model) {
            ecsClusterArn(model.ecsClusterArn);
            stackId(model.stackId);
        }

        public final String getEcsClusterArn() {
            return ecsClusterArn;
        }

        @Override
        public final Builder ecsClusterArn(String ecsClusterArn) {
            this.ecsClusterArn = ecsClusterArn;
            return this;
        }

        public final void setEcsClusterArn(String ecsClusterArn) {
            this.ecsClusterArn = ecsClusterArn;
        }

        public final String getStackId() {
            return stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public RegisterEcsClusterRequest build() {
            return new RegisterEcsClusterRequest(this);
        }
    }
}
