/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.opsworks.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * Instance JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class InstanceUnmarshaller implements Unmarshaller<Instance, JsonUnmarshallerContext> {

    public Instance unmarshall(JsonUnmarshallerContext context) throws Exception {
        Instance.Builder instanceBuilder = Instance.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("AgentVersion", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.agentVersion(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("AmiId", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.amiId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Architecture", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.architecture(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Arn", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.arn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("AutoScalingType", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.autoScalingType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("AvailabilityZone", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.availabilityZone(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("BlockDeviceMappings", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.blockDeviceMappings(new ListUnmarshaller<BlockDeviceMapping>(BlockDeviceMappingUnmarshaller
                            .getInstance()).unmarshall(context));
                }
                if (context.testExpression("CreatedAt", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.createdAt(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("EbsOptimized", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.ebsOptimized(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("Ec2InstanceId", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.ec2InstanceId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("EcsClusterArn", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.ecsClusterArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("EcsContainerInstanceArn", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.ecsContainerInstanceArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ElasticIp", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.elasticIp(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Hostname", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.hostname(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("InfrastructureClass", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.infrastructureClass(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("InstallUpdatesOnBoot", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.installUpdatesOnBoot(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("InstanceId", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.instanceId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("InstanceProfileArn", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.instanceProfileArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("InstanceType", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.instanceType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("LastServiceErrorId", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.lastServiceErrorId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("LayerIds", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.layerIds(new ListUnmarshaller<String>(context.getUnmarshaller(String.class))
                            .unmarshall(context));
                }
                if (context.testExpression("Os", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.os(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Platform", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.platform(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("PrivateDns", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.privateDns(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("PrivateIp", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.privateIp(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("PublicDns", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.publicDns(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("PublicIp", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.publicIp(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("RegisteredBy", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.registeredBy(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ReportedAgentVersion", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.reportedAgentVersion(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ReportedOs", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.reportedOs(ReportedOsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("RootDeviceType", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.rootDeviceType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("RootDeviceVolumeId", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.rootDeviceVolumeId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("SecurityGroupIds", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.securityGroupIds(new ListUnmarshaller<String>(context.getUnmarshaller(String.class))
                            .unmarshall(context));
                }
                if (context.testExpression("SshHostDsaKeyFingerprint", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.sshHostDsaKeyFingerprint(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("SshHostRsaKeyFingerprint", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.sshHostRsaKeyFingerprint(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("SshKeyName", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.sshKeyName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("StackId", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.stackId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Status", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.status(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("SubnetId", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.subnetId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Tenancy", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.tenancy(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("VirtualizationType", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.virtualizationType(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return instanceBuilder.build();
    }

    private static final InstanceUnmarshaller INSTANCE = new InstanceUnmarshaller();

    public static InstanceUnmarshaller getInstance() {
        return INSTANCE;
    }
}
