/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.opsworks.model.OpsWorksRequest;
import software.amazon.awssdk.services.opsworks.model.StringsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeCommandsRequest
extends OpsWorksRequest
implements ToCopyableBuilder<Builder, DescribeCommandsRequest> {
    private final String deploymentId;
    private final String instanceId;
    private final List<String> commandIds;

    private DescribeCommandsRequest(BuilderImpl builder) {
        super(builder);
        this.deploymentId = builder.deploymentId;
        this.instanceId = builder.instanceId;
        this.commandIds = builder.commandIds;
    }

    public String deploymentId() {
        return this.deploymentId;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public List<String> commandIds() {
        return this.commandIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.commandIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCommandsRequest)) {
            return false;
        }
        DescribeCommandsRequest other = (DescribeCommandsRequest)((Object)obj);
        return Objects.equals(this.deploymentId(), other.deploymentId()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.commandIds(), other.commandIds());
    }

    public String toString() {
        return ToString.builder((String)"DescribeCommandsRequest").add("DeploymentId", (Object)this.deploymentId()).add("InstanceId", (Object)this.instanceId()).add("CommandIds", this.commandIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeploymentId": {
                return Optional.of(clazz.cast(this.deploymentId()));
            }
            case "InstanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
            case "CommandIds": {
                return Optional.of(clazz.cast(this.commandIds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends OpsWorksRequest.BuilderImpl
    implements Builder {
        private String deploymentId;
        private String instanceId;
        private List<String> commandIds;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCommandsRequest model) {
            this.deploymentId(model.deploymentId);
            this.instanceId(model.instanceId);
            this.commandIds(model.commandIds);
        }

        public final String getDeploymentId() {
            return this.deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Collection<String> getCommandIds() {
            return this.commandIds;
        }

        @Override
        public final Builder commandIds(Collection<String> commandIds) {
            this.commandIds = StringsCopier.copy(commandIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commandIds(String ... commandIds) {
            this.commandIds(Arrays.asList(commandIds));
            return this;
        }

        public final void setCommandIds(Collection<String> commandIds) {
            this.commandIds = StringsCopier.copy(commandIds);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeCommandsRequest build() {
            return new DescribeCommandsRequest(this);
        }
    }

    public static interface Builder
    extends OpsWorksRequest.Builder,
    CopyableBuilder<Builder, DescribeCommandsRequest> {
        public Builder deploymentId(String var1);

        public Builder instanceId(String var1);

        public Builder commandIds(Collection<String> var1);

        public Builder commandIds(String ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

