/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class AttachElasticLoadBalancerRequest extends OpsWorksRequest implements
        ToCopyableBuilder<AttachElasticLoadBalancerRequest.Builder, AttachElasticLoadBalancerRequest> {
    private final String elasticLoadBalancerName;

    private final String layerId;

    private AttachElasticLoadBalancerRequest(BuilderImpl builder) {
        super(builder);
        this.elasticLoadBalancerName = builder.elasticLoadBalancerName;
        this.layerId = builder.layerId;
    }

    /**
     * <p>
     * The Elastic Load Balancing instance's name.
     * </p>
     * 
     * @return The Elastic Load Balancing instance's name.
     */
    public String elasticLoadBalancerName() {
        return elasticLoadBalancerName;
    }

    /**
     * <p>
     * The ID of the layer that the Elastic Load Balancing instance is to be attached to.
     * </p>
     * 
     * @return The ID of the layer that the Elastic Load Balancing instance is to be attached to.
     */
    public String layerId() {
        return layerId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(elasticLoadBalancerName());
        hashCode = 31 * hashCode + Objects.hashCode(layerId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachElasticLoadBalancerRequest)) {
            return false;
        }
        AttachElasticLoadBalancerRequest other = (AttachElasticLoadBalancerRequest) obj;
        return Objects.equals(elasticLoadBalancerName(), other.elasticLoadBalancerName())
                && Objects.equals(layerId(), other.layerId());
    }

    @Override
    public String toString() {
        return ToString.builder("AttachElasticLoadBalancerRequest").add("ElasticLoadBalancerName", elasticLoadBalancerName())
                .add("LayerId", layerId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ElasticLoadBalancerName":
            return Optional.of(clazz.cast(elasticLoadBalancerName()));
        case "LayerId":
            return Optional.of(clazz.cast(layerId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends OpsWorksRequest.Builder, CopyableBuilder<Builder, AttachElasticLoadBalancerRequest> {
        /**
         * <p>
         * The Elastic Load Balancing instance's name.
         * </p>
         * 
         * @param elasticLoadBalancerName
         *        The Elastic Load Balancing instance's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticLoadBalancerName(String elasticLoadBalancerName);

        /**
         * <p>
         * The ID of the layer that the Elastic Load Balancing instance is to be attached to.
         * </p>
         * 
         * @param layerId
         *        The ID of the layer that the Elastic Load Balancing instance is to be attached to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layerId(String layerId);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends OpsWorksRequest.BuilderImpl implements Builder {
        private String elasticLoadBalancerName;

        private String layerId;

        private BuilderImpl() {
        }

        private BuilderImpl(AttachElasticLoadBalancerRequest model) {
            elasticLoadBalancerName(model.elasticLoadBalancerName);
            layerId(model.layerId);
        }

        public final String getElasticLoadBalancerName() {
            return elasticLoadBalancerName;
        }

        @Override
        public final Builder elasticLoadBalancerName(String elasticLoadBalancerName) {
            this.elasticLoadBalancerName = elasticLoadBalancerName;
            return this;
        }

        public final void setElasticLoadBalancerName(String elasticLoadBalancerName) {
            this.elasticLoadBalancerName = elasticLoadBalancerName;
        }

        public final String getLayerId() {
            return layerId;
        }

        @Override
        public final Builder layerId(String layerId) {
            this.layerId = layerId;
            return this;
        }

        public final void setLayerId(String layerId) {
            this.layerId = layerId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public AttachElasticLoadBalancerRequest build() {
            return new AttachElasticLoadBalancerRequest(this);
        }
    }
}
