/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.transform.ElasticIpMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an Elastic IP address.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ElasticIp implements StructuredPojo, ToCopyableBuilder<ElasticIp.Builder, ElasticIp> {
    private final String ip;

    private final String name;

    private final String domain;

    private final String region;

    private final String instanceId;

    private ElasticIp(BuilderImpl builder) {
        this.ip = builder.ip;
        this.name = builder.name;
        this.domain = builder.domain;
        this.region = builder.region;
        this.instanceId = builder.instanceId;
    }

    /**
     * <p>
     * The IP address.
     * </p>
     * 
     * @return The IP address.
     */
    public String ip() {
        return ip;
    }

    /**
     * <p>
     * The name.
     * </p>
     * 
     * @return The name.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The domain.
     * </p>
     * 
     * @return The domain.
     */
    public String domain() {
        return domain;
    }

    /**
     * <p>
     * The AWS region. For more information, see <a
     * href="http://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.
     * </p>
     * 
     * @return The AWS region. For more information, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.
     */
    public String region() {
        return region;
    }

    /**
     * <p>
     * The ID of the instance that the address is attached to.
     * </p>
     * 
     * @return The ID of the instance that the address is attached to.
     */
    public String instanceId() {
        return instanceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ip());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ElasticIp)) {
            return false;
        }
        ElasticIp other = (ElasticIp) obj;
        return Objects.equals(ip(), other.ip()) && Objects.equals(name(), other.name())
                && Objects.equals(domain(), other.domain()) && Objects.equals(region(), other.region())
                && Objects.equals(instanceId(), other.instanceId());
    }

    @Override
    public String toString() {
        return ToString.builder("ElasticIp").add("Ip", ip()).add("Name", name()).add("Domain", domain()).add("Region", region())
                .add("InstanceId", instanceId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Ip":
            return Optional.of(clazz.cast(ip()));
        case "Name":
            return Optional.of(clazz.cast(name()));
        case "Domain":
            return Optional.of(clazz.cast(domain()));
        case "Region":
            return Optional.of(clazz.cast(region()));
        case "InstanceId":
            return Optional.of(clazz.cast(instanceId()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ElasticIpMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ElasticIp> {
        /**
         * <p>
         * The IP address.
         * </p>
         * 
         * @param ip
         *        The IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ip(String ip);

        /**
         * <p>
         * The name.
         * </p>
         * 
         * @param name
         *        The name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The domain.
         * </p>
         * 
         * @param domain
         *        The domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * The AWS region. For more information, see <a
         * href="http://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.
         * </p>
         * 
         * @param region
         *        The AWS region. For more information, see <a
         *        href="http://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The ID of the instance that the address is attached to.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance that the address is attached to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);
    }

    static final class BuilderImpl implements Builder {
        private String ip;

        private String name;

        private String domain;

        private String region;

        private String instanceId;

        private BuilderImpl() {
        }

        private BuilderImpl(ElasticIp model) {
            ip(model.ip);
            name(model.name);
            domain(model.domain);
            region(model.region);
            instanceId(model.instanceId);
        }

        public final String getIp() {
            return ip;
        }

        @Override
        public final Builder ip(String ip) {
            this.ip = ip;
            return this;
        }

        public final void setIp(String ip) {
            this.ip = ip;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDomain() {
            return domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final String getRegion() {
            return region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public ElasticIp build() {
            return new ElasticIp(this);
        }
    }
}
