/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import static java.util.stream.Collectors.toSet;

import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Generated;

@Generated("software.amazon.awssdk:codegen")
public enum LayerAttributesKeys {
    ECS_CLUSTER_ARN("EcsClusterArn"),

    ENABLE_HAPROXY_STATS("EnableHaproxyStats"),

    HAPROXY_STATS_URL("HaproxyStatsUrl"),

    HAPROXY_STATS_USER("HaproxyStatsUser"),

    HAPROXY_STATS_PASSWORD("HaproxyStatsPassword"),

    HAPROXY_HEALTH_CHECK_URL("HaproxyHealthCheckUrl"),

    HAPROXY_HEALTH_CHECK_METHOD("HaproxyHealthCheckMethod"),

    MYSQL_ROOT_PASSWORD("MysqlRootPassword"),

    MYSQL_ROOT_PASSWORD_UBIQUITOUS("MysqlRootPasswordUbiquitous"),

    GANGLIA_URL("GangliaUrl"),

    GANGLIA_USER("GangliaUser"),

    GANGLIA_PASSWORD("GangliaPassword"),

    MEMCACHED_MEMORY("MemcachedMemory"),

    NODEJS_VERSION("NodejsVersion"),

    RUBY_VERSION("RubyVersion"),

    RUBYGEMS_VERSION("RubygemsVersion"),

    MANAGE_BUNDLER("ManageBundler"),

    BUNDLER_VERSION("BundlerVersion"),

    RAILS_STACK("RailsStack"),

    PASSENGER_VERSION("PassengerVersion"),

    JVM("Jvm"),

    JVM_VERSION("JvmVersion"),

    JVM_OPTIONS("JvmOptions"),

    JAVA_APP_SERVER("JavaAppServer"),

    JAVA_APP_SERVER_VERSION("JavaAppServerVersion"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private LayerAttributesKeys(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return LayerAttributesKeys corresponding to the value
     */
    public static LayerAttributesKeys fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(LayerAttributesKeys.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link LayerAttributesKeys}s
     */
    public static Set<LayerAttributesKeys> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(toSet());
    }
}
