/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.transform.TemporaryCredentialMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the data needed by RDP clients such as the Microsoft Remote Desktop Connection to log in to the instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class TemporaryCredential implements StructuredPojo, ToCopyableBuilder<TemporaryCredential.Builder, TemporaryCredential> {
    private final String username;

    private final String password;

    private final Integer validForInMinutes;

    private final String instanceId;

    private TemporaryCredential(BuilderImpl builder) {
        this.username = builder.username;
        this.password = builder.password;
        this.validForInMinutes = builder.validForInMinutes;
        this.instanceId = builder.instanceId;
    }

    /**
     * <p>
     * The user name.
     * </p>
     * 
     * @return The user name.
     */
    public String username() {
        return username;
    }

    /**
     * <p>
     * The password.
     * </p>
     * 
     * @return The password.
     */
    public String password() {
        return password;
    }

    /**
     * <p>
     * The length of time (in minutes) that the grant is valid. When the grant expires, at the end of this period, the
     * user will no longer be able to use the credentials to log in. If they are logged in at the time, they will be
     * automatically logged out.
     * </p>
     * 
     * @return The length of time (in minutes) that the grant is valid. When the grant expires, at the end of this
     *         period, the user will no longer be able to use the credentials to log in. If they are logged in at the
     *         time, they will be automatically logged out.
     */
    public Integer validForInMinutes() {
        return validForInMinutes;
    }

    /**
     * <p>
     * The instance's AWS OpsWorks Stacks ID.
     * </p>
     * 
     * @return The instance's AWS OpsWorks Stacks ID.
     */
    public String instanceId() {
        return instanceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(username());
        hashCode = 31 * hashCode + Objects.hashCode(password());
        hashCode = 31 * hashCode + Objects.hashCode(validForInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TemporaryCredential)) {
            return false;
        }
        TemporaryCredential other = (TemporaryCredential) obj;
        return Objects.equals(username(), other.username()) && Objects.equals(password(), other.password())
                && Objects.equals(validForInMinutes(), other.validForInMinutes())
                && Objects.equals(instanceId(), other.instanceId());
    }

    @Override
    public String toString() {
        return ToString.builder("TemporaryCredential").add("Username", username()).add("Password", password())
                .add("ValidForInMinutes", validForInMinutes()).add("InstanceId", instanceId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Username":
            return Optional.of(clazz.cast(username()));
        case "Password":
            return Optional.of(clazz.cast(password()));
        case "ValidForInMinutes":
            return Optional.of(clazz.cast(validForInMinutes()));
        case "InstanceId":
            return Optional.of(clazz.cast(instanceId()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TemporaryCredentialMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, TemporaryCredential> {
        /**
         * <p>
         * The user name.
         * </p>
         * 
         * @param username
         *        The user name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);

        /**
         * <p>
         * The password.
         * </p>
         * 
         * @param password
         *        The password.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder password(String password);

        /**
         * <p>
         * The length of time (in minutes) that the grant is valid. When the grant expires, at the end of this period,
         * the user will no longer be able to use the credentials to log in. If they are logged in at the time, they
         * will be automatically logged out.
         * </p>
         * 
         * @param validForInMinutes
         *        The length of time (in minutes) that the grant is valid. When the grant expires, at the end of this
         *        period, the user will no longer be able to use the credentials to log in. If they are logged in at the
         *        time, they will be automatically logged out.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validForInMinutes(Integer validForInMinutes);

        /**
         * <p>
         * The instance's AWS OpsWorks Stacks ID.
         * </p>
         * 
         * @param instanceId
         *        The instance's AWS OpsWorks Stacks ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);
    }

    static final class BuilderImpl implements Builder {
        private String username;

        private String password;

        private Integer validForInMinutes;

        private String instanceId;

        private BuilderImpl() {
        }

        private BuilderImpl(TemporaryCredential model) {
            username(model.username);
            password(model.password);
            validForInMinutes(model.validForInMinutes);
            instanceId(model.instanceId);
        }

        public final String getUsername() {
            return username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final String getPassword() {
            return password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        public final Integer getValidForInMinutes() {
            return validForInMinutes;
        }

        @Override
        public final Builder validForInMinutes(Integer validForInMinutes) {
            this.validForInMinutes = validForInMinutes;
            return this;
        }

        public final void setValidForInMinutes(Integer validForInMinutes) {
            this.validForInMinutes = validForInMinutes;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public TemporaryCredential build() {
            return new TemporaryCredential(this);
        }
    }
}
