/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateAppRequest extends OpsWorksRequest implements ToCopyableBuilder<UpdateAppRequest.Builder, UpdateAppRequest> {
    private final String appId;

    private final String name;

    private final String description;

    private final List<DataSource> dataSources;

    private final String type;

    private final Source appSource;

    private final List<String> domains;

    private final Boolean enableSsl;

    private final SslConfiguration sslConfiguration;

    private final Map<String, String> attributes;

    private final List<EnvironmentVariable> environment;

    private UpdateAppRequest(BuilderImpl builder) {
        super(builder);
        this.appId = builder.appId;
        this.name = builder.name;
        this.description = builder.description;
        this.dataSources = builder.dataSources;
        this.type = builder.type;
        this.appSource = builder.appSource;
        this.domains = builder.domains;
        this.enableSsl = builder.enableSsl;
        this.sslConfiguration = builder.sslConfiguration;
        this.attributes = builder.attributes;
        this.environment = builder.environment;
    }

    /**
     * <p>
     * The app ID.
     * </p>
     * 
     * @return The app ID.
     */
    public String appId() {
        return appId;
    }

    /**
     * <p>
     * The app name.
     * </p>
     * 
     * @return The app name.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A description of the app.
     * </p>
     * 
     * @return A description of the app.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The app's data sources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The app's data sources.
     */
    public List<DataSource> dataSources() {
        return dataSources;
    }

    /**
     * <p>
     * The app type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AppType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeString}.
     * </p>
     * 
     * @return The app type.
     * @see AppType
     */
    public AppType type() {
        return AppType.fromValue(type);
    }

    /**
     * <p>
     * The app type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AppType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeString}.
     * </p>
     * 
     * @return The app type.
     * @see AppType
     */
    public String typeString() {
        return type;
    }

    /**
     * <p>
     * A <code>Source</code> object that specifies the app repository.
     * </p>
     * 
     * @return A <code>Source</code> object that specifies the app repository.
     */
    public Source appSource() {
        return appSource;
    }

    /**
     * <p>
     * The app's virtual host settings, with multiple domains separated by commas. For example:
     * <code>'www.example.com, example.com'</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The app's virtual host settings, with multiple domains separated by commas. For example:
     *         <code>'www.example.com, example.com'</code>
     */
    public List<String> domains() {
        return domains;
    }

    /**
     * <p>
     * Whether SSL is enabled for the app.
     * </p>
     * 
     * @return Whether SSL is enabled for the app.
     */
    public Boolean enableSsl() {
        return enableSsl;
    }

    /**
     * <p>
     * An <code>SslConfiguration</code> object with the SSL configuration.
     * </p>
     * 
     * @return An <code>SslConfiguration</code> object with the SSL configuration.
     */
    public SslConfiguration sslConfiguration() {
        return sslConfiguration;
    }

    /**
     * <p>
     * One or more user-defined key/value pairs to be added to the stack attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more user-defined key/value pairs to be added to the stack attributes.
     */
    public Map<AppAttributesKeys, String> attributes() {
        return TypeConverter.convert(attributes, AppAttributesKeys::fromValue, Function.identity(),
                (k, v) -> !Objects.equals(k, AppAttributesKeys.UNKNOWN_TO_SDK_VERSION));
    }

    /**
     * <p>
     * One or more user-defined key/value pairs to be added to the stack attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more user-defined key/value pairs to be added to the stack attributes.
     */
    public Map<String, String> attributesStrings() {
        return attributes;
    }

    /**
     * <p>
     * An array of <code>EnvironmentVariable</code> objects that specify environment variables to be associated with the
     * app. After you deploy the app, these variables are defined on the associated app server instances.For more
     * information, see <a href=
     * "http://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html#workingapps-creating-environment"
     * > Environment Variables</a>.
     * </p>
     * <p>
     * There is no specific limit on the number of environment variables. However, the size of the associated data
     * structure - which includes the variables' names, values, and protected flag values - cannot exceed 10 KB (10240
     * Bytes). This limit should accommodate most if not all use cases. Exceeding it will cause an exception with the
     * message, "Environment: is too large (maximum is 10KB)."
     * </p>
     * <note>
     * <p>
     * This parameter is supported only by Chef 11.10 stacks. If you have specified one or more environment variables,
     * you cannot modify the stack's Chef version.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of <code>EnvironmentVariable</code> objects that specify environment variables to be associated
     *         with the app. After you deploy the app, these variables are defined on the associated app server
     *         instances.For more information, see <a href=
     *         "http://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html#workingapps-creating-environment"
     *         > Environment Variables</a>.</p>
     *         <p>
     *         There is no specific limit on the number of environment variables. However, the size of the associated
     *         data structure - which includes the variables' names, values, and protected flag values - cannot exceed
     *         10 KB (10240 Bytes). This limit should accommodate most if not all use cases. Exceeding it will cause an
     *         exception with the message, "Environment: is too large (maximum is 10KB)."
     *         </p>
     *         <note>
     *         <p>
     *         This parameter is supported only by Chef 11.10 stacks. If you have specified one or more environment
     *         variables, you cannot modify the stack's Chef version.
     *         </p>
     */
    public List<EnvironmentVariable> environment() {
        return environment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(appId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(dataSources());
        hashCode = 31 * hashCode + Objects.hashCode(typeString());
        hashCode = 31 * hashCode + Objects.hashCode(appSource());
        hashCode = 31 * hashCode + Objects.hashCode(domains());
        hashCode = 31 * hashCode + Objects.hashCode(enableSsl());
        hashCode = 31 * hashCode + Objects.hashCode(sslConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(attributesStrings());
        hashCode = 31 * hashCode + Objects.hashCode(environment());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAppRequest)) {
            return false;
        }
        UpdateAppRequest other = (UpdateAppRequest) obj;
        return Objects.equals(appId(), other.appId()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(dataSources(), other.dataSources())
                && Objects.equals(typeString(), other.typeString()) && Objects.equals(appSource(), other.appSource())
                && Objects.equals(domains(), other.domains()) && Objects.equals(enableSsl(), other.enableSsl())
                && Objects.equals(sslConfiguration(), other.sslConfiguration())
                && Objects.equals(attributesStrings(), other.attributesStrings())
                && Objects.equals(environment(), other.environment());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateAppRequest").add("AppId", appId()).add("Name", name()).add("Description", description())
                .add("DataSources", dataSources()).add("Type", typeString()).add("AppSource", appSource())
                .add("Domains", domains()).add("EnableSsl", enableSsl()).add("SslConfiguration", sslConfiguration())
                .add("Attributes", attributesStrings()).add("Environment", environment()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppId":
            return Optional.of(clazz.cast(appId()));
        case "Name":
            return Optional.of(clazz.cast(name()));
        case "Description":
            return Optional.of(clazz.cast(description()));
        case "DataSources":
            return Optional.of(clazz.cast(dataSources()));
        case "Type":
            return Optional.of(clazz.cast(typeString()));
        case "AppSource":
            return Optional.of(clazz.cast(appSource()));
        case "Domains":
            return Optional.of(clazz.cast(domains()));
        case "EnableSsl":
            return Optional.of(clazz.cast(enableSsl()));
        case "SslConfiguration":
            return Optional.of(clazz.cast(sslConfiguration()));
        case "Attributes":
            return Optional.of(clazz.cast(attributesStrings()));
        case "Environment":
            return Optional.of(clazz.cast(environment()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends OpsWorksRequest.Builder, CopyableBuilder<Builder, UpdateAppRequest> {
        /**
         * <p>
         * The app ID.
         * </p>
         * 
         * @param appId
         *        The app ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appId(String appId);

        /**
         * <p>
         * The app name.
         * </p>
         * 
         * @param name
         *        The app name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the app.
         * </p>
         * 
         * @param description
         *        A description of the app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The app's data sources.
         * </p>
         * 
         * @param dataSources
         *        The app's data sources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSources(Collection<DataSource> dataSources);

        /**
         * <p>
         * The app's data sources.
         * </p>
         * 
         * @param dataSources
         *        The app's data sources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSources(DataSource... dataSources);

        /**
         * <p>
         * The app type.
         * </p>
         * 
         * @param type
         *        The app type.
         * @see AppType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppType
         */
        Builder type(String type);

        /**
         * <p>
         * The app type.
         * </p>
         * 
         * @param type
         *        The app type.
         * @see AppType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppType
         */
        Builder type(AppType type);

        /**
         * <p>
         * A <code>Source</code> object that specifies the app repository.
         * </p>
         * 
         * @param appSource
         *        A <code>Source</code> object that specifies the app repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appSource(Source appSource);

        /**
         * <p>
         * A <code>Source</code> object that specifies the app repository.
         * </p>
         * This is a convenience that creates an instance of the {@link Source.Builder} avoiding the need to create one
         * manually via {@link Source#builder()}.
         *
         * When the {@link Consumer} completes, {@link Source.Builder#build()} is called immediately and its result is
         * passed to {@link #appSource(Source)}.
         * 
         * @param appSource
         *        a consumer that will call methods on {@link Source.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #appSource(Source)
         */
        default Builder appSource(Consumer<Source.Builder> appSource) {
            return appSource(Source.builder().apply(appSource).build());
        }

        /**
         * <p>
         * The app's virtual host settings, with multiple domains separated by commas. For example:
         * <code>'www.example.com, example.com'</code>
         * </p>
         * 
         * @param domains
         *        The app's virtual host settings, with multiple domains separated by commas. For example:
         *        <code>'www.example.com, example.com'</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domains(Collection<String> domains);

        /**
         * <p>
         * The app's virtual host settings, with multiple domains separated by commas. For example:
         * <code>'www.example.com, example.com'</code>
         * </p>
         * 
         * @param domains
         *        The app's virtual host settings, with multiple domains separated by commas. For example:
         *        <code>'www.example.com, example.com'</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domains(String... domains);

        /**
         * <p>
         * Whether SSL is enabled for the app.
         * </p>
         * 
         * @param enableSsl
         *        Whether SSL is enabled for the app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableSsl(Boolean enableSsl);

        /**
         * <p>
         * An <code>SslConfiguration</code> object with the SSL configuration.
         * </p>
         * 
         * @param sslConfiguration
         *        An <code>SslConfiguration</code> object with the SSL configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sslConfiguration(SslConfiguration sslConfiguration);

        /**
         * <p>
         * An <code>SslConfiguration</code> object with the SSL configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link SslConfiguration.Builder} avoiding the need to
         * create one manually via {@link SslConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link SslConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #sslConfiguration(SslConfiguration)}.
         * 
         * @param sslConfiguration
         *        a consumer that will call methods on {@link SslConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sslConfiguration(SslConfiguration)
         */
        default Builder sslConfiguration(Consumer<SslConfiguration.Builder> sslConfiguration) {
            return sslConfiguration(SslConfiguration.builder().apply(sslConfiguration).build());
        }

        /**
         * <p>
         * One or more user-defined key/value pairs to be added to the stack attributes.
         * </p>
         * 
         * @param attributes
         *        One or more user-defined key/value pairs to be added to the stack attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);

        /**
         * <p>
         * An array of <code>EnvironmentVariable</code> objects that specify environment variables to be associated with
         * the app. After you deploy the app, these variables are defined on the associated app server instances.For
         * more information, see <a href=
         * "http://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html#workingapps-creating-environment"
         * > Environment Variables</a>.
         * </p>
         * <p>
         * There is no specific limit on the number of environment variables. However, the size of the associated data
         * structure - which includes the variables' names, values, and protected flag values - cannot exceed 10 KB
         * (10240 Bytes). This limit should accommodate most if not all use cases. Exceeding it will cause an exception
         * with the message, "Environment: is too large (maximum is 10KB)."
         * </p>
         * <note>
         * <p>
         * This parameter is supported only by Chef 11.10 stacks. If you have specified one or more environment
         * variables, you cannot modify the stack's Chef version.
         * </p>
         * </note>
         * 
         * @param environment
         *        An array of <code>EnvironmentVariable</code> objects that specify environment variables to be
         *        associated with the app. After you deploy the app, these variables are defined on the associated app
         *        server instances.For more information, see <a href=
         *        "http://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html#workingapps-creating-environment"
         *        > Environment Variables</a>.</p>
         *        <p>
         *        There is no specific limit on the number of environment variables. However, the size of the associated
         *        data structure - which includes the variables' names, values, and protected flag values - cannot
         *        exceed 10 KB (10240 Bytes). This limit should accommodate most if not all use cases. Exceeding it will
         *        cause an exception with the message, "Environment: is too large (maximum is 10KB)."
         *        </p>
         *        <note>
         *        <p>
         *        This parameter is supported only by Chef 11.10 stacks. If you have specified one or more environment
         *        variables, you cannot modify the stack's Chef version.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environment(Collection<EnvironmentVariable> environment);

        /**
         * <p>
         * An array of <code>EnvironmentVariable</code> objects that specify environment variables to be associated with
         * the app. After you deploy the app, these variables are defined on the associated app server instances.For
         * more information, see <a href=
         * "http://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html#workingapps-creating-environment"
         * > Environment Variables</a>.
         * </p>
         * <p>
         * There is no specific limit on the number of environment variables. However, the size of the associated data
         * structure - which includes the variables' names, values, and protected flag values - cannot exceed 10 KB
         * (10240 Bytes). This limit should accommodate most if not all use cases. Exceeding it will cause an exception
         * with the message, "Environment: is too large (maximum is 10KB)."
         * </p>
         * <note>
         * <p>
         * This parameter is supported only by Chef 11.10 stacks. If you have specified one or more environment
         * variables, you cannot modify the stack's Chef version.
         * </p>
         * </note>
         * 
         * @param environment
         *        An array of <code>EnvironmentVariable</code> objects that specify environment variables to be
         *        associated with the app. After you deploy the app, these variables are defined on the associated app
         *        server instances.For more information, see <a href=
         *        "http://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html#workingapps-creating-environment"
         *        > Environment Variables</a>.</p>
         *        <p>
         *        There is no specific limit on the number of environment variables. However, the size of the associated
         *        data structure - which includes the variables' names, values, and protected flag values - cannot
         *        exceed 10 KB (10240 Bytes). This limit should accommodate most if not all use cases. Exceeding it will
         *        cause an exception with the message, "Environment: is too large (maximum is 10KB)."
         *        </p>
         *        <note>
         *        <p>
         *        This parameter is supported only by Chef 11.10 stacks. If you have specified one or more environment
         *        variables, you cannot modify the stack's Chef version.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environment(EnvironmentVariable... environment);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends OpsWorksRequest.BuilderImpl implements Builder {
        private String appId;

        private String name;

        private String description;

        private List<DataSource> dataSources;

        private String type;

        private Source appSource;

        private List<String> domains;

        private Boolean enableSsl;

        private SslConfiguration sslConfiguration;

        private Map<String, String> attributes;

        private List<EnvironmentVariable> environment;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAppRequest model) {
            appId(model.appId);
            name(model.name);
            description(model.description);
            dataSources(model.dataSources);
            type(model.type);
            appSource(model.appSource);
            domains(model.domains);
            enableSsl(model.enableSsl);
            sslConfiguration(model.sslConfiguration);
            attributes(model.attributes);
            environment(model.environment);
        }

        public final String getAppId() {
            return appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<DataSource.Builder> getDataSources() {
            return dataSources != null ? dataSources.stream().map(DataSource::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dataSources(Collection<DataSource> dataSources) {
            this.dataSources = DataSourcesCopier.copy(dataSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSources(DataSource... dataSources) {
            dataSources(Arrays.asList(dataSources));
            return this;
        }

        public final void setDataSources(Collection<DataSource.BuilderImpl> dataSources) {
            this.dataSources = DataSourcesCopier.copyFromBuilder(dataSources);
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(AppType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Source.Builder getAppSource() {
            return appSource != null ? appSource.toBuilder() : null;
        }

        @Override
        public final Builder appSource(Source appSource) {
            this.appSource = appSource;
            return this;
        }

        public final void setAppSource(Source.BuilderImpl appSource) {
            this.appSource = appSource != null ? appSource.build() : null;
        }

        public final Collection<String> getDomains() {
            return domains;
        }

        @Override
        public final Builder domains(Collection<String> domains) {
            this.domains = StringsCopier.copy(domains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domains(String... domains) {
            domains(Arrays.asList(domains));
            return this;
        }

        public final void setDomains(Collection<String> domains) {
            this.domains = StringsCopier.copy(domains);
        }

        public final Boolean getEnableSsl() {
            return enableSsl;
        }

        @Override
        public final Builder enableSsl(Boolean enableSsl) {
            this.enableSsl = enableSsl;
            return this;
        }

        public final void setEnableSsl(Boolean enableSsl) {
            this.enableSsl = enableSsl;
        }

        public final SslConfiguration.Builder getSslConfiguration() {
            return sslConfiguration != null ? sslConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder sslConfiguration(SslConfiguration sslConfiguration) {
            this.sslConfiguration = sslConfiguration;
            return this;
        }

        public final void setSslConfiguration(SslConfiguration.BuilderImpl sslConfiguration) {
            this.sslConfiguration = sslConfiguration != null ? sslConfiguration.build() : null;
        }

        public final Map<String, String> getAttributes() {
            return attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AppAttributesCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AppAttributesCopier.copy(attributes);
        }

        public final Collection<EnvironmentVariable.Builder> getEnvironment() {
            return environment != null ? environment.stream().map(EnvironmentVariable::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder environment(Collection<EnvironmentVariable> environment) {
            this.environment = EnvironmentVariablesCopier.copy(environment);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environment(EnvironmentVariable... environment) {
            environment(Arrays.asList(environment));
            return this;
        }

        public final void setEnvironment(Collection<EnvironmentVariable.BuilderImpl> environment) {
            this.environment = EnvironmentVariablesCopier.copyFromBuilder(environment);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateAppRequest build() {
            return new UpdateAppRequest(this);
        }
    }
}
