/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.transform.WeeklyAutoScalingScheduleMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a time-based instance's auto scaling schedule. The schedule consists of a set of key-value pairs.
 * </p>
 * <ul>
 * <li>
 * <p>
 * The key is the time period (a UTC hour) and must be an integer from 0 - 23.
 * </p>
 * </li>
 * <li>
 * <p>
 * The value indicates whether the instance should be online or offline for the specified period, and must be set to
 * "on" or "off"
 * </p>
 * </li>
 * </ul>
 * <p>
 * The default setting for all time periods is off, so you use the following parameters primarily to specify the online
 * periods. You don't have to explicitly specify offline periods unless you want to change an online period to an
 * offline period.
 * </p>
 * <p>
 * The following example specifies that the instance should be online for four hours, from UTC 1200 - 1600. It will be
 * off for the remainder of the day.
 * </p>
 * <p>
 * <code> { "12":"on", "13":"on", "14":"on", "15":"on" } </code>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class WeeklyAutoScalingSchedule implements StructuredPojo,
        ToCopyableBuilder<WeeklyAutoScalingSchedule.Builder, WeeklyAutoScalingSchedule> {
    private final Map<String, String> monday;

    private final Map<String, String> tuesday;

    private final Map<String, String> wednesday;

    private final Map<String, String> thursday;

    private final Map<String, String> friday;

    private final Map<String, String> saturday;

    private final Map<String, String> sunday;

    private WeeklyAutoScalingSchedule(BuilderImpl builder) {
        this.monday = builder.monday;
        this.tuesday = builder.tuesday;
        this.wednesday = builder.wednesday;
        this.thursday = builder.thursday;
        this.friday = builder.friday;
        this.saturday = builder.saturday;
        this.sunday = builder.sunday;
    }

    /**
     * <p>
     * The schedule for Monday.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The schedule for Monday.
     */
    public Map<String, String> monday() {
        return monday;
    }

    /**
     * <p>
     * The schedule for Tuesday.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The schedule for Tuesday.
     */
    public Map<String, String> tuesday() {
        return tuesday;
    }

    /**
     * <p>
     * The schedule for Wednesday.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The schedule for Wednesday.
     */
    public Map<String, String> wednesday() {
        return wednesday;
    }

    /**
     * <p>
     * The schedule for Thursday.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The schedule for Thursday.
     */
    public Map<String, String> thursday() {
        return thursday;
    }

    /**
     * <p>
     * The schedule for Friday.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The schedule for Friday.
     */
    public Map<String, String> friday() {
        return friday;
    }

    /**
     * <p>
     * The schedule for Saturday.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The schedule for Saturday.
     */
    public Map<String, String> saturday() {
        return saturday;
    }

    /**
     * <p>
     * The schedule for Sunday.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The schedule for Sunday.
     */
    public Map<String, String> sunday() {
        return sunday;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(monday());
        hashCode = 31 * hashCode + Objects.hashCode(tuesday());
        hashCode = 31 * hashCode + Objects.hashCode(wednesday());
        hashCode = 31 * hashCode + Objects.hashCode(thursday());
        hashCode = 31 * hashCode + Objects.hashCode(friday());
        hashCode = 31 * hashCode + Objects.hashCode(saturday());
        hashCode = 31 * hashCode + Objects.hashCode(sunday());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WeeklyAutoScalingSchedule)) {
            return false;
        }
        WeeklyAutoScalingSchedule other = (WeeklyAutoScalingSchedule) obj;
        return Objects.equals(monday(), other.monday()) && Objects.equals(tuesday(), other.tuesday())
                && Objects.equals(wednesday(), other.wednesday()) && Objects.equals(thursday(), other.thursday())
                && Objects.equals(friday(), other.friday()) && Objects.equals(saturday(), other.saturday())
                && Objects.equals(sunday(), other.sunday());
    }

    @Override
    public String toString() {
        return ToString.builder("WeeklyAutoScalingSchedule").add("Monday", monday()).add("Tuesday", tuesday())
                .add("Wednesday", wednesday()).add("Thursday", thursday()).add("Friday", friday()).add("Saturday", saturday())
                .add("Sunday", sunday()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Monday":
            return Optional.of(clazz.cast(monday()));
        case "Tuesday":
            return Optional.of(clazz.cast(tuesday()));
        case "Wednesday":
            return Optional.of(clazz.cast(wednesday()));
        case "Thursday":
            return Optional.of(clazz.cast(thursday()));
        case "Friday":
            return Optional.of(clazz.cast(friday()));
        case "Saturday":
            return Optional.of(clazz.cast(saturday()));
        case "Sunday":
            return Optional.of(clazz.cast(sunday()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WeeklyAutoScalingScheduleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, WeeklyAutoScalingSchedule> {
        /**
         * <p>
         * The schedule for Monday.
         * </p>
         * 
         * @param monday
         *        The schedule for Monday.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monday(Map<String, String> monday);

        /**
         * <p>
         * The schedule for Tuesday.
         * </p>
         * 
         * @param tuesday
         *        The schedule for Tuesday.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tuesday(Map<String, String> tuesday);

        /**
         * <p>
         * The schedule for Wednesday.
         * </p>
         * 
         * @param wednesday
         *        The schedule for Wednesday.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wednesday(Map<String, String> wednesday);

        /**
         * <p>
         * The schedule for Thursday.
         * </p>
         * 
         * @param thursday
         *        The schedule for Thursday.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thursday(Map<String, String> thursday);

        /**
         * <p>
         * The schedule for Friday.
         * </p>
         * 
         * @param friday
         *        The schedule for Friday.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder friday(Map<String, String> friday);

        /**
         * <p>
         * The schedule for Saturday.
         * </p>
         * 
         * @param saturday
         *        The schedule for Saturday.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder saturday(Map<String, String> saturday);

        /**
         * <p>
         * The schedule for Sunday.
         * </p>
         * 
         * @param sunday
         *        The schedule for Sunday.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sunday(Map<String, String> sunday);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, String> monday;

        private Map<String, String> tuesday;

        private Map<String, String> wednesday;

        private Map<String, String> thursday;

        private Map<String, String> friday;

        private Map<String, String> saturday;

        private Map<String, String> sunday;

        private BuilderImpl() {
        }

        private BuilderImpl(WeeklyAutoScalingSchedule model) {
            monday(model.monday);
            tuesday(model.tuesday);
            wednesday(model.wednesday);
            thursday(model.thursday);
            friday(model.friday);
            saturday(model.saturday);
            sunday(model.sunday);
        }

        public final Map<String, String> getMonday() {
            return monday;
        }

        @Override
        public final Builder monday(Map<String, String> monday) {
            this.monday = DailyAutoScalingScheduleCopier.copy(monday);
            return this;
        }

        public final void setMonday(Map<String, String> monday) {
            this.monday = DailyAutoScalingScheduleCopier.copy(monday);
        }

        public final Map<String, String> getTuesday() {
            return tuesday;
        }

        @Override
        public final Builder tuesday(Map<String, String> tuesday) {
            this.tuesday = DailyAutoScalingScheduleCopier.copy(tuesday);
            return this;
        }

        public final void setTuesday(Map<String, String> tuesday) {
            this.tuesday = DailyAutoScalingScheduleCopier.copy(tuesday);
        }

        public final Map<String, String> getWednesday() {
            return wednesday;
        }

        @Override
        public final Builder wednesday(Map<String, String> wednesday) {
            this.wednesday = DailyAutoScalingScheduleCopier.copy(wednesday);
            return this;
        }

        public final void setWednesday(Map<String, String> wednesday) {
            this.wednesday = DailyAutoScalingScheduleCopier.copy(wednesday);
        }

        public final Map<String, String> getThursday() {
            return thursday;
        }

        @Override
        public final Builder thursday(Map<String, String> thursday) {
            this.thursday = DailyAutoScalingScheduleCopier.copy(thursday);
            return this;
        }

        public final void setThursday(Map<String, String> thursday) {
            this.thursday = DailyAutoScalingScheduleCopier.copy(thursday);
        }

        public final Map<String, String> getFriday() {
            return friday;
        }

        @Override
        public final Builder friday(Map<String, String> friday) {
            this.friday = DailyAutoScalingScheduleCopier.copy(friday);
            return this;
        }

        public final void setFriday(Map<String, String> friday) {
            this.friday = DailyAutoScalingScheduleCopier.copy(friday);
        }

        public final Map<String, String> getSaturday() {
            return saturday;
        }

        @Override
        public final Builder saturday(Map<String, String> saturday) {
            this.saturday = DailyAutoScalingScheduleCopier.copy(saturday);
            return this;
        }

        public final void setSaturday(Map<String, String> saturday) {
            this.saturday = DailyAutoScalingScheduleCopier.copy(saturday);
        }

        public final Map<String, String> getSunday() {
            return sunday;
        }

        @Override
        public final Builder sunday(Map<String, String> sunday) {
            this.sunday = DailyAutoScalingScheduleCopier.copy(sunday);
            return this;
        }

        public final void setSunday(Map<String, String> sunday) {
            this.sunday = DailyAutoScalingScheduleCopier.copy(sunday);
        }

        @Override
        public WeeklyAutoScalingSchedule build() {
            return new WeeklyAutoScalingSchedule(this);
        }
    }
}
