/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.transform;

import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.opsworks.model.EnvironmentVariable;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link EnvironmentVariable} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class EnvironmentVariableMarshaller {
    private static final MarshallingInfo<String> KEY_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Key").isBinary(false).build();

    private static final MarshallingInfo<String> VALUE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Value").isBinary(false).build();

    private static final MarshallingInfo<Boolean> SECURE_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Secure").isBinary(false).build();

    private static final EnvironmentVariableMarshaller INSTANCE = new EnvironmentVariableMarshaller();

    private EnvironmentVariableMarshaller() {
    }

    public static EnvironmentVariableMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(EnvironmentVariable environmentVariable, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(environmentVariable, "environmentVariable");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(environmentVariable.key(), KEY_BINDING);
            protocolMarshaller.marshall(environmentVariable.value(), VALUE_BINDING);
            protocolMarshaller.marshall(environmentVariable.secure(), SECURE_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
