/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.opsworks.model.UpdateInstanceRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UpdateInstanceRequestModelMarshaller {
    private static final MarshallingInfo<String> INSTANCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceId").isBinary(false).build();
    private static final MarshallingInfo<List> LAYERIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LayerIds").isBinary(false).build();
    private static final MarshallingInfo<String> INSTANCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceType").isBinary(false).build();
    private static final MarshallingInfo<String> AUTOSCALINGTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AutoScalingType").isBinary(false).build();
    private static final MarshallingInfo<String> HOSTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Hostname").isBinary(false).build();
    private static final MarshallingInfo<String> OS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Os").isBinary(false).build();
    private static final MarshallingInfo<String> AMIID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AmiId").isBinary(false).build();
    private static final MarshallingInfo<String> SSHKEYNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SshKeyName").isBinary(false).build();
    private static final MarshallingInfo<String> ARCHITECTURE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Architecture").isBinary(false).build();
    private static final MarshallingInfo<Boolean> INSTALLUPDATESONBOOT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstallUpdatesOnBoot").isBinary(false).build();
    private static final MarshallingInfo<Boolean> EBSOPTIMIZED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EbsOptimized").isBinary(false).build();
    private static final MarshallingInfo<String> AGENTVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AgentVersion").isBinary(false).build();
    private static final UpdateInstanceRequestModelMarshaller INSTANCE = new UpdateInstanceRequestModelMarshaller();

    private UpdateInstanceRequestModelMarshaller() {
    }

    public static UpdateInstanceRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UpdateInstanceRequest updateInstanceRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)updateInstanceRequest), (String)"updateInstanceRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)updateInstanceRequest.instanceId(), INSTANCEID_BINDING);
            protocolMarshaller.marshall(updateInstanceRequest.layerIds(), LAYERIDS_BINDING);
            protocolMarshaller.marshall((Object)updateInstanceRequest.instanceType(), INSTANCETYPE_BINDING);
            protocolMarshaller.marshall((Object)updateInstanceRequest.autoScalingTypeString(), AUTOSCALINGTYPE_BINDING);
            protocolMarshaller.marshall((Object)updateInstanceRequest.hostname(), HOSTNAME_BINDING);
            protocolMarshaller.marshall((Object)updateInstanceRequest.os(), OS_BINDING);
            protocolMarshaller.marshall((Object)updateInstanceRequest.amiId(), AMIID_BINDING);
            protocolMarshaller.marshall((Object)updateInstanceRequest.sshKeyName(), SSHKEYNAME_BINDING);
            protocolMarshaller.marshall((Object)updateInstanceRequest.architectureString(), ARCHITECTURE_BINDING);
            protocolMarshaller.marshall((Object)updateInstanceRequest.installUpdatesOnBoot(), INSTALLUPDATESONBOOT_BINDING);
            protocolMarshaller.marshall((Object)updateInstanceRequest.ebsOptimized(), EBSOPTIMIZED_BINDING);
            protocolMarshaller.marshall((Object)updateInstanceRequest.agentVersion(), AGENTVERSION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

