/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an agent version.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AgentVersion implements SdkPojo, Serializable, ToCopyableBuilder<AgentVersion.Builder, AgentVersion> {
    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AgentVersion::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final SdkField<StackConfigurationManager> CONFIGURATION_MANAGER_FIELD = SdkField
            .<StackConfigurationManager> builder(MarshallingType.SDK_POJO).getter(getter(AgentVersion::configurationManager))
            .setter(setter(Builder::configurationManager)).constructor(StackConfigurationManager::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationManager").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERSION_FIELD,
            CONFIGURATION_MANAGER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String version;

    private final StackConfigurationManager configurationManager;

    private AgentVersion(BuilderImpl builder) {
        this.version = builder.version;
        this.configurationManager = builder.configurationManager;
    }

    /**
     * <p>
     * The agent version.
     * </p>
     * 
     * @return The agent version.
     */
    public String version() {
        return version;
    }

    /**
     * <p>
     * The configuration manager.
     * </p>
     * 
     * @return The configuration manager.
     */
    public StackConfigurationManager configurationManager() {
        return configurationManager;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(configurationManager());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentVersion)) {
            return false;
        }
        AgentVersion other = (AgentVersion) obj;
        return Objects.equals(version(), other.version()) && Objects.equals(configurationManager(), other.configurationManager());
    }

    @Override
    public String toString() {
        return ToString.builder("AgentVersion").add("Version", version()).add("ConfigurationManager", configurationManager())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        case "ConfigurationManager":
            return Optional.ofNullable(clazz.cast(configurationManager()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AgentVersion, T> g) {
        return obj -> g.apply((AgentVersion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AgentVersion> {
        /**
         * <p>
         * The agent version.
         * </p>
         * 
         * @param version
         *        The agent version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The configuration manager.
         * </p>
         * 
         * @param configurationManager
         *        The configuration manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationManager(StackConfigurationManager configurationManager);

        /**
         * <p>
         * The configuration manager.
         * </p>
         * This is a convenience that creates an instance of the {@link StackConfigurationManager.Builder} avoiding the
         * need to create one manually via {@link StackConfigurationManager#builder()}.
         *
         * When the {@link Consumer} completes, {@link StackConfigurationManager.Builder#build()} is called immediately
         * and its result is passed to {@link #configurationManager(StackConfigurationManager)}.
         * 
         * @param configurationManager
         *        a consumer that will call methods on {@link StackConfigurationManager.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configurationManager(StackConfigurationManager)
         */
        default Builder configurationManager(Consumer<StackConfigurationManager.Builder> configurationManager) {
            return configurationManager(StackConfigurationManager.builder().applyMutation(configurationManager).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String version;

        private StackConfigurationManager configurationManager;

        private BuilderImpl() {
        }

        private BuilderImpl(AgentVersion model) {
            version(model.version);
            configurationManager(model.configurationManager);
        }

        public final String getVersion() {
            return version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final StackConfigurationManager.Builder getConfigurationManager() {
            return configurationManager != null ? configurationManager.toBuilder() : null;
        }

        @Override
        public final Builder configurationManager(StackConfigurationManager configurationManager) {
            this.configurationManager = configurationManager;
            return this;
        }

        public final void setConfigurationManager(StackConfigurationManager.BuilderImpl configurationManager) {
            this.configurationManager = configurationManager != null ? configurationManager.build() : null;
        }

        @Override
        public AgentVersion build() {
            return new AgentVersion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
