/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the Amazon CloudWatch logs configuration for a layer. For detailed information about members of this data
 * type, see the <a href="http://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AgentReference.html">CloudWatch Logs
 * Agent Reference</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CloudWatchLogsLogStream implements SdkPojo, Serializable,
        ToCopyableBuilder<CloudWatchLogsLogStream.Builder, CloudWatchLogsLogStream> {
    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CloudWatchLogsLogStream::logGroupName)).setter(setter(Builder::logGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogGroupName").build()).build();

    private static final SdkField<String> DATETIME_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CloudWatchLogsLogStream::datetimeFormat)).setter(setter(Builder::datetimeFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatetimeFormat").build()).build();

    private static final SdkField<String> TIME_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CloudWatchLogsLogStream::timeZoneAsString)).setter(setter(Builder::timeZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeZone").build()).build();

    private static final SdkField<String> FILE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CloudWatchLogsLogStream::file)).setter(setter(Builder::file))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("File").build()).build();

    private static final SdkField<String> FILE_FINGERPRINT_LINES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CloudWatchLogsLogStream::fileFingerprintLines)).setter(setter(Builder::fileFingerprintLines))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileFingerprintLines").build())
            .build();

    private static final SdkField<String> MULTI_LINE_START_PATTERN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CloudWatchLogsLogStream::multiLineStartPattern)).setter(setter(Builder::multiLineStartPattern))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiLineStartPattern").build())
            .build();

    private static final SdkField<String> INITIAL_POSITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CloudWatchLogsLogStream::initialPositionAsString)).setter(setter(Builder::initialPosition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitialPosition").build()).build();

    private static final SdkField<String> ENCODING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CloudWatchLogsLogStream::encodingAsString)).setter(setter(Builder::encoding))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encoding").build()).build();

    private static final SdkField<Integer> BUFFER_DURATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CloudWatchLogsLogStream::bufferDuration)).setter(setter(Builder::bufferDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BufferDuration").build()).build();

    private static final SdkField<Integer> BATCH_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CloudWatchLogsLogStream::batchCount)).setter(setter(Builder::batchCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchCount").build()).build();

    private static final SdkField<Integer> BATCH_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CloudWatchLogsLogStream::batchSize)).setter(setter(Builder::batchSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchSize").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_GROUP_NAME_FIELD,
            DATETIME_FORMAT_FIELD, TIME_ZONE_FIELD, FILE_FIELD, FILE_FINGERPRINT_LINES_FIELD, MULTI_LINE_START_PATTERN_FIELD,
            INITIAL_POSITION_FIELD, ENCODING_FIELD, BUFFER_DURATION_FIELD, BATCH_COUNT_FIELD, BATCH_SIZE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String logGroupName;

    private final String datetimeFormat;

    private final String timeZone;

    private final String file;

    private final String fileFingerprintLines;

    private final String multiLineStartPattern;

    private final String initialPosition;

    private final String encoding;

    private final Integer bufferDuration;

    private final Integer batchCount;

    private final Integer batchSize;

    private CloudWatchLogsLogStream(BuilderImpl builder) {
        this.logGroupName = builder.logGroupName;
        this.datetimeFormat = builder.datetimeFormat;
        this.timeZone = builder.timeZone;
        this.file = builder.file;
        this.fileFingerprintLines = builder.fileFingerprintLines;
        this.multiLineStartPattern = builder.multiLineStartPattern;
        this.initialPosition = builder.initialPosition;
        this.encoding = builder.encoding;
        this.bufferDuration = builder.bufferDuration;
        this.batchCount = builder.batchCount;
        this.batchSize = builder.batchSize;
    }

    /**
     * <p>
     * Specifies the destination log group. A log group is created automatically if it doesn't already exist. Log group
     * names can be between 1 and 512 characters long. Allowed characters include a-z, A-Z, 0-9, '_' (underscore), '-'
     * (hyphen), '/' (forward slash), and '.' (period).
     * </p>
     * 
     * @return Specifies the destination log group. A log group is created automatically if it doesn't already exist.
     *         Log group names can be between 1 and 512 characters long. Allowed characters include a-z, A-Z, 0-9, '_'
     *         (underscore), '-' (hyphen), '/' (forward slash), and '.' (period).
     */
    public String logGroupName() {
        return logGroupName;
    }

    /**
     * <p>
     * Specifies how the time stamp is extracted from logs. For more information, see the <a
     * href="http://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AgentReference.html">CloudWatch Logs Agent
     * Reference</a>.
     * </p>
     * 
     * @return Specifies how the time stamp is extracted from logs. For more information, see the <a
     *         href="http://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AgentReference.html">CloudWatch Logs Agent
     *         Reference</a>.
     */
    public String datetimeFormat() {
        return datetimeFormat;
    }

    /**
     * <p>
     * Specifies the time zone of log event time stamps.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timeZone} will
     * return {@link CloudWatchLogsTimeZone#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #timeZoneAsString}.
     * </p>
     * 
     * @return Specifies the time zone of log event time stamps.
     * @see CloudWatchLogsTimeZone
     */
    public CloudWatchLogsTimeZone timeZone() {
        return CloudWatchLogsTimeZone.fromValue(timeZone);
    }

    /**
     * <p>
     * Specifies the time zone of log event time stamps.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timeZone} will
     * return {@link CloudWatchLogsTimeZone#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #timeZoneAsString}.
     * </p>
     * 
     * @return Specifies the time zone of log event time stamps.
     * @see CloudWatchLogsTimeZone
     */
    public String timeZoneAsString() {
        return timeZone;
    }

    /**
     * <p>
     * Specifies log files that you want to push to CloudWatch Logs.
     * </p>
     * <p>
     * <code>File</code> can point to a specific file or multiple files (by using wild card characters such as
     * <code>/var/log/system.log*</code>). Only the latest file is pushed to CloudWatch Logs, based on file modification
     * time. We recommend that you use wild card characters to specify a series of files of the same type, such as
     * <code>access_log.2014-06-01-01</code>, <code>access_log.2014-06-01-02</code>, and so on by using a pattern like
     * <code>access_log.*</code>. Don't use a wildcard to match multiple file types, such as <code>access_log_80</code>
     * and <code>access_log_443</code>. To specify multiple, different file types, add another log stream entry to the
     * configuration file, so that each log file type is stored in a different log group.
     * </p>
     * <p>
     * Zipped files are not supported.
     * </p>
     * 
     * @return Specifies log files that you want to push to CloudWatch Logs.</p>
     *         <p>
     *         <code>File</code> can point to a specific file or multiple files (by using wild card characters such as
     *         <code>/var/log/system.log*</code>). Only the latest file is pushed to CloudWatch Logs, based on file
     *         modification time. We recommend that you use wild card characters to specify a series of files of the
     *         same type, such as <code>access_log.2014-06-01-01</code>, <code>access_log.2014-06-01-02</code>, and so
     *         on by using a pattern like <code>access_log.*</code>. Don't use a wildcard to match multiple file types,
     *         such as <code>access_log_80</code> and <code>access_log_443</code>. To specify multiple, different file
     *         types, add another log stream entry to the configuration file, so that each log file type is stored in a
     *         different log group.
     *         </p>
     *         <p>
     *         Zipped files are not supported.
     */
    public String file() {
        return file;
    }

    /**
     * <p>
     * Specifies the range of lines for identifying a file. The valid values are one number, or two dash-delimited
     * numbers, such as '1', '2-5'. The default value is '1', meaning the first line is used to calculate the
     * fingerprint. Fingerprint lines are not sent to CloudWatch Logs unless all specified lines are available.
     * </p>
     * 
     * @return Specifies the range of lines for identifying a file. The valid values are one number, or two
     *         dash-delimited numbers, such as '1', '2-5'. The default value is '1', meaning the first line is used to
     *         calculate the fingerprint. Fingerprint lines are not sent to CloudWatch Logs unless all specified lines
     *         are available.
     */
    public String fileFingerprintLines() {
        return fileFingerprintLines;
    }

    /**
     * <p>
     * Specifies the pattern for identifying the start of a log message.
     * </p>
     * 
     * @return Specifies the pattern for identifying the start of a log message.
     */
    public String multiLineStartPattern() {
        return multiLineStartPattern;
    }

    /**
     * <p>
     * Specifies where to start to read data (start_of_file or end_of_file). The default is start_of_file. This setting
     * is only used if there is no state persisted for that log stream.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #initialPosition}
     * will return {@link CloudWatchLogsInitialPosition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #initialPositionAsString}.
     * </p>
     * 
     * @return Specifies where to start to read data (start_of_file or end_of_file). The default is start_of_file. This
     *         setting is only used if there is no state persisted for that log stream.
     * @see CloudWatchLogsInitialPosition
     */
    public CloudWatchLogsInitialPosition initialPosition() {
        return CloudWatchLogsInitialPosition.fromValue(initialPosition);
    }

    /**
     * <p>
     * Specifies where to start to read data (start_of_file or end_of_file). The default is start_of_file. This setting
     * is only used if there is no state persisted for that log stream.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #initialPosition}
     * will return {@link CloudWatchLogsInitialPosition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #initialPositionAsString}.
     * </p>
     * 
     * @return Specifies where to start to read data (start_of_file or end_of_file). The default is start_of_file. This
     *         setting is only used if there is no state persisted for that log stream.
     * @see CloudWatchLogsInitialPosition
     */
    public String initialPositionAsString() {
        return initialPosition;
    }

    /**
     * <p>
     * Specifies the encoding of the log file so that the file can be read correctly. The default is <code>utf_8</code>.
     * Encodings supported by Python <code>codecs.decode()</code> can be used here.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encoding} will
     * return {@link CloudWatchLogsEncoding#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #encodingAsString}.
     * </p>
     * 
     * @return Specifies the encoding of the log file so that the file can be read correctly. The default is
     *         <code>utf_8</code>. Encodings supported by Python <code>codecs.decode()</code> can be used here.
     * @see CloudWatchLogsEncoding
     */
    public CloudWatchLogsEncoding encoding() {
        return CloudWatchLogsEncoding.fromValue(encoding);
    }

    /**
     * <p>
     * Specifies the encoding of the log file so that the file can be read correctly. The default is <code>utf_8</code>.
     * Encodings supported by Python <code>codecs.decode()</code> can be used here.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encoding} will
     * return {@link CloudWatchLogsEncoding#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #encodingAsString}.
     * </p>
     * 
     * @return Specifies the encoding of the log file so that the file can be read correctly. The default is
     *         <code>utf_8</code>. Encodings supported by Python <code>codecs.decode()</code> can be used here.
     * @see CloudWatchLogsEncoding
     */
    public String encodingAsString() {
        return encoding;
    }

    /**
     * <p>
     * Specifies the time duration for the batching of log events. The minimum value is 5000ms and default value is
     * 5000ms.
     * </p>
     * 
     * @return Specifies the time duration for the batching of log events. The minimum value is 5000ms and default value
     *         is 5000ms.
     */
    public Integer bufferDuration() {
        return bufferDuration;
    }

    /**
     * <p>
     * Specifies the max number of log events in a batch, up to 10000. The default value is 1000.
     * </p>
     * 
     * @return Specifies the max number of log events in a batch, up to 10000. The default value is 1000.
     */
    public Integer batchCount() {
        return batchCount;
    }

    /**
     * <p>
     * Specifies the maximum size of log events in a batch, in bytes, up to 1048576 bytes. The default value is 32768
     * bytes. This size is calculated as the sum of all event messages in UTF-8, plus 26 bytes for each log event.
     * </p>
     * 
     * @return Specifies the maximum size of log events in a batch, in bytes, up to 1048576 bytes. The default value is
     *         32768 bytes. This size is calculated as the sum of all event messages in UTF-8, plus 26 bytes for each
     *         log event.
     */
    public Integer batchSize() {
        return batchSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(datetimeFormat());
        hashCode = 31 * hashCode + Objects.hashCode(timeZoneAsString());
        hashCode = 31 * hashCode + Objects.hashCode(file());
        hashCode = 31 * hashCode + Objects.hashCode(fileFingerprintLines());
        hashCode = 31 * hashCode + Objects.hashCode(multiLineStartPattern());
        hashCode = 31 * hashCode + Objects.hashCode(initialPositionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(encodingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(bufferDuration());
        hashCode = 31 * hashCode + Objects.hashCode(batchCount());
        hashCode = 31 * hashCode + Objects.hashCode(batchSize());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchLogsLogStream)) {
            return false;
        }
        CloudWatchLogsLogStream other = (CloudWatchLogsLogStream) obj;
        return Objects.equals(logGroupName(), other.logGroupName()) && Objects.equals(datetimeFormat(), other.datetimeFormat())
                && Objects.equals(timeZoneAsString(), other.timeZoneAsString()) && Objects.equals(file(), other.file())
                && Objects.equals(fileFingerprintLines(), other.fileFingerprintLines())
                && Objects.equals(multiLineStartPattern(), other.multiLineStartPattern())
                && Objects.equals(initialPositionAsString(), other.initialPositionAsString())
                && Objects.equals(encodingAsString(), other.encodingAsString())
                && Objects.equals(bufferDuration(), other.bufferDuration()) && Objects.equals(batchCount(), other.batchCount())
                && Objects.equals(batchSize(), other.batchSize());
    }

    @Override
    public String toString() {
        return ToString.builder("CloudWatchLogsLogStream").add("LogGroupName", logGroupName())
                .add("DatetimeFormat", datetimeFormat()).add("TimeZone", timeZoneAsString()).add("File", file())
                .add("FileFingerprintLines", fileFingerprintLines()).add("MultiLineStartPattern", multiLineStartPattern())
                .add("InitialPosition", initialPositionAsString()).add("Encoding", encodingAsString())
                .add("BufferDuration", bufferDuration()).add("BatchCount", batchCount()).add("BatchSize", batchSize()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LogGroupName":
            return Optional.ofNullable(clazz.cast(logGroupName()));
        case "DatetimeFormat":
            return Optional.ofNullable(clazz.cast(datetimeFormat()));
        case "TimeZone":
            return Optional.ofNullable(clazz.cast(timeZoneAsString()));
        case "File":
            return Optional.ofNullable(clazz.cast(file()));
        case "FileFingerprintLines":
            return Optional.ofNullable(clazz.cast(fileFingerprintLines()));
        case "MultiLineStartPattern":
            return Optional.ofNullable(clazz.cast(multiLineStartPattern()));
        case "InitialPosition":
            return Optional.ofNullable(clazz.cast(initialPositionAsString()));
        case "Encoding":
            return Optional.ofNullable(clazz.cast(encodingAsString()));
        case "BufferDuration":
            return Optional.ofNullable(clazz.cast(bufferDuration()));
        case "BatchCount":
            return Optional.ofNullable(clazz.cast(batchCount()));
        case "BatchSize":
            return Optional.ofNullable(clazz.cast(batchSize()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CloudWatchLogsLogStream, T> g) {
        return obj -> g.apply((CloudWatchLogsLogStream) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CloudWatchLogsLogStream> {
        /**
         * <p>
         * Specifies the destination log group. A log group is created automatically if it doesn't already exist. Log
         * group names can be between 1 and 512 characters long. Allowed characters include a-z, A-Z, 0-9, '_'
         * (underscore), '-' (hyphen), '/' (forward slash), and '.' (period).
         * </p>
         * 
         * @param logGroupName
         *        Specifies the destination log group. A log group is created automatically if it doesn't already exist.
         *        Log group names can be between 1 and 512 characters long. Allowed characters include a-z, A-Z, 0-9,
         *        '_' (underscore), '-' (hyphen), '/' (forward slash), and '.' (period).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupName(String logGroupName);

        /**
         * <p>
         * Specifies how the time stamp is extracted from logs. For more information, see the <a
         * href="http://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AgentReference.html">CloudWatch Logs Agent
         * Reference</a>.
         * </p>
         * 
         * @param datetimeFormat
         *        Specifies how the time stamp is extracted from logs. For more information, see the <a
         *        href="http://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AgentReference.html">CloudWatch Logs
         *        Agent Reference</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datetimeFormat(String datetimeFormat);

        /**
         * <p>
         * Specifies the time zone of log event time stamps.
         * </p>
         * 
         * @param timeZone
         *        Specifies the time zone of log event time stamps.
         * @see CloudWatchLogsTimeZone
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CloudWatchLogsTimeZone
         */
        Builder timeZone(String timeZone);

        /**
         * <p>
         * Specifies the time zone of log event time stamps.
         * </p>
         * 
         * @param timeZone
         *        Specifies the time zone of log event time stamps.
         * @see CloudWatchLogsTimeZone
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CloudWatchLogsTimeZone
         */
        Builder timeZone(CloudWatchLogsTimeZone timeZone);

        /**
         * <p>
         * Specifies log files that you want to push to CloudWatch Logs.
         * </p>
         * <p>
         * <code>File</code> can point to a specific file or multiple files (by using wild card characters such as
         * <code>/var/log/system.log*</code>). Only the latest file is pushed to CloudWatch Logs, based on file
         * modification time. We recommend that you use wild card characters to specify a series of files of the same
         * type, such as <code>access_log.2014-06-01-01</code>, <code>access_log.2014-06-01-02</code>, and so on by
         * using a pattern like <code>access_log.*</code>. Don't use a wildcard to match multiple file types, such as
         * <code>access_log_80</code> and <code>access_log_443</code>. To specify multiple, different file types, add
         * another log stream entry to the configuration file, so that each log file type is stored in a different log
         * group.
         * </p>
         * <p>
         * Zipped files are not supported.
         * </p>
         * 
         * @param file
         *        Specifies log files that you want to push to CloudWatch Logs.</p>
         *        <p>
         *        <code>File</code> can point to a specific file or multiple files (by using wild card characters such
         *        as <code>/var/log/system.log*</code>). Only the latest file is pushed to CloudWatch Logs, based on
         *        file modification time. We recommend that you use wild card characters to specify a series of files of
         *        the same type, such as <code>access_log.2014-06-01-01</code>, <code>access_log.2014-06-01-02</code>,
         *        and so on by using a pattern like <code>access_log.*</code>. Don't use a wildcard to match multiple
         *        file types, such as <code>access_log_80</code> and <code>access_log_443</code>. To specify multiple,
         *        different file types, add another log stream entry to the configuration file, so that each log file
         *        type is stored in a different log group.
         *        </p>
         *        <p>
         *        Zipped files are not supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder file(String file);

        /**
         * <p>
         * Specifies the range of lines for identifying a file. The valid values are one number, or two dash-delimited
         * numbers, such as '1', '2-5'. The default value is '1', meaning the first line is used to calculate the
         * fingerprint. Fingerprint lines are not sent to CloudWatch Logs unless all specified lines are available.
         * </p>
         * 
         * @param fileFingerprintLines
         *        Specifies the range of lines for identifying a file. The valid values are one number, or two
         *        dash-delimited numbers, such as '1', '2-5'. The default value is '1', meaning the first line is used
         *        to calculate the fingerprint. Fingerprint lines are not sent to CloudWatch Logs unless all specified
         *        lines are available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileFingerprintLines(String fileFingerprintLines);

        /**
         * <p>
         * Specifies the pattern for identifying the start of a log message.
         * </p>
         * 
         * @param multiLineStartPattern
         *        Specifies the pattern for identifying the start of a log message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiLineStartPattern(String multiLineStartPattern);

        /**
         * <p>
         * Specifies where to start to read data (start_of_file or end_of_file). The default is start_of_file. This
         * setting is only used if there is no state persisted for that log stream.
         * </p>
         * 
         * @param initialPosition
         *        Specifies where to start to read data (start_of_file or end_of_file). The default is start_of_file.
         *        This setting is only used if there is no state persisted for that log stream.
         * @see CloudWatchLogsInitialPosition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CloudWatchLogsInitialPosition
         */
        Builder initialPosition(String initialPosition);

        /**
         * <p>
         * Specifies where to start to read data (start_of_file or end_of_file). The default is start_of_file. This
         * setting is only used if there is no state persisted for that log stream.
         * </p>
         * 
         * @param initialPosition
         *        Specifies where to start to read data (start_of_file or end_of_file). The default is start_of_file.
         *        This setting is only used if there is no state persisted for that log stream.
         * @see CloudWatchLogsInitialPosition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CloudWatchLogsInitialPosition
         */
        Builder initialPosition(CloudWatchLogsInitialPosition initialPosition);

        /**
         * <p>
         * Specifies the encoding of the log file so that the file can be read correctly. The default is
         * <code>utf_8</code>. Encodings supported by Python <code>codecs.decode()</code> can be used here.
         * </p>
         * 
         * @param encoding
         *        Specifies the encoding of the log file so that the file can be read correctly. The default is
         *        <code>utf_8</code>. Encodings supported by Python <code>codecs.decode()</code> can be used here.
         * @see CloudWatchLogsEncoding
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CloudWatchLogsEncoding
         */
        Builder encoding(String encoding);

        /**
         * <p>
         * Specifies the encoding of the log file so that the file can be read correctly. The default is
         * <code>utf_8</code>. Encodings supported by Python <code>codecs.decode()</code> can be used here.
         * </p>
         * 
         * @param encoding
         *        Specifies the encoding of the log file so that the file can be read correctly. The default is
         *        <code>utf_8</code>. Encodings supported by Python <code>codecs.decode()</code> can be used here.
         * @see CloudWatchLogsEncoding
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CloudWatchLogsEncoding
         */
        Builder encoding(CloudWatchLogsEncoding encoding);

        /**
         * <p>
         * Specifies the time duration for the batching of log events. The minimum value is 5000ms and default value is
         * 5000ms.
         * </p>
         * 
         * @param bufferDuration
         *        Specifies the time duration for the batching of log events. The minimum value is 5000ms and default
         *        value is 5000ms.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bufferDuration(Integer bufferDuration);

        /**
         * <p>
         * Specifies the max number of log events in a batch, up to 10000. The default value is 1000.
         * </p>
         * 
         * @param batchCount
         *        Specifies the max number of log events in a batch, up to 10000. The default value is 1000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchCount(Integer batchCount);

        /**
         * <p>
         * Specifies the maximum size of log events in a batch, in bytes, up to 1048576 bytes. The default value is
         * 32768 bytes. This size is calculated as the sum of all event messages in UTF-8, plus 26 bytes for each log
         * event.
         * </p>
         * 
         * @param batchSize
         *        Specifies the maximum size of log events in a batch, in bytes, up to 1048576 bytes. The default value
         *        is 32768 bytes. This size is calculated as the sum of all event messages in UTF-8, plus 26 bytes for
         *        each log event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchSize(Integer batchSize);
    }

    static final class BuilderImpl implements Builder {
        private String logGroupName;

        private String datetimeFormat;

        private String timeZone;

        private String file;

        private String fileFingerprintLines;

        private String multiLineStartPattern;

        private String initialPosition;

        private String encoding;

        private Integer bufferDuration;

        private Integer batchCount;

        private Integer batchSize;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudWatchLogsLogStream model) {
            logGroupName(model.logGroupName);
            datetimeFormat(model.datetimeFormat);
            timeZone(model.timeZone);
            file(model.file);
            fileFingerprintLines(model.fileFingerprintLines);
            multiLineStartPattern(model.multiLineStartPattern);
            initialPosition(model.initialPosition);
            encoding(model.encoding);
            bufferDuration(model.bufferDuration);
            batchCount(model.batchCount);
            batchSize(model.batchSize);
        }

        public final String getLogGroupName() {
            return logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        public final String getDatetimeFormat() {
            return datetimeFormat;
        }

        @Override
        public final Builder datetimeFormat(String datetimeFormat) {
            this.datetimeFormat = datetimeFormat;
            return this;
        }

        public final void setDatetimeFormat(String datetimeFormat) {
            this.datetimeFormat = datetimeFormat;
        }

        public final String getTimeZone() {
            return timeZone;
        }

        @Override
        public final Builder timeZone(String timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        @Override
        public final Builder timeZone(CloudWatchLogsTimeZone timeZone) {
            this.timeZone(timeZone.toString());
            return this;
        }

        public final void setTimeZone(String timeZone) {
            this.timeZone = timeZone;
        }

        public final String getFile() {
            return file;
        }

        @Override
        public final Builder file(String file) {
            this.file = file;
            return this;
        }

        public final void setFile(String file) {
            this.file = file;
        }

        public final String getFileFingerprintLines() {
            return fileFingerprintLines;
        }

        @Override
        public final Builder fileFingerprintLines(String fileFingerprintLines) {
            this.fileFingerprintLines = fileFingerprintLines;
            return this;
        }

        public final void setFileFingerprintLines(String fileFingerprintLines) {
            this.fileFingerprintLines = fileFingerprintLines;
        }

        public final String getMultiLineStartPattern() {
            return multiLineStartPattern;
        }

        @Override
        public final Builder multiLineStartPattern(String multiLineStartPattern) {
            this.multiLineStartPattern = multiLineStartPattern;
            return this;
        }

        public final void setMultiLineStartPattern(String multiLineStartPattern) {
            this.multiLineStartPattern = multiLineStartPattern;
        }

        public final String getInitialPosition() {
            return initialPosition;
        }

        @Override
        public final Builder initialPosition(String initialPosition) {
            this.initialPosition = initialPosition;
            return this;
        }

        @Override
        public final Builder initialPosition(CloudWatchLogsInitialPosition initialPosition) {
            this.initialPosition(initialPosition.toString());
            return this;
        }

        public final void setInitialPosition(String initialPosition) {
            this.initialPosition = initialPosition;
        }

        public final String getEncoding() {
            return encoding;
        }

        @Override
        public final Builder encoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        @Override
        public final Builder encoding(CloudWatchLogsEncoding encoding) {
            this.encoding(encoding.toString());
            return this;
        }

        public final void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        public final Integer getBufferDuration() {
            return bufferDuration;
        }

        @Override
        public final Builder bufferDuration(Integer bufferDuration) {
            this.bufferDuration = bufferDuration;
            return this;
        }

        public final void setBufferDuration(Integer bufferDuration) {
            this.bufferDuration = bufferDuration;
        }

        public final Integer getBatchCount() {
            return batchCount;
        }

        @Override
        public final Builder batchCount(Integer batchCount) {
            this.batchCount = batchCount;
            return this;
        }

        public final void setBatchCount(Integer batchCount) {
            this.batchCount = batchCount;
        }

        public final Integer getBatchSize() {
            return batchSize;
        }

        @Override
        public final Builder batchSize(Integer batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public final void setBatchSize(Integer batchSize) {
            this.batchSize = batchSize;
        }

        @Override
        public CloudWatchLogsLogStream build() {
            return new CloudWatchLogsLogStream(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
