/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeServiceErrorsRequest extends OpsWorksRequest implements
        ToCopyableBuilder<DescribeServiceErrorsRequest.Builder, DescribeServiceErrorsRequest> {
    private static final SdkField<String> STACK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeServiceErrorsRequest::stackId)).setter(setter(Builder::stackId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackId").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeServiceErrorsRequest::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<List<String>> SERVICE_ERROR_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeServiceErrorsRequest::serviceErrorIds))
            .setter(setter(Builder::serviceErrorIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceErrorIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_ID_FIELD,
            INSTANCE_ID_FIELD, SERVICE_ERROR_IDS_FIELD));

    private final String stackId;

    private final String instanceId;

    private final List<String> serviceErrorIds;

    private DescribeServiceErrorsRequest(BuilderImpl builder) {
        super(builder);
        this.stackId = builder.stackId;
        this.instanceId = builder.instanceId;
        this.serviceErrorIds = builder.serviceErrorIds;
    }

    /**
     * <p>
     * The stack ID. If you use this parameter, <code>DescribeServiceErrors</code> returns descriptions of the errors
     * associated with the specified stack.
     * </p>
     * 
     * @return The stack ID. If you use this parameter, <code>DescribeServiceErrors</code> returns descriptions of the
     *         errors associated with the specified stack.
     */
    public String stackId() {
        return stackId;
    }

    /**
     * <p>
     * The instance ID. If you use this parameter, <code>DescribeServiceErrors</code> returns descriptions of the errors
     * associated with the specified instance.
     * </p>
     * 
     * @return The instance ID. If you use this parameter, <code>DescribeServiceErrors</code> returns descriptions of
     *         the errors associated with the specified instance.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * An array of service error IDs. If you use this parameter, <code>DescribeServiceErrors</code> returns descriptions
     * of the specified errors. Otherwise, it returns a description of every error.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of service error IDs. If you use this parameter, <code>DescribeServiceErrors</code> returns
     *         descriptions of the specified errors. Otherwise, it returns a description of every error.
     */
    public List<String> serviceErrorIds() {
        return serviceErrorIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stackId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(serviceErrorIds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeServiceErrorsRequest)) {
            return false;
        }
        DescribeServiceErrorsRequest other = (DescribeServiceErrorsRequest) obj;
        return Objects.equals(stackId(), other.stackId()) && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(serviceErrorIds(), other.serviceErrorIds());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeServiceErrorsRequest").add("StackId", stackId()).add("InstanceId", instanceId())
                .add("ServiceErrorIds", serviceErrorIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackId":
            return Optional.ofNullable(clazz.cast(stackId()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "ServiceErrorIds":
            return Optional.ofNullable(clazz.cast(serviceErrorIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeServiceErrorsRequest, T> g) {
        return obj -> g.apply((DescribeServiceErrorsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpsWorksRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeServiceErrorsRequest> {
        /**
         * <p>
         * The stack ID. If you use this parameter, <code>DescribeServiceErrors</code> returns descriptions of the
         * errors associated with the specified stack.
         * </p>
         * 
         * @param stackId
         *        The stack ID. If you use this parameter, <code>DescribeServiceErrors</code> returns descriptions of
         *        the errors associated with the specified stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * The instance ID. If you use this parameter, <code>DescribeServiceErrors</code> returns descriptions of the
         * errors associated with the specified instance.
         * </p>
         * 
         * @param instanceId
         *        The instance ID. If you use this parameter, <code>DescribeServiceErrors</code> returns descriptions of
         *        the errors associated with the specified instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * An array of service error IDs. If you use this parameter, <code>DescribeServiceErrors</code> returns
         * descriptions of the specified errors. Otherwise, it returns a description of every error.
         * </p>
         * 
         * @param serviceErrorIds
         *        An array of service error IDs. If you use this parameter, <code>DescribeServiceErrors</code> returns
         *        descriptions of the specified errors. Otherwise, it returns a description of every error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceErrorIds(Collection<String> serviceErrorIds);

        /**
         * <p>
         * An array of service error IDs. If you use this parameter, <code>DescribeServiceErrors</code> returns
         * descriptions of the specified errors. Otherwise, it returns a description of every error.
         * </p>
         * 
         * @param serviceErrorIds
         *        An array of service error IDs. If you use this parameter, <code>DescribeServiceErrors</code> returns
         *        descriptions of the specified errors. Otherwise, it returns a description of every error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceErrorIds(String... serviceErrorIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpsWorksRequest.BuilderImpl implements Builder {
        private String stackId;

        private String instanceId;

        private List<String> serviceErrorIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeServiceErrorsRequest model) {
            super(model);
            stackId(model.stackId);
            instanceId(model.instanceId);
            serviceErrorIds(model.serviceErrorIds);
        }

        public final String getStackId() {
            return stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Collection<String> getServiceErrorIds() {
            return serviceErrorIds;
        }

        @Override
        public final Builder serviceErrorIds(Collection<String> serviceErrorIds) {
            this.serviceErrorIds = StringsCopier.copy(serviceErrorIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceErrorIds(String... serviceErrorIds) {
            serviceErrorIds(Arrays.asList(serviceErrorIds));
            return this;
        }

        public final void setServiceErrorIds(Collection<String> serviceErrorIds) {
            this.serviceErrorIds = StringsCopier.copy(serviceErrorIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeServiceErrorsRequest build() {
            return new DescribeServiceErrorsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
