/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.opsworks.model.ChefConfiguration;
import software.amazon.awssdk.services.opsworks.model.RootDeviceType;
import software.amazon.awssdk.services.opsworks.model.Source;
import software.amazon.awssdk.services.opsworks.model.StackAttributesCopier;
import software.amazon.awssdk.services.opsworks.model.StackAttributesKeys;
import software.amazon.awssdk.services.opsworks.model.StackConfigurationManager;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Stack
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Stack> {
    private static final SdkField<String> STACK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Stack.getter(Stack::stackId)).setter(Stack.setter(Builder::stackId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Stack.getter(Stack::name)).setter(Stack.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Stack.getter(Stack::arn)).setter(Stack.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Stack.getter(Stack::region)).setter(Stack.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Stack.getter(Stack::vpcId)).setter(Stack.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(Stack.getter(Stack::attributesAsStrings)).setter(Stack.setter(Builder::attributesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> SERVICE_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Stack.getter(Stack::serviceRoleArn)).setter(Stack.setter(Builder::serviceRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceRoleArn").build()}).build();
    private static final SdkField<String> DEFAULT_INSTANCE_PROFILE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Stack.getter(Stack::defaultInstanceProfileArn)).setter(Stack.setter(Builder::defaultInstanceProfileArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultInstanceProfileArn").build()}).build();
    private static final SdkField<String> DEFAULT_OS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Stack.getter(Stack::defaultOs)).setter(Stack.setter(Builder::defaultOs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultOs").build()}).build();
    private static final SdkField<String> HOSTNAME_THEME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Stack.getter(Stack::hostnameTheme)).setter(Stack.setter(Builder::hostnameTheme)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostnameTheme").build()}).build();
    private static final SdkField<String> DEFAULT_AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Stack.getter(Stack::defaultAvailabilityZone)).setter(Stack.setter(Builder::defaultAvailabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultAvailabilityZone").build()}).build();
    private static final SdkField<String> DEFAULT_SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Stack.getter(Stack::defaultSubnetId)).setter(Stack.setter(Builder::defaultSubnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultSubnetId").build()}).build();
    private static final SdkField<String> CUSTOM_JSON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Stack.getter(Stack::customJson)).setter(Stack.setter(Builder::customJson)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomJson").build()}).build();
    private static final SdkField<StackConfigurationManager> CONFIGURATION_MANAGER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Stack.getter(Stack::configurationManager)).setter(Stack.setter(Builder::configurationManager)).constructor(StackConfigurationManager::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationManager").build()}).build();
    private static final SdkField<ChefConfiguration> CHEF_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Stack.getter(Stack::chefConfiguration)).setter(Stack.setter(Builder::chefConfiguration)).constructor(ChefConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChefConfiguration").build()}).build();
    private static final SdkField<Boolean> USE_CUSTOM_COOKBOOKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(Stack.getter(Stack::useCustomCookbooks)).setter(Stack.setter(Builder::useCustomCookbooks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseCustomCookbooks").build()}).build();
    private static final SdkField<Boolean> USE_OPSWORKS_SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(Stack.getter(Stack::useOpsworksSecurityGroups)).setter(Stack.setter(Builder::useOpsworksSecurityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseOpsworksSecurityGroups").build()}).build();
    private static final SdkField<Source> CUSTOM_COOKBOOKS_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Stack.getter(Stack::customCookbooksSource)).setter(Stack.setter(Builder::customCookbooksSource)).constructor(Source::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomCookbooksSource").build()}).build();
    private static final SdkField<String> DEFAULT_SSH_KEY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Stack.getter(Stack::defaultSshKeyName)).setter(Stack.setter(Builder::defaultSshKeyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultSshKeyName").build()}).build();
    private static final SdkField<String> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Stack.getter(Stack::createdAt)).setter(Stack.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<String> DEFAULT_ROOT_DEVICE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Stack.getter(Stack::defaultRootDeviceTypeAsString)).setter(Stack.setter(Builder::defaultRootDeviceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultRootDeviceType").build()}).build();
    private static final SdkField<String> AGENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Stack.getter(Stack::agentVersion)).setter(Stack.setter(Builder::agentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_ID_FIELD, NAME_FIELD, ARN_FIELD, REGION_FIELD, VPC_ID_FIELD, ATTRIBUTES_FIELD, SERVICE_ROLE_ARN_FIELD, DEFAULT_INSTANCE_PROFILE_ARN_FIELD, DEFAULT_OS_FIELD, HOSTNAME_THEME_FIELD, DEFAULT_AVAILABILITY_ZONE_FIELD, DEFAULT_SUBNET_ID_FIELD, CUSTOM_JSON_FIELD, CONFIGURATION_MANAGER_FIELD, CHEF_CONFIGURATION_FIELD, USE_CUSTOM_COOKBOOKS_FIELD, USE_OPSWORKS_SECURITY_GROUPS_FIELD, CUSTOM_COOKBOOKS_SOURCE_FIELD, DEFAULT_SSH_KEY_NAME_FIELD, CREATED_AT_FIELD, DEFAULT_ROOT_DEVICE_TYPE_FIELD, AGENT_VERSION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String stackId;
    private final String name;
    private final String arn;
    private final String region;
    private final String vpcId;
    private final Map<String, String> attributes;
    private final String serviceRoleArn;
    private final String defaultInstanceProfileArn;
    private final String defaultOs;
    private final String hostnameTheme;
    private final String defaultAvailabilityZone;
    private final String defaultSubnetId;
    private final String customJson;
    private final StackConfigurationManager configurationManager;
    private final ChefConfiguration chefConfiguration;
    private final Boolean useCustomCookbooks;
    private final Boolean useOpsworksSecurityGroups;
    private final Source customCookbooksSource;
    private final String defaultSshKeyName;
    private final String createdAt;
    private final String defaultRootDeviceType;
    private final String agentVersion;

    private Stack(BuilderImpl builder) {
        this.stackId = builder.stackId;
        this.name = builder.name;
        this.arn = builder.arn;
        this.region = builder.region;
        this.vpcId = builder.vpcId;
        this.attributes = builder.attributes;
        this.serviceRoleArn = builder.serviceRoleArn;
        this.defaultInstanceProfileArn = builder.defaultInstanceProfileArn;
        this.defaultOs = builder.defaultOs;
        this.hostnameTheme = builder.hostnameTheme;
        this.defaultAvailabilityZone = builder.defaultAvailabilityZone;
        this.defaultSubnetId = builder.defaultSubnetId;
        this.customJson = builder.customJson;
        this.configurationManager = builder.configurationManager;
        this.chefConfiguration = builder.chefConfiguration;
        this.useCustomCookbooks = builder.useCustomCookbooks;
        this.useOpsworksSecurityGroups = builder.useOpsworksSecurityGroups;
        this.customCookbooksSource = builder.customCookbooksSource;
        this.defaultSshKeyName = builder.defaultSshKeyName;
        this.createdAt = builder.createdAt;
        this.defaultRootDeviceType = builder.defaultRootDeviceType;
        this.agentVersion = builder.agentVersion;
    }

    public String stackId() {
        return this.stackId;
    }

    public String name() {
        return this.name;
    }

    public String arn() {
        return this.arn;
    }

    public String region() {
        return this.region;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public Map<StackAttributesKeys, String> attributes() {
        return TypeConverter.convert(this.attributes, StackAttributesKeys::fromValue, Function.identity(), (k, v) -> !Objects.equals(k, (Object)StackAttributesKeys.UNKNOWN_TO_SDK_VERSION));
    }

    public Map<String, String> attributesAsStrings() {
        return this.attributes;
    }

    public String serviceRoleArn() {
        return this.serviceRoleArn;
    }

    public String defaultInstanceProfileArn() {
        return this.defaultInstanceProfileArn;
    }

    public String defaultOs() {
        return this.defaultOs;
    }

    public String hostnameTheme() {
        return this.hostnameTheme;
    }

    public String defaultAvailabilityZone() {
        return this.defaultAvailabilityZone;
    }

    public String defaultSubnetId() {
        return this.defaultSubnetId;
    }

    public String customJson() {
        return this.customJson;
    }

    public StackConfigurationManager configurationManager() {
        return this.configurationManager;
    }

    public ChefConfiguration chefConfiguration() {
        return this.chefConfiguration;
    }

    public Boolean useCustomCookbooks() {
        return this.useCustomCookbooks;
    }

    public Boolean useOpsworksSecurityGroups() {
        return this.useOpsworksSecurityGroups;
    }

    public Source customCookbooksSource() {
        return this.customCookbooksSource;
    }

    public String defaultSshKeyName() {
        return this.defaultSshKeyName;
    }

    public String createdAt() {
        return this.createdAt;
    }

    public RootDeviceType defaultRootDeviceType() {
        return RootDeviceType.fromValue(this.defaultRootDeviceType);
    }

    public String defaultRootDeviceTypeAsString() {
        return this.defaultRootDeviceType;
    }

    public String agentVersion() {
        return this.agentVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultInstanceProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultOs());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostnameTheme());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultAvailabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultSubnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.customJson());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationManager());
        hashCode = 31 * hashCode + Objects.hashCode(this.chefConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.useCustomCookbooks());
        hashCode = 31 * hashCode + Objects.hashCode(this.useOpsworksSecurityGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.customCookbooksSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultSshKeyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultRootDeviceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentVersion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Stack)) {
            return false;
        }
        Stack other = (Stack)obj;
        return Objects.equals(this.stackId(), other.stackId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.attributesAsStrings(), other.attributesAsStrings()) && Objects.equals(this.serviceRoleArn(), other.serviceRoleArn()) && Objects.equals(this.defaultInstanceProfileArn(), other.defaultInstanceProfileArn()) && Objects.equals(this.defaultOs(), other.defaultOs()) && Objects.equals(this.hostnameTheme(), other.hostnameTheme()) && Objects.equals(this.defaultAvailabilityZone(), other.defaultAvailabilityZone()) && Objects.equals(this.defaultSubnetId(), other.defaultSubnetId()) && Objects.equals(this.customJson(), other.customJson()) && Objects.equals(this.configurationManager(), other.configurationManager()) && Objects.equals(this.chefConfiguration(), other.chefConfiguration()) && Objects.equals(this.useCustomCookbooks(), other.useCustomCookbooks()) && Objects.equals(this.useOpsworksSecurityGroups(), other.useOpsworksSecurityGroups()) && Objects.equals(this.customCookbooksSource(), other.customCookbooksSource()) && Objects.equals(this.defaultSshKeyName(), other.defaultSshKeyName()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.defaultRootDeviceTypeAsString(), other.defaultRootDeviceTypeAsString()) && Objects.equals(this.agentVersion(), other.agentVersion());
    }

    public String toString() {
        return ToString.builder((String)"Stack").add("StackId", (Object)this.stackId()).add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("Region", (Object)this.region()).add("VpcId", (Object)this.vpcId()).add("Attributes", this.attributesAsStrings()).add("ServiceRoleArn", (Object)this.serviceRoleArn()).add("DefaultInstanceProfileArn", (Object)this.defaultInstanceProfileArn()).add("DefaultOs", (Object)this.defaultOs()).add("HostnameTheme", (Object)this.hostnameTheme()).add("DefaultAvailabilityZone", (Object)this.defaultAvailabilityZone()).add("DefaultSubnetId", (Object)this.defaultSubnetId()).add("CustomJson", (Object)this.customJson()).add("ConfigurationManager", (Object)this.configurationManager()).add("ChefConfiguration", (Object)this.chefConfiguration()).add("UseCustomCookbooks", (Object)this.useCustomCookbooks()).add("UseOpsworksSecurityGroups", (Object)this.useOpsworksSecurityGroups()).add("CustomCookbooksSource", (Object)this.customCookbooksSource()).add("DefaultSshKeyName", (Object)this.defaultSshKeyName()).add("CreatedAt", (Object)this.createdAt()).add("DefaultRootDeviceType", (Object)this.defaultRootDeviceTypeAsString()).add("AgentVersion", (Object)this.agentVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackId": {
                return Optional.ofNullable(clazz.cast(this.stackId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributesAsStrings()));
            }
            case "ServiceRoleArn": {
                return Optional.ofNullable(clazz.cast(this.serviceRoleArn()));
            }
            case "DefaultInstanceProfileArn": {
                return Optional.ofNullable(clazz.cast(this.defaultInstanceProfileArn()));
            }
            case "DefaultOs": {
                return Optional.ofNullable(clazz.cast(this.defaultOs()));
            }
            case "HostnameTheme": {
                return Optional.ofNullable(clazz.cast(this.hostnameTheme()));
            }
            case "DefaultAvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.defaultAvailabilityZone()));
            }
            case "DefaultSubnetId": {
                return Optional.ofNullable(clazz.cast(this.defaultSubnetId()));
            }
            case "CustomJson": {
                return Optional.ofNullable(clazz.cast(this.customJson()));
            }
            case "ConfigurationManager": {
                return Optional.ofNullable(clazz.cast(this.configurationManager()));
            }
            case "ChefConfiguration": {
                return Optional.ofNullable(clazz.cast(this.chefConfiguration()));
            }
            case "UseCustomCookbooks": {
                return Optional.ofNullable(clazz.cast(this.useCustomCookbooks()));
            }
            case "UseOpsworksSecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.useOpsworksSecurityGroups()));
            }
            case "CustomCookbooksSource": {
                return Optional.ofNullable(clazz.cast(this.customCookbooksSource()));
            }
            case "DefaultSshKeyName": {
                return Optional.ofNullable(clazz.cast(this.defaultSshKeyName()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "DefaultRootDeviceType": {
                return Optional.ofNullable(clazz.cast(this.defaultRootDeviceTypeAsString()));
            }
            case "AgentVersion": {
                return Optional.ofNullable(clazz.cast(this.agentVersion()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Stack, T> g) {
        return obj -> g.apply((Stack)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String stackId;
        private String name;
        private String arn;
        private String region;
        private String vpcId;
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();
        private String serviceRoleArn;
        private String defaultInstanceProfileArn;
        private String defaultOs;
        private String hostnameTheme;
        private String defaultAvailabilityZone;
        private String defaultSubnetId;
        private String customJson;
        private StackConfigurationManager configurationManager;
        private ChefConfiguration chefConfiguration;
        private Boolean useCustomCookbooks;
        private Boolean useOpsworksSecurityGroups;
        private Source customCookbooksSource;
        private String defaultSshKeyName;
        private String createdAt;
        private String defaultRootDeviceType;
        private String agentVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(Stack model) {
            this.stackId(model.stackId);
            this.name(model.name);
            this.arn(model.arn);
            this.region(model.region);
            this.vpcId(model.vpcId);
            this.attributesWithStrings(model.attributes);
            this.serviceRoleArn(model.serviceRoleArn);
            this.defaultInstanceProfileArn(model.defaultInstanceProfileArn);
            this.defaultOs(model.defaultOs);
            this.hostnameTheme(model.hostnameTheme);
            this.defaultAvailabilityZone(model.defaultAvailabilityZone);
            this.defaultSubnetId(model.defaultSubnetId);
            this.customJson(model.customJson);
            this.configurationManager(model.configurationManager);
            this.chefConfiguration(model.chefConfiguration);
            this.useCustomCookbooks(model.useCustomCookbooks);
            this.useOpsworksSecurityGroups(model.useOpsworksSecurityGroups);
            this.customCookbooksSource(model.customCookbooksSource);
            this.defaultSshKeyName(model.defaultSshKeyName);
            this.createdAt(model.createdAt);
            this.defaultRootDeviceType(model.defaultRootDeviceType);
            this.agentVersion(model.agentVersion);
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getRegion() {
            return this.region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final Map<String, String> getAttributes() {
            return this.attributes;
        }

        @Override
        public final Builder attributesWithStrings(Map<String, String> attributes) {
            this.attributes = StackAttributesCopier.copy(attributes);
            return this;
        }

        @Override
        public final Builder attributes(Map<StackAttributesKeys, String> attributes) {
            this.attributes = StackAttributesCopier.copyEnumToString(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = StackAttributesCopier.copy(attributes);
        }

        public final String getServiceRoleArn() {
            return this.serviceRoleArn;
        }

        @Override
        public final Builder serviceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
            return this;
        }

        public final void setServiceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
        }

        public final String getDefaultInstanceProfileArn() {
            return this.defaultInstanceProfileArn;
        }

        @Override
        public final Builder defaultInstanceProfileArn(String defaultInstanceProfileArn) {
            this.defaultInstanceProfileArn = defaultInstanceProfileArn;
            return this;
        }

        public final void setDefaultInstanceProfileArn(String defaultInstanceProfileArn) {
            this.defaultInstanceProfileArn = defaultInstanceProfileArn;
        }

        public final String getDefaultOs() {
            return this.defaultOs;
        }

        @Override
        public final Builder defaultOs(String defaultOs) {
            this.defaultOs = defaultOs;
            return this;
        }

        public final void setDefaultOs(String defaultOs) {
            this.defaultOs = defaultOs;
        }

        public final String getHostnameTheme() {
            return this.hostnameTheme;
        }

        @Override
        public final Builder hostnameTheme(String hostnameTheme) {
            this.hostnameTheme = hostnameTheme;
            return this;
        }

        public final void setHostnameTheme(String hostnameTheme) {
            this.hostnameTheme = hostnameTheme;
        }

        public final String getDefaultAvailabilityZone() {
            return this.defaultAvailabilityZone;
        }

        @Override
        public final Builder defaultAvailabilityZone(String defaultAvailabilityZone) {
            this.defaultAvailabilityZone = defaultAvailabilityZone;
            return this;
        }

        public final void setDefaultAvailabilityZone(String defaultAvailabilityZone) {
            this.defaultAvailabilityZone = defaultAvailabilityZone;
        }

        public final String getDefaultSubnetId() {
            return this.defaultSubnetId;
        }

        @Override
        public final Builder defaultSubnetId(String defaultSubnetId) {
            this.defaultSubnetId = defaultSubnetId;
            return this;
        }

        public final void setDefaultSubnetId(String defaultSubnetId) {
            this.defaultSubnetId = defaultSubnetId;
        }

        public final String getCustomJson() {
            return this.customJson;
        }

        @Override
        public final Builder customJson(String customJson) {
            this.customJson = customJson;
            return this;
        }

        public final void setCustomJson(String customJson) {
            this.customJson = customJson;
        }

        public final StackConfigurationManager.Builder getConfigurationManager() {
            return this.configurationManager != null ? this.configurationManager.toBuilder() : null;
        }

        @Override
        public final Builder configurationManager(StackConfigurationManager configurationManager) {
            this.configurationManager = configurationManager;
            return this;
        }

        public final void setConfigurationManager(StackConfigurationManager.BuilderImpl configurationManager) {
            this.configurationManager = configurationManager != null ? configurationManager.build() : null;
        }

        public final ChefConfiguration.Builder getChefConfiguration() {
            return this.chefConfiguration != null ? this.chefConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder chefConfiguration(ChefConfiguration chefConfiguration) {
            this.chefConfiguration = chefConfiguration;
            return this;
        }

        public final void setChefConfiguration(ChefConfiguration.BuilderImpl chefConfiguration) {
            this.chefConfiguration = chefConfiguration != null ? chefConfiguration.build() : null;
        }

        public final Boolean getUseCustomCookbooks() {
            return this.useCustomCookbooks;
        }

        @Override
        public final Builder useCustomCookbooks(Boolean useCustomCookbooks) {
            this.useCustomCookbooks = useCustomCookbooks;
            return this;
        }

        public final void setUseCustomCookbooks(Boolean useCustomCookbooks) {
            this.useCustomCookbooks = useCustomCookbooks;
        }

        public final Boolean getUseOpsworksSecurityGroups() {
            return this.useOpsworksSecurityGroups;
        }

        @Override
        public final Builder useOpsworksSecurityGroups(Boolean useOpsworksSecurityGroups) {
            this.useOpsworksSecurityGroups = useOpsworksSecurityGroups;
            return this;
        }

        public final void setUseOpsworksSecurityGroups(Boolean useOpsworksSecurityGroups) {
            this.useOpsworksSecurityGroups = useOpsworksSecurityGroups;
        }

        public final Source.Builder getCustomCookbooksSource() {
            return this.customCookbooksSource != null ? this.customCookbooksSource.toBuilder() : null;
        }

        @Override
        public final Builder customCookbooksSource(Source customCookbooksSource) {
            this.customCookbooksSource = customCookbooksSource;
            return this;
        }

        public final void setCustomCookbooksSource(Source.BuilderImpl customCookbooksSource) {
            this.customCookbooksSource = customCookbooksSource != null ? customCookbooksSource.build() : null;
        }

        public final String getDefaultSshKeyName() {
            return this.defaultSshKeyName;
        }

        @Override
        public final Builder defaultSshKeyName(String defaultSshKeyName) {
            this.defaultSshKeyName = defaultSshKeyName;
            return this;
        }

        public final void setDefaultSshKeyName(String defaultSshKeyName) {
            this.defaultSshKeyName = defaultSshKeyName;
        }

        public final String getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        public final String getDefaultRootDeviceType() {
            return this.defaultRootDeviceType;
        }

        @Override
        public final Builder defaultRootDeviceType(String defaultRootDeviceType) {
            this.defaultRootDeviceType = defaultRootDeviceType;
            return this;
        }

        @Override
        public final Builder defaultRootDeviceType(RootDeviceType defaultRootDeviceType) {
            this.defaultRootDeviceType(defaultRootDeviceType.toString());
            return this;
        }

        public final void setDefaultRootDeviceType(String defaultRootDeviceType) {
            this.defaultRootDeviceType = defaultRootDeviceType;
        }

        public final String getAgentVersion() {
            return this.agentVersion;
        }

        @Override
        public final Builder agentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
            return this;
        }

        public final void setAgentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
        }

        public Stack build() {
            return new Stack(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Stack> {
        public Builder stackId(String var1);

        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder region(String var1);

        public Builder vpcId(String var1);

        public Builder attributesWithStrings(Map<String, String> var1);

        public Builder attributes(Map<StackAttributesKeys, String> var1);

        public Builder serviceRoleArn(String var1);

        public Builder defaultInstanceProfileArn(String var1);

        public Builder defaultOs(String var1);

        public Builder hostnameTheme(String var1);

        public Builder defaultAvailabilityZone(String var1);

        public Builder defaultSubnetId(String var1);

        public Builder customJson(String var1);

        public Builder configurationManager(StackConfigurationManager var1);

        default public Builder configurationManager(Consumer<StackConfigurationManager.Builder> configurationManager) {
            return this.configurationManager((StackConfigurationManager)((StackConfigurationManager.Builder)StackConfigurationManager.builder().applyMutation(configurationManager)).build());
        }

        public Builder chefConfiguration(ChefConfiguration var1);

        default public Builder chefConfiguration(Consumer<ChefConfiguration.Builder> chefConfiguration) {
            return this.chefConfiguration((ChefConfiguration)((ChefConfiguration.Builder)ChefConfiguration.builder().applyMutation(chefConfiguration)).build());
        }

        public Builder useCustomCookbooks(Boolean var1);

        public Builder useOpsworksSecurityGroups(Boolean var1);

        public Builder customCookbooksSource(Source var1);

        default public Builder customCookbooksSource(Consumer<Source.Builder> customCookbooksSource) {
            return this.customCookbooksSource((Source)((Source.Builder)Source.builder().applyMutation(customCookbooksSource)).build());
        }

        public Builder defaultSshKeyName(String var1);

        public Builder createdAt(String var1);

        public Builder defaultRootDeviceType(String var1);

        public Builder defaultRootDeviceType(RootDeviceType var1);

        public Builder agentVersion(String var1);
    }
}

