/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetHostnameSuggestionRequest extends OpsWorksRequest implements
        ToCopyableBuilder<GetHostnameSuggestionRequest.Builder, GetHostnameSuggestionRequest> {
    private static final SdkField<String> LAYER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetHostnameSuggestionRequest::layerId)).setter(setter(Builder::layerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LayerId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAYER_ID_FIELD));

    private final String layerId;

    private GetHostnameSuggestionRequest(BuilderImpl builder) {
        super(builder);
        this.layerId = builder.layerId;
    }

    /**
     * <p>
     * The layer ID.
     * </p>
     * 
     * @return The layer ID.
     */
    public String layerId() {
        return layerId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(layerId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetHostnameSuggestionRequest)) {
            return false;
        }
        GetHostnameSuggestionRequest other = (GetHostnameSuggestionRequest) obj;
        return Objects.equals(layerId(), other.layerId());
    }

    @Override
    public String toString() {
        return ToString.builder("GetHostnameSuggestionRequest").add("LayerId", layerId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LayerId":
            return Optional.ofNullable(clazz.cast(layerId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetHostnameSuggestionRequest, T> g) {
        return obj -> g.apply((GetHostnameSuggestionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpsWorksRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetHostnameSuggestionRequest> {
        /**
         * <p>
         * The layer ID.
         * </p>
         * 
         * @param layerId
         *        The layer ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layerId(String layerId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpsWorksRequest.BuilderImpl implements Builder {
        private String layerId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetHostnameSuggestionRequest model) {
            super(model);
            layerId(model.layerId);
        }

        public final String getLayerId() {
            return layerId;
        }

        @Override
        public final Builder layerId(String layerId) {
            this.layerId = layerId;
            return this;
        }

        public final void setLayerId(String layerId) {
            this.layerId = layerId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetHostnameSuggestionRequest build() {
            return new GetHostnameSuggestionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
