/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summarizes the number of layers, instances, and apps in a stack.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StackSummary implements SdkPojo, Serializable, ToCopyableBuilder<StackSummary.Builder, StackSummary> {
    private static final SdkField<String> STACK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StackSummary::stackId)).setter(setter(Builder::stackId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StackSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StackSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<Integer> LAYERS_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(StackSummary::layersCount)).setter(setter(Builder::layersCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LayersCount").build()).build();

    private static final SdkField<Integer> APPS_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(StackSummary::appsCount)).setter(setter(Builder::appsCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppsCount").build()).build();

    private static final SdkField<InstancesCount> INSTANCES_COUNT_FIELD = SdkField
            .<InstancesCount> builder(MarshallingType.SDK_POJO).getter(getter(StackSummary::instancesCount))
            .setter(setter(Builder::instancesCount)).constructor(InstancesCount::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancesCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_ID_FIELD, NAME_FIELD,
            ARN_FIELD, LAYERS_COUNT_FIELD, APPS_COUNT_FIELD, INSTANCES_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String stackId;

    private final String name;

    private final String arn;

    private final Integer layersCount;

    private final Integer appsCount;

    private final InstancesCount instancesCount;

    private StackSummary(BuilderImpl builder) {
        this.stackId = builder.stackId;
        this.name = builder.name;
        this.arn = builder.arn;
        this.layersCount = builder.layersCount;
        this.appsCount = builder.appsCount;
        this.instancesCount = builder.instancesCount;
    }

    /**
     * <p>
     * The stack ID.
     * </p>
     * 
     * @return The stack ID.
     */
    public String stackId() {
        return stackId;
    }

    /**
     * <p>
     * The stack name.
     * </p>
     * 
     * @return The stack name.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The stack's ARN.
     * </p>
     * 
     * @return The stack's ARN.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The number of layers.
     * </p>
     * 
     * @return The number of layers.
     */
    public Integer layersCount() {
        return layersCount;
    }

    /**
     * <p>
     * The number of apps.
     * </p>
     * 
     * @return The number of apps.
     */
    public Integer appsCount() {
        return appsCount;
    }

    /**
     * <p>
     * An <code>InstancesCount</code> object with the number of instances in each status.
     * </p>
     * 
     * @return An <code>InstancesCount</code> object with the number of instances in each status.
     */
    public InstancesCount instancesCount() {
        return instancesCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stackId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(layersCount());
        hashCode = 31 * hashCode + Objects.hashCode(appsCount());
        hashCode = 31 * hashCode + Objects.hashCode(instancesCount());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StackSummary)) {
            return false;
        }
        StackSummary other = (StackSummary) obj;
        return Objects.equals(stackId(), other.stackId()) && Objects.equals(name(), other.name())
                && Objects.equals(arn(), other.arn()) && Objects.equals(layersCount(), other.layersCount())
                && Objects.equals(appsCount(), other.appsCount()) && Objects.equals(instancesCount(), other.instancesCount());
    }

    @Override
    public String toString() {
        return ToString.builder("StackSummary").add("StackId", stackId()).add("Name", name()).add("Arn", arn())
                .add("LayersCount", layersCount()).add("AppsCount", appsCount()).add("InstancesCount", instancesCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackId":
            return Optional.ofNullable(clazz.cast(stackId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "LayersCount":
            return Optional.ofNullable(clazz.cast(layersCount()));
        case "AppsCount":
            return Optional.ofNullable(clazz.cast(appsCount()));
        case "InstancesCount":
            return Optional.ofNullable(clazz.cast(instancesCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StackSummary, T> g) {
        return obj -> g.apply((StackSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StackSummary> {
        /**
         * <p>
         * The stack ID.
         * </p>
         * 
         * @param stackId
         *        The stack ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * The stack name.
         * </p>
         * 
         * @param name
         *        The stack name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The stack's ARN.
         * </p>
         * 
         * @param arn
         *        The stack's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The number of layers.
         * </p>
         * 
         * @param layersCount
         *        The number of layers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layersCount(Integer layersCount);

        /**
         * <p>
         * The number of apps.
         * </p>
         * 
         * @param appsCount
         *        The number of apps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appsCount(Integer appsCount);

        /**
         * <p>
         * An <code>InstancesCount</code> object with the number of instances in each status.
         * </p>
         * 
         * @param instancesCount
         *        An <code>InstancesCount</code> object with the number of instances in each status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instancesCount(InstancesCount instancesCount);

        /**
         * <p>
         * An <code>InstancesCount</code> object with the number of instances in each status.
         * </p>
         * This is a convenience that creates an instance of the {@link InstancesCount.Builder} avoiding the need to
         * create one manually via {@link InstancesCount#builder()}.
         *
         * When the {@link Consumer} completes, {@link InstancesCount.Builder#build()} is called immediately and its
         * result is passed to {@link #instancesCount(InstancesCount)}.
         * 
         * @param instancesCount
         *        a consumer that will call methods on {@link InstancesCount.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instancesCount(InstancesCount)
         */
        default Builder instancesCount(Consumer<InstancesCount.Builder> instancesCount) {
            return instancesCount(InstancesCount.builder().applyMutation(instancesCount).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String stackId;

        private String name;

        private String arn;

        private Integer layersCount;

        private Integer appsCount;

        private InstancesCount instancesCount;

        private BuilderImpl() {
        }

        private BuilderImpl(StackSummary model) {
            stackId(model.stackId);
            name(model.name);
            arn(model.arn);
            layersCount(model.layersCount);
            appsCount(model.appsCount);
            instancesCount(model.instancesCount);
        }

        public final String getStackId() {
            return stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Integer getLayersCount() {
            return layersCount;
        }

        @Override
        public final Builder layersCount(Integer layersCount) {
            this.layersCount = layersCount;
            return this;
        }

        public final void setLayersCount(Integer layersCount) {
            this.layersCount = layersCount;
        }

        public final Integer getAppsCount() {
            return appsCount;
        }

        @Override
        public final Builder appsCount(Integer appsCount) {
            this.appsCount = appsCount;
            return this;
        }

        public final void setAppsCount(Integer appsCount) {
            this.appsCount = appsCount;
        }

        public final InstancesCount.Builder getInstancesCount() {
            return instancesCount != null ? instancesCount.toBuilder() : null;
        }

        @Override
        public final Builder instancesCount(InstancesCount instancesCount) {
            this.instancesCount = instancesCount;
            return this;
        }

        public final void setInstancesCount(InstancesCount.BuilderImpl instancesCount) {
            this.instancesCount = instancesCount != null ? instancesCount.build() : null;
        }

        @Override
        public StackSummary build() {
            return new StackSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
