/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Used to specify a stack or deployment command.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeploymentCommand implements SdkPojo, Serializable,
        ToCopyableBuilder<DeploymentCommand.Builder, DeploymentCommand> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeploymentCommand::nameAsString)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Map<String, List<String>>> ARGS_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .getter(getter(DeploymentCommand::args))
            .setter(setter(Builder::args))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Args").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final Map<String, List<String>> args;

    private DeploymentCommand(BuilderImpl builder) {
        this.name = builder.name;
        this.args = builder.args;
    }

    /**
     * <p>
     * Specifies the operation. You can specify only one command.
     * </p>
     * <p>
     * For stacks, the following commands are available:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>execute_recipes</code>: Execute one or more recipes. To specify the recipes, set an <code>Args</code>
     * parameter named <code>recipes</code> to the list of recipes to be executed. For example, to execute
     * <code>phpapp::appsetup</code>, set <code>Args</code> to <code>{"recipes":["phpapp::appsetup"]}</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>install_dependencies</code>: Install the stack's dependencies.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>update_custom_cookbooks</code>: Update the stack's custom cookbooks.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>update_dependencies</code>: Update the stack's dependencies.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * The update_dependencies and install_dependencies commands are supported only for Linux instances. You can run the
     * commands successfully on Windows instances, but they do nothing.
     * </p>
     * </note>
     * <p>
     * For apps, the following commands are available:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>deploy</code>: Deploy an app. Ruby on Rails apps have an optional <code>Args</code> parameter named
     * <code>migrate</code>. Set <code>Args</code> to {"migrate":["true"]} to migrate the database. The default setting
     * is {"migrate":["false"]}.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>rollback</code> Roll the app back to the previous version. When you update an app, AWS OpsWorks Stacks
     * stores the previous version, up to a maximum of five versions. You can use this command to roll an app back as
     * many as four versions.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>start</code>: Start the app's web or application server.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>stop</code>: Stop the app's web or application server.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>restart</code>: Restart the app's web or application server.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>undeploy</code>: Undeploy the app.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link DeploymentCommandName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return Specifies the operation. You can specify only one command.</p>
     *         <p>
     *         For stacks, the following commands are available:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>execute_recipes</code>: Execute one or more recipes. To specify the recipes, set an
     *         <code>Args</code> parameter named <code>recipes</code> to the list of recipes to be executed. For
     *         example, to execute <code>phpapp::appsetup</code>, set <code>Args</code> to
     *         <code>{"recipes":["phpapp::appsetup"]}</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>install_dependencies</code>: Install the stack's dependencies.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>update_custom_cookbooks</code>: Update the stack's custom cookbooks.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>update_dependencies</code>: Update the stack's dependencies.
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         The update_dependencies and install_dependencies commands are supported only for Linux instances. You can
     *         run the commands successfully on Windows instances, but they do nothing.
     *         </p>
     *         </note>
     *         <p>
     *         For apps, the following commands are available:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>deploy</code>: Deploy an app. Ruby on Rails apps have an optional <code>Args</code> parameter named
     *         <code>migrate</code>. Set <code>Args</code> to {"migrate":["true"]} to migrate the database. The default
     *         setting is {"migrate":["false"]}.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>rollback</code> Roll the app back to the previous version. When you update an app, AWS OpsWorks
     *         Stacks stores the previous version, up to a maximum of five versions. You can use this command to roll an
     *         app back as many as four versions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>start</code>: Start the app's web or application server.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>stop</code>: Stop the app's web or application server.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>restart</code>: Restart the app's web or application server.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>undeploy</code>: Undeploy the app.
     *         </p>
     *         </li>
     * @see DeploymentCommandName
     */
    public DeploymentCommandName name() {
        return DeploymentCommandName.fromValue(name);
    }

    /**
     * <p>
     * Specifies the operation. You can specify only one command.
     * </p>
     * <p>
     * For stacks, the following commands are available:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>execute_recipes</code>: Execute one or more recipes. To specify the recipes, set an <code>Args</code>
     * parameter named <code>recipes</code> to the list of recipes to be executed. For example, to execute
     * <code>phpapp::appsetup</code>, set <code>Args</code> to <code>{"recipes":["phpapp::appsetup"]}</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>install_dependencies</code>: Install the stack's dependencies.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>update_custom_cookbooks</code>: Update the stack's custom cookbooks.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>update_dependencies</code>: Update the stack's dependencies.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * The update_dependencies and install_dependencies commands are supported only for Linux instances. You can run the
     * commands successfully on Windows instances, but they do nothing.
     * </p>
     * </note>
     * <p>
     * For apps, the following commands are available:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>deploy</code>: Deploy an app. Ruby on Rails apps have an optional <code>Args</code> parameter named
     * <code>migrate</code>. Set <code>Args</code> to {"migrate":["true"]} to migrate the database. The default setting
     * is {"migrate":["false"]}.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>rollback</code> Roll the app back to the previous version. When you update an app, AWS OpsWorks Stacks
     * stores the previous version, up to a maximum of five versions. You can use this command to roll an app back as
     * many as four versions.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>start</code>: Start the app's web or application server.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>stop</code>: Stop the app's web or application server.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>restart</code>: Restart the app's web or application server.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>undeploy</code>: Undeploy the app.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link DeploymentCommandName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return Specifies the operation. You can specify only one command.</p>
     *         <p>
     *         For stacks, the following commands are available:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>execute_recipes</code>: Execute one or more recipes. To specify the recipes, set an
     *         <code>Args</code> parameter named <code>recipes</code> to the list of recipes to be executed. For
     *         example, to execute <code>phpapp::appsetup</code>, set <code>Args</code> to
     *         <code>{"recipes":["phpapp::appsetup"]}</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>install_dependencies</code>: Install the stack's dependencies.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>update_custom_cookbooks</code>: Update the stack's custom cookbooks.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>update_dependencies</code>: Update the stack's dependencies.
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         The update_dependencies and install_dependencies commands are supported only for Linux instances. You can
     *         run the commands successfully on Windows instances, but they do nothing.
     *         </p>
     *         </note>
     *         <p>
     *         For apps, the following commands are available:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>deploy</code>: Deploy an app. Ruby on Rails apps have an optional <code>Args</code> parameter named
     *         <code>migrate</code>. Set <code>Args</code> to {"migrate":["true"]} to migrate the database. The default
     *         setting is {"migrate":["false"]}.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>rollback</code> Roll the app back to the previous version. When you update an app, AWS OpsWorks
     *         Stacks stores the previous version, up to a maximum of five versions. You can use this command to roll an
     *         app back as many as four versions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>start</code>: Start the app's web or application server.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>stop</code>: Stop the app's web or application server.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>restart</code>: Restart the app's web or application server.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>undeploy</code>: Undeploy the app.
     *         </p>
     *         </li>
     * @see DeploymentCommandName
     */
    public String nameAsString() {
        return name;
    }

    /**
     * <p>
     * The arguments of those commands that take arguments. It should be set to a JSON object with the following format:
     * </p>
     * <p>
     * <code>{"arg_name1" : ["value1", "value2", ...], "arg_name2" : ["value1", "value2", ...], ...}</code>
     * </p>
     * <p>
     * The <code>update_dependencies</code> command takes two arguments:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>upgrade_os_to</code> - Specifies the desired Amazon Linux version for instances whose OS you want to
     * upgrade, such as <code>Amazon Linux 2016.09</code>. You must also set the <code>allow_reboot</code> argument to
     * true.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>allow_reboot</code> - Specifies whether to allow AWS OpsWorks Stacks to reboot the instances if necessary,
     * after installing the updates. This argument can be set to either <code>true</code> or <code>false</code>. The
     * default value is <code>false</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For example, to upgrade an instance to Amazon Linux 2016.09, set <code>Args</code> to the following.
     * </p>
     * <p>
     * <code> { "upgrade_os_to":["Amazon Linux 2016.09"], "allow_reboot":["true"] } </code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The arguments of those commands that take arguments. It should be set to a JSON object with the following
     *         format:</p>
     *         <p>
     *         <code>{"arg_name1" : ["value1", "value2", ...], "arg_name2" : ["value1", "value2", ...], ...}</code>
     *         </p>
     *         <p>
     *         The <code>update_dependencies</code> command takes two arguments:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>upgrade_os_to</code> - Specifies the desired Amazon Linux version for instances whose OS you want
     *         to upgrade, such as <code>Amazon Linux 2016.09</code>. You must also set the <code>allow_reboot</code>
     *         argument to true.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>allow_reboot</code> - Specifies whether to allow AWS OpsWorks Stacks to reboot the instances if
     *         necessary, after installing the updates. This argument can be set to either <code>true</code> or
     *         <code>false</code>. The default value is <code>false</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For example, to upgrade an instance to Amazon Linux 2016.09, set <code>Args</code> to the following.
     *         </p>
     *         <p>
     *         <code> { "upgrade_os_to":["Amazon Linux 2016.09"], "allow_reboot":["true"] } </code>
     */
    public Map<String, List<String>> args() {
        return args;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(args());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentCommand)) {
            return false;
        }
        DeploymentCommand other = (DeploymentCommand) obj;
        return Objects.equals(nameAsString(), other.nameAsString()) && Objects.equals(args(), other.args());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeploymentCommand").add("Name", nameAsString()).add("Args", args()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(nameAsString()));
        case "Args":
            return Optional.ofNullable(clazz.cast(args()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeploymentCommand, T> g) {
        return obj -> g.apply((DeploymentCommand) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeploymentCommand> {
        /**
         * <p>
         * Specifies the operation. You can specify only one command.
         * </p>
         * <p>
         * For stacks, the following commands are available:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>execute_recipes</code>: Execute one or more recipes. To specify the recipes, set an <code>Args</code>
         * parameter named <code>recipes</code> to the list of recipes to be executed. For example, to execute
         * <code>phpapp::appsetup</code>, set <code>Args</code> to <code>{"recipes":["phpapp::appsetup"]}</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>install_dependencies</code>: Install the stack's dependencies.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>update_custom_cookbooks</code>: Update the stack's custom cookbooks.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>update_dependencies</code>: Update the stack's dependencies.
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * The update_dependencies and install_dependencies commands are supported only for Linux instances. You can run
         * the commands successfully on Windows instances, but they do nothing.
         * </p>
         * </note>
         * <p>
         * For apps, the following commands are available:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>deploy</code>: Deploy an app. Ruby on Rails apps have an optional <code>Args</code> parameter named
         * <code>migrate</code>. Set <code>Args</code> to {"migrate":["true"]} to migrate the database. The default
         * setting is {"migrate":["false"]}.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>rollback</code> Roll the app back to the previous version. When you update an app, AWS OpsWorks Stacks
         * stores the previous version, up to a maximum of five versions. You can use this command to roll an app back
         * as many as four versions.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>start</code>: Start the app's web or application server.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>stop</code>: Stop the app's web or application server.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>restart</code>: Restart the app's web or application server.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>undeploy</code>: Undeploy the app.
         * </p>
         * </li>
         * </ul>
         * 
         * @param name
         *        Specifies the operation. You can specify only one command.</p>
         *        <p>
         *        For stacks, the following commands are available:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>execute_recipes</code>: Execute one or more recipes. To specify the recipes, set an
         *        <code>Args</code> parameter named <code>recipes</code> to the list of recipes to be executed. For
         *        example, to execute <code>phpapp::appsetup</code>, set <code>Args</code> to
         *        <code>{"recipes":["phpapp::appsetup"]}</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>install_dependencies</code>: Install the stack's dependencies.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>update_custom_cookbooks</code>: Update the stack's custom cookbooks.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>update_dependencies</code>: Update the stack's dependencies.
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        The update_dependencies and install_dependencies commands are supported only for Linux instances. You
         *        can run the commands successfully on Windows instances, but they do nothing.
         *        </p>
         *        </note>
         *        <p>
         *        For apps, the following commands are available:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>deploy</code>: Deploy an app. Ruby on Rails apps have an optional <code>Args</code> parameter
         *        named <code>migrate</code>. Set <code>Args</code> to {"migrate":["true"]} to migrate the database. The
         *        default setting is {"migrate":["false"]}.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>rollback</code> Roll the app back to the previous version. When you update an app, AWS OpsWorks
         *        Stacks stores the previous version, up to a maximum of five versions. You can use this command to roll
         *        an app back as many as four versions.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>start</code>: Start the app's web or application server.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>stop</code>: Stop the app's web or application server.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>restart</code>: Restart the app's web or application server.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>undeploy</code>: Undeploy the app.
         *        </p>
         *        </li>
         * @see DeploymentCommandName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentCommandName
         */
        Builder name(String name);

        /**
         * <p>
         * Specifies the operation. You can specify only one command.
         * </p>
         * <p>
         * For stacks, the following commands are available:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>execute_recipes</code>: Execute one or more recipes. To specify the recipes, set an <code>Args</code>
         * parameter named <code>recipes</code> to the list of recipes to be executed. For example, to execute
         * <code>phpapp::appsetup</code>, set <code>Args</code> to <code>{"recipes":["phpapp::appsetup"]}</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>install_dependencies</code>: Install the stack's dependencies.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>update_custom_cookbooks</code>: Update the stack's custom cookbooks.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>update_dependencies</code>: Update the stack's dependencies.
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * The update_dependencies and install_dependencies commands are supported only for Linux instances. You can run
         * the commands successfully on Windows instances, but they do nothing.
         * </p>
         * </note>
         * <p>
         * For apps, the following commands are available:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>deploy</code>: Deploy an app. Ruby on Rails apps have an optional <code>Args</code> parameter named
         * <code>migrate</code>. Set <code>Args</code> to {"migrate":["true"]} to migrate the database. The default
         * setting is {"migrate":["false"]}.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>rollback</code> Roll the app back to the previous version. When you update an app, AWS OpsWorks Stacks
         * stores the previous version, up to a maximum of five versions. You can use this command to roll an app back
         * as many as four versions.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>start</code>: Start the app's web or application server.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>stop</code>: Stop the app's web or application server.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>restart</code>: Restart the app's web or application server.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>undeploy</code>: Undeploy the app.
         * </p>
         * </li>
         * </ul>
         * 
         * @param name
         *        Specifies the operation. You can specify only one command.</p>
         *        <p>
         *        For stacks, the following commands are available:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>execute_recipes</code>: Execute one or more recipes. To specify the recipes, set an
         *        <code>Args</code> parameter named <code>recipes</code> to the list of recipes to be executed. For
         *        example, to execute <code>phpapp::appsetup</code>, set <code>Args</code> to
         *        <code>{"recipes":["phpapp::appsetup"]}</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>install_dependencies</code>: Install the stack's dependencies.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>update_custom_cookbooks</code>: Update the stack's custom cookbooks.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>update_dependencies</code>: Update the stack's dependencies.
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        The update_dependencies and install_dependencies commands are supported only for Linux instances. You
         *        can run the commands successfully on Windows instances, but they do nothing.
         *        </p>
         *        </note>
         *        <p>
         *        For apps, the following commands are available:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>deploy</code>: Deploy an app. Ruby on Rails apps have an optional <code>Args</code> parameter
         *        named <code>migrate</code>. Set <code>Args</code> to {"migrate":["true"]} to migrate the database. The
         *        default setting is {"migrate":["false"]}.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>rollback</code> Roll the app back to the previous version. When you update an app, AWS OpsWorks
         *        Stacks stores the previous version, up to a maximum of five versions. You can use this command to roll
         *        an app back as many as four versions.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>start</code>: Start the app's web or application server.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>stop</code>: Stop the app's web or application server.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>restart</code>: Restart the app's web or application server.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>undeploy</code>: Undeploy the app.
         *        </p>
         *        </li>
         * @see DeploymentCommandName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentCommandName
         */
        Builder name(DeploymentCommandName name);

        /**
         * <p>
         * The arguments of those commands that take arguments. It should be set to a JSON object with the following
         * format:
         * </p>
         * <p>
         * <code>{"arg_name1" : ["value1", "value2", ...], "arg_name2" : ["value1", "value2", ...], ...}</code>
         * </p>
         * <p>
         * The <code>update_dependencies</code> command takes two arguments:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>upgrade_os_to</code> - Specifies the desired Amazon Linux version for instances whose OS you want to
         * upgrade, such as <code>Amazon Linux 2016.09</code>. You must also set the <code>allow_reboot</code> argument
         * to true.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>allow_reboot</code> - Specifies whether to allow AWS OpsWorks Stacks to reboot the instances if
         * necessary, after installing the updates. This argument can be set to either <code>true</code> or
         * <code>false</code>. The default value is <code>false</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For example, to upgrade an instance to Amazon Linux 2016.09, set <code>Args</code> to the following.
         * </p>
         * <p>
         * <code> { "upgrade_os_to":["Amazon Linux 2016.09"], "allow_reboot":["true"] } </code>
         * </p>
         * 
         * @param args
         *        The arguments of those commands that take arguments. It should be set to a JSON object with the
         *        following format:</p>
         *        <p>
         *        <code>{"arg_name1" : ["value1", "value2", ...], "arg_name2" : ["value1", "value2", ...], ...}</code>
         *        </p>
         *        <p>
         *        The <code>update_dependencies</code> command takes two arguments:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>upgrade_os_to</code> - Specifies the desired Amazon Linux version for instances whose OS you
         *        want to upgrade, such as <code>Amazon Linux 2016.09</code>. You must also set the
         *        <code>allow_reboot</code> argument to true.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>allow_reboot</code> - Specifies whether to allow AWS OpsWorks Stacks to reboot the instances if
         *        necessary, after installing the updates. This argument can be set to either <code>true</code> or
         *        <code>false</code>. The default value is <code>false</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For example, to upgrade an instance to Amazon Linux 2016.09, set <code>Args</code> to the following.
         *        </p>
         *        <p>
         *        <code> { "upgrade_os_to":["Amazon Linux 2016.09"], "allow_reboot":["true"] } </code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder args(Map<String, ? extends Collection<String>> args);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private Map<String, List<String>> args = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentCommand model) {
            name(model.name);
            args(model.args);
        }

        public final String getNameAsString() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(DeploymentCommandName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Map<String, ? extends Collection<String>> getArgs() {
            return args;
        }

        @Override
        public final Builder args(Map<String, ? extends Collection<String>> args) {
            this.args = DeploymentCommandArgsCopier.copy(args);
            return this;
        }

        public final void setArgs(Map<String, ? extends Collection<String>> args) {
            this.args = DeploymentCommandArgsCopier.copy(args);
        }

        @Override
        public DeploymentCommand build() {
            return new DeploymentCommand(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
