/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateStackRequest extends OpsWorksRequest implements
        ToCopyableBuilder<CreateStackRequest.Builder, CreateStackRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateStackRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateStackRequest::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateStackRequest::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(CreateStackRequest::attributesAsStrings))
            .setter(setter(Builder::attributesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> SERVICE_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateStackRequest::serviceRoleArn)).setter(setter(Builder::serviceRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceRoleArn").build()).build();

    private static final SdkField<String> DEFAULT_INSTANCE_PROFILE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateStackRequest::defaultInstanceProfileArn)).setter(setter(Builder::defaultInstanceProfileArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultInstanceProfileArn").build())
            .build();

    private static final SdkField<String> DEFAULT_OS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateStackRequest::defaultOs)).setter(setter(Builder::defaultOs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultOs").build()).build();

    private static final SdkField<String> HOSTNAME_THEME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateStackRequest::hostnameTheme)).setter(setter(Builder::hostnameTheme))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostnameTheme").build()).build();

    private static final SdkField<String> DEFAULT_AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateStackRequest::defaultAvailabilityZone)).setter(setter(Builder::defaultAvailabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultAvailabilityZone").build())
            .build();

    private static final SdkField<String> DEFAULT_SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateStackRequest::defaultSubnetId)).setter(setter(Builder::defaultSubnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultSubnetId").build()).build();

    private static final SdkField<String> CUSTOM_JSON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateStackRequest::customJson)).setter(setter(Builder::customJson))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomJson").build()).build();

    private static final SdkField<StackConfigurationManager> CONFIGURATION_MANAGER_FIELD = SdkField
            .<StackConfigurationManager> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateStackRequest::configurationManager)).setter(setter(Builder::configurationManager))
            .constructor(StackConfigurationManager::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationManager").build())
            .build();

    private static final SdkField<ChefConfiguration> CHEF_CONFIGURATION_FIELD = SdkField
            .<ChefConfiguration> builder(MarshallingType.SDK_POJO).getter(getter(CreateStackRequest::chefConfiguration))
            .setter(setter(Builder::chefConfiguration)).constructor(ChefConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChefConfiguration").build()).build();

    private static final SdkField<Boolean> USE_CUSTOM_COOKBOOKS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CreateStackRequest::useCustomCookbooks)).setter(setter(Builder::useCustomCookbooks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseCustomCookbooks").build())
            .build();

    private static final SdkField<Boolean> USE_OPSWORKS_SECURITY_GROUPS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).getter(getter(CreateStackRequest::useOpsworksSecurityGroups))
            .setter(setter(Builder::useOpsworksSecurityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseOpsworksSecurityGroups").build())
            .build();

    private static final SdkField<Source> CUSTOM_COOKBOOKS_SOURCE_FIELD = SdkField.<Source> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateStackRequest::customCookbooksSource)).setter(setter(Builder::customCookbooksSource))
            .constructor(Source::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomCookbooksSource").build())
            .build();

    private static final SdkField<String> DEFAULT_SSH_KEY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateStackRequest::defaultSshKeyName)).setter(setter(Builder::defaultSshKeyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultSshKeyName").build()).build();

    private static final SdkField<String> DEFAULT_ROOT_DEVICE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateStackRequest::defaultRootDeviceTypeAsString)).setter(setter(Builder::defaultRootDeviceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultRootDeviceType").build())
            .build();

    private static final SdkField<String> AGENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateStackRequest::agentVersion)).setter(setter(Builder::agentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, REGION_FIELD,
            VPC_ID_FIELD, ATTRIBUTES_FIELD, SERVICE_ROLE_ARN_FIELD, DEFAULT_INSTANCE_PROFILE_ARN_FIELD, DEFAULT_OS_FIELD,
            HOSTNAME_THEME_FIELD, DEFAULT_AVAILABILITY_ZONE_FIELD, DEFAULT_SUBNET_ID_FIELD, CUSTOM_JSON_FIELD,
            CONFIGURATION_MANAGER_FIELD, CHEF_CONFIGURATION_FIELD, USE_CUSTOM_COOKBOOKS_FIELD,
            USE_OPSWORKS_SECURITY_GROUPS_FIELD, CUSTOM_COOKBOOKS_SOURCE_FIELD, DEFAULT_SSH_KEY_NAME_FIELD,
            DEFAULT_ROOT_DEVICE_TYPE_FIELD, AGENT_VERSION_FIELD));

    private final String name;

    private final String region;

    private final String vpcId;

    private final Map<String, String> attributes;

    private final String serviceRoleArn;

    private final String defaultInstanceProfileArn;

    private final String defaultOs;

    private final String hostnameTheme;

    private final String defaultAvailabilityZone;

    private final String defaultSubnetId;

    private final String customJson;

    private final StackConfigurationManager configurationManager;

    private final ChefConfiguration chefConfiguration;

    private final Boolean useCustomCookbooks;

    private final Boolean useOpsworksSecurityGroups;

    private final Source customCookbooksSource;

    private final String defaultSshKeyName;

    private final String defaultRootDeviceType;

    private final String agentVersion;

    private CreateStackRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.region = builder.region;
        this.vpcId = builder.vpcId;
        this.attributes = builder.attributes;
        this.serviceRoleArn = builder.serviceRoleArn;
        this.defaultInstanceProfileArn = builder.defaultInstanceProfileArn;
        this.defaultOs = builder.defaultOs;
        this.hostnameTheme = builder.hostnameTheme;
        this.defaultAvailabilityZone = builder.defaultAvailabilityZone;
        this.defaultSubnetId = builder.defaultSubnetId;
        this.customJson = builder.customJson;
        this.configurationManager = builder.configurationManager;
        this.chefConfiguration = builder.chefConfiguration;
        this.useCustomCookbooks = builder.useCustomCookbooks;
        this.useOpsworksSecurityGroups = builder.useOpsworksSecurityGroups;
        this.customCookbooksSource = builder.customCookbooksSource;
        this.defaultSshKeyName = builder.defaultSshKeyName;
        this.defaultRootDeviceType = builder.defaultRootDeviceType;
        this.agentVersion = builder.agentVersion;
    }

    /**
     * <p>
     * The stack name.
     * </p>
     * 
     * @return The stack name.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The stack's AWS region, such as <code>ap-south-1</code>. For more information about Amazon regions, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.
     * </p>
     * <note>
     * <p>
     * In the AWS CLI, this API maps to the <code>--stack-region</code> parameter. If the <code>--stack-region</code>
     * parameter and the AWS CLI common parameter <code>--region</code> are set to the same value, the stack uses a
     * <i>regional</i> endpoint. If the <code>--stack-region</code> parameter is not set, but the AWS CLI
     * <code>--region</code> parameter is, this also results in a stack with a <i>regional</i> endpoint. However, if the
     * <code>--region</code> parameter is set to <code>us-east-1</code>, and the <code>--stack-region</code> parameter
     * is set to one of the following, then the stack uses a legacy or <i>classic</i> region:
     * <code>us-west-1, us-west-2, sa-east-1, eu-central-1, eu-west-1, ap-northeast-1, ap-southeast-1, ap-southeast-2</code>
     * . In this case, the actual API endpoint of the stack is in <code>us-east-1</code>. Only the preceding regions are
     * supported as classic regions in the <code>us-east-1</code> API endpoint. Because it is a best practice to choose
     * the regional endpoint that is closest to where you manage AWS, we recommend that you use regional endpoints for
     * new stacks. The AWS CLI common <code>--region</code> parameter always specifies a regional API endpoint; it
     * cannot be used to specify a classic AWS OpsWorks Stacks region.
     * </p>
     * </note>
     * 
     * @return The stack's AWS region, such as <code>ap-south-1</code>. For more information about Amazon regions, see
     *         <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.</p> <note>
     *         <p>
     *         In the AWS CLI, this API maps to the <code>--stack-region</code> parameter. If the
     *         <code>--stack-region</code> parameter and the AWS CLI common parameter <code>--region</code> are set to
     *         the same value, the stack uses a <i>regional</i> endpoint. If the <code>--stack-region</code> parameter
     *         is not set, but the AWS CLI <code>--region</code> parameter is, this also results in a stack with a
     *         <i>regional</i> endpoint. However, if the <code>--region</code> parameter is set to
     *         <code>us-east-1</code>, and the <code>--stack-region</code> parameter is set to one of the following,
     *         then the stack uses a legacy or <i>classic</i> region:
     *         <code>us-west-1, us-west-2, sa-east-1, eu-central-1, eu-west-1, ap-northeast-1, ap-southeast-1, ap-southeast-2</code>
     *         . In this case, the actual API endpoint of the stack is in <code>us-east-1</code>. Only the preceding
     *         regions are supported as classic regions in the <code>us-east-1</code> API endpoint. Because it is a best
     *         practice to choose the regional endpoint that is closest to where you manage AWS, we recommend that you
     *         use regional endpoints for new stacks. The AWS CLI common <code>--region</code> parameter always
     *         specifies a regional API endpoint; it cannot be used to specify a classic AWS OpsWorks Stacks region.
     *         </p>
     */
    public String region() {
        return region;
    }

    /**
     * <p>
     * The ID of the VPC that the stack is to be launched into. The VPC must be in the stack's region. All instances are
     * launched into this VPC. You cannot change the ID later.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If your account supports EC2-Classic, the default value is <code>no VPC</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If your account does not support EC2-Classic, the default value is the default VPC for the specified region.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the VPC ID corresponds to a default VPC and you have specified either the <code>DefaultAvailabilityZone</code>
     * or the <code>DefaultSubnetId</code> parameter only, AWS OpsWorks Stacks infers the value of the other parameter.
     * If you specify neither parameter, AWS OpsWorks Stacks sets these parameters to the first valid Availability Zone
     * for the specified region and the corresponding default VPC subnet ID, respectively.
     * </p>
     * <p>
     * If you specify a nondefault VPC ID, note the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * It must belong to a VPC in your account that is in the specified region.
     * </p>
     * </li>
     * <li>
     * <p>
     * You must specify a value for <code>DefaultSubnetId</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about how to use AWS OpsWorks Stacks with a VPC, see <a
     * href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-vpc.html">Running a Stack in a VPC</a>.
     * For more information about default VPC and EC2-Classic, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html">Supported Platforms</a>.
     * </p>
     * 
     * @return The ID of the VPC that the stack is to be launched into. The VPC must be in the stack's region. All
     *         instances are launched into this VPC. You cannot change the ID later.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         If your account supports EC2-Classic, the default value is <code>no VPC</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If your account does not support EC2-Classic, the default value is the default VPC for the specified
     *         region.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If the VPC ID corresponds to a default VPC and you have specified either the
     *         <code>DefaultAvailabilityZone</code> or the <code>DefaultSubnetId</code> parameter only, AWS OpsWorks
     *         Stacks infers the value of the other parameter. If you specify neither parameter, AWS OpsWorks Stacks
     *         sets these parameters to the first valid Availability Zone for the specified region and the corresponding
     *         default VPC subnet ID, respectively.
     *         </p>
     *         <p>
     *         If you specify a nondefault VPC ID, note the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         It must belong to a VPC in your account that is in the specified region.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You must specify a value for <code>DefaultSubnetId</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information about how to use AWS OpsWorks Stacks with a VPC, see <a
     *         href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-vpc.html">Running a Stack in a
     *         VPC</a>. For more information about default VPC and EC2-Classic, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html">Supported
     *         Platforms</a>.
     */
    public String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * One or more user-defined key-value pairs to be added to the stack attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more user-defined key-value pairs to be added to the stack attributes.
     */
    public Map<StackAttributesKeys, String> attributes() {
        return StackAttributesCopier.copyStringToEnum(attributes);
    }

    /**
     * <p>
     * One or more user-defined key-value pairs to be added to the stack attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more user-defined key-value pairs to be added to the stack attributes.
     */
    public Map<String, String> attributesAsStrings() {
        return attributes;
    }

    /**
     * <p>
     * The stack's AWS Identity and Access Management (IAM) role, which allows AWS OpsWorks Stacks to work with AWS
     * resources on your behalf. You must set this parameter to the Amazon Resource Name (ARN) for an existing IAM role.
     * For more information about IAM ARNs, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.
     * </p>
     * 
     * @return The stack's AWS Identity and Access Management (IAM) role, which allows AWS OpsWorks Stacks to work with
     *         AWS resources on your behalf. You must set this parameter to the Amazon Resource Name (ARN) for an
     *         existing IAM role. For more information about IAM ARNs, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.
     */
    public String serviceRoleArn() {
        return serviceRoleArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM profile that is the default profile for all of the stack's EC2
     * instances. For more information about IAM ARNs, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM profile that is the default profile for all of the stack's EC2
     *         instances. For more information about IAM ARNs, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.
     */
    public String defaultInstanceProfileArn() {
        return defaultInstanceProfileArn;
    }

    /**
     * <p>
     * The stack's default operating system, which is installed on every instance unless you specify a different
     * operating system when you create the instance. You can specify one of the following.
     * </p>
     * <ul>
     * <li>
     * <p>
     * A supported Linux operating system: An Amazon Linux version, such as <code>Amazon Linux 2018.03</code>,
     * <code>Amazon Linux 2017.09</code>, <code>Amazon Linux 2017.03</code>, <code>Amazon Linux 2016.09</code>,
     * <code>Amazon Linux 2016.03</code>, <code>Amazon Linux 2015.09</code>, or <code>Amazon Linux 2015.03</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * A supported Ubuntu operating system, such as <code>Ubuntu 16.04 LTS</code>, <code>Ubuntu 14.04 LTS</code>, or
     * <code>Ubuntu 12.04 LTS</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CentOS Linux 7</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Red Hat Enterprise Linux 7</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * A supported Windows operating system, such as <code>Microsoft Windows Server 2012 R2 Base</code>,
     * <code>Microsoft Windows Server 2012 R2 with SQL Server Express</code>,
     * <code>Microsoft Windows Server 2012 R2 with SQL Server Standard</code>, or
     * <code>Microsoft Windows Server 2012 R2 with SQL Server Web</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * A custom AMI: <code>Custom</code>. You specify the custom AMI you want to use when you create instances. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html"> Using Custom
     * AMIs</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The default option is the current Amazon Linux version. For more information about supported operating systems,
     * see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">AWS OpsWorks Stacks
     * Operating Systems</a>.
     * </p>
     * 
     * @return The stack's default operating system, which is installed on every instance unless you specify a different
     *         operating system when you create the instance. You can specify one of the following.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         A supported Linux operating system: An Amazon Linux version, such as <code>Amazon Linux 2018.03</code>,
     *         <code>Amazon Linux 2017.09</code>, <code>Amazon Linux 2017.03</code>, <code>Amazon Linux 2016.09</code>,
     *         <code>Amazon Linux 2016.03</code>, <code>Amazon Linux 2015.09</code>, or
     *         <code>Amazon Linux 2015.03</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A supported Ubuntu operating system, such as <code>Ubuntu 16.04 LTS</code>, <code>Ubuntu 14.04 LTS</code>
     *         , or <code>Ubuntu 12.04 LTS</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CentOS Linux 7</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Red Hat Enterprise Linux 7</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A supported Windows operating system, such as <code>Microsoft Windows Server 2012 R2 Base</code>,
     *         <code>Microsoft Windows Server 2012 R2 with SQL Server Express</code>,
     *         <code>Microsoft Windows Server 2012 R2 with SQL Server Standard</code>, or
     *         <code>Microsoft Windows Server 2012 R2 with SQL Server Web</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A custom AMI: <code>Custom</code>. You specify the custom AMI you want to use when you create instances.
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html"> Using
     *         Custom AMIs</a>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The default option is the current Amazon Linux version. For more information about supported operating
     *         systems, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">AWS
     *         OpsWorks Stacks Operating Systems</a>.
     */
    public String defaultOs() {
        return defaultOs;
    }

    /**
     * <p>
     * The stack's host name theme, with spaces replaced by underscores. The theme is used to generate host names for
     * the stack's instances. By default, <code>HostnameTheme</code> is set to <code>Layer_Dependent</code>, which
     * creates host names by appending integers to the layer's short name. The other themes are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Baked_Goods</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Clouds</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Europe_Cities</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Fruits</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Greek_Deities_and_Titans</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Legendary_creatures_from_Japan</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Planets_and_Moons</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Roman_Deities</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Scottish_Islands</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>US_Cities</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Wild_Cats</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * To obtain a generated host name, call <code>GetHostNameSuggestion</code>, which returns a host name based on the
     * current theme.
     * </p>
     * 
     * @return The stack's host name theme, with spaces replaced by underscores. The theme is used to generate host
     *         names for the stack's instances. By default, <code>HostnameTheme</code> is set to
     *         <code>Layer_Dependent</code>, which creates host names by appending integers to the layer's short name.
     *         The other themes are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Baked_Goods</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Clouds</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Europe_Cities</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Fruits</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Greek_Deities_and_Titans</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Legendary_creatures_from_Japan</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Planets_and_Moons</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Roman_Deities</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Scottish_Islands</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>US_Cities</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Wild_Cats</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         To obtain a generated host name, call <code>GetHostNameSuggestion</code>, which returns a host name based
     *         on the current theme.
     */
    public String hostnameTheme() {
        return hostnameTheme;
    }

    /**
     * <p>
     * The stack's default Availability Zone, which must be in the specified region. For more information, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>. If you also specify a
     * value for <code>DefaultSubnetId</code>, the subnet must be in the same zone. For more information, see the
     * <code>VpcId</code> parameter description.
     * </p>
     * 
     * @return The stack's default Availability Zone, which must be in the specified region. For more information, see
     *         <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>. If you also
     *         specify a value for <code>DefaultSubnetId</code>, the subnet must be in the same zone. For more
     *         information, see the <code>VpcId</code> parameter description.
     */
    public String defaultAvailabilityZone() {
        return defaultAvailabilityZone;
    }

    /**
     * <p>
     * The stack's default VPC subnet ID. This parameter is required if you specify a value for the <code>VpcId</code>
     * parameter. All instances are launched into this subnet unless you specify otherwise when you create the instance.
     * If you also specify a value for <code>DefaultAvailabilityZone</code>, the subnet must be in that zone. For
     * information on default values and when this parameter is required, see the <code>VpcId</code> parameter
     * description.
     * </p>
     * 
     * @return The stack's default VPC subnet ID. This parameter is required if you specify a value for the
     *         <code>VpcId</code> parameter. All instances are launched into this subnet unless you specify otherwise
     *         when you create the instance. If you also specify a value for <code>DefaultAvailabilityZone</code>, the
     *         subnet must be in that zone. For information on default values and when this parameter is required, see
     *         the <code>VpcId</code> parameter description.
     */
    public String defaultSubnetId() {
        return defaultSubnetId;
    }

    /**
     * <p>
     * A string that contains user-defined, custom JSON. It can be used to override the corresponding default stack
     * configuration attribute values or to pass data to recipes. The string should be in the following format:
     * </p>
     * <p>
     * <code>"{\"key1\": \"value1\", \"key2\": \"value2\",...}"</code>
     * </p>
     * <p>
     * For more information about custom JSON, see <a
     * href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html">Use Custom JSON to Modify
     * the Stack Configuration Attributes</a>.
     * </p>
     * 
     * @return A string that contains user-defined, custom JSON. It can be used to override the corresponding default
     *         stack configuration attribute values or to pass data to recipes. The string should be in the following
     *         format:</p>
     *         <p>
     *         <code>"{\"key1\": \"value1\", \"key2\": \"value2\",...}"</code>
     *         </p>
     *         <p>
     *         For more information about custom JSON, see <a
     *         href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html">Use Custom JSON to
     *         Modify the Stack Configuration Attributes</a>.
     */
    public String customJson() {
        return customJson;
    }

    /**
     * <p>
     * The configuration manager. When you create a stack we recommend that you use the configuration manager to specify
     * the Chef version: 12, 11.10, or 11.4 for Linux stacks, or 12.2 for Windows stacks. The default value for Linux
     * stacks is currently 12.
     * </p>
     * 
     * @return The configuration manager. When you create a stack we recommend that you use the configuration manager to
     *         specify the Chef version: 12, 11.10, or 11.4 for Linux stacks, or 12.2 for Windows stacks. The default
     *         value for Linux stacks is currently 12.
     */
    public StackConfigurationManager configurationManager() {
        return configurationManager;
    }

    /**
     * <p>
     * A <code>ChefConfiguration</code> object that specifies whether to enable Berkshelf and the Berkshelf version on
     * Chef 11.10 stacks. For more information, see <a
     * href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New Stack</a>.
     * </p>
     * 
     * @return A <code>ChefConfiguration</code> object that specifies whether to enable Berkshelf and the Berkshelf
     *         version on Chef 11.10 stacks. For more information, see <a
     *         href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New
     *         Stack</a>.
     */
    public ChefConfiguration chefConfiguration() {
        return chefConfiguration;
    }

    /**
     * <p>
     * Whether the stack uses custom cookbooks.
     * </p>
     * 
     * @return Whether the stack uses custom cookbooks.
     */
    public Boolean useCustomCookbooks() {
        return useCustomCookbooks;
    }

    /**
     * <p>
     * Whether to associate the AWS OpsWorks Stacks built-in security groups with the stack's layers.
     * </p>
     * <p>
     * AWS OpsWorks Stacks provides a standard set of built-in security groups, one for each layer, which are associated
     * with layers by default. With <code>UseOpsworksSecurityGroups</code> you can instead provide your own custom
     * security groups. <code>UseOpsworksSecurityGroups</code> has the following settings:
     * </p>
     * <ul>
     * <li>
     * <p>
     * True - AWS OpsWorks Stacks automatically associates the appropriate built-in security group with each layer
     * (default setting). You can associate additional security groups with a layer after you create it, but you cannot
     * delete the built-in security group.
     * </p>
     * </li>
     * <li>
     * <p>
     * False - AWS OpsWorks Stacks does not associate built-in security groups with layers. You must create appropriate
     * EC2 security groups and associate a security group with each layer that you create. However, you can still
     * manually associate a built-in security group with a layer on creation; custom security groups are required only
     * for those layers that need custom settings.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New Stack</a>.
     * </p>
     * 
     * @return Whether to associate the AWS OpsWorks Stacks built-in security groups with the stack's layers.</p>
     *         <p>
     *         AWS OpsWorks Stacks provides a standard set of built-in security groups, one for each layer, which are
     *         associated with layers by default. With <code>UseOpsworksSecurityGroups</code> you can instead provide
     *         your own custom security groups. <code>UseOpsworksSecurityGroups</code> has the following settings:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         True - AWS OpsWorks Stacks automatically associates the appropriate built-in security group with each
     *         layer (default setting). You can associate additional security groups with a layer after you create it,
     *         but you cannot delete the built-in security group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         False - AWS OpsWorks Stacks does not associate built-in security groups with layers. You must create
     *         appropriate EC2 security groups and associate a security group with each layer that you create. However,
     *         you can still manually associate a built-in security group with a layer on creation; custom security
     *         groups are required only for those layers that need custom settings.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New
     *         Stack</a>.
     */
    public Boolean useOpsworksSecurityGroups() {
        return useOpsworksSecurityGroups;
    }

    /**
     * <p>
     * Contains the information required to retrieve an app or cookbook from a repository. For more information, see <a
     * href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html">Adding Apps</a> or <a
     * href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook.html">Cookbooks and Recipes</a>.
     * </p>
     * 
     * @return Contains the information required to retrieve an app or cookbook from a repository. For more information,
     *         see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html">Adding
     *         Apps</a> or <a
     *         href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook.html">Cookbooks and
     *         Recipes</a>.
     */
    public Source customCookbooksSource() {
        return customCookbooksSource;
    }

    /**
     * <p>
     * A default Amazon EC2 key pair name. The default value is none. If you specify a key pair name, AWS OpsWorks
     * installs the public key on the instance and you can use the private key with an SSH client to log in to the
     * instance. For more information, see <a
     * href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-ssh.html"> Using SSH to Communicate
     * with an Instance</a> and <a
     * href="https://docs.aws.amazon.com/opsworks/latest/userguide/security-ssh-access.html"> Managing SSH Access</a>.
     * You can override this setting by specifying a different key pair, or no key pair, when you <a
     * href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-add.html"> create an instance</a>.
     * </p>
     * 
     * @return A default Amazon EC2 key pair name. The default value is none. If you specify a key pair name, AWS
     *         OpsWorks installs the public key on the instance and you can use the private key with an SSH client to
     *         log in to the instance. For more information, see <a
     *         href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-ssh.html"> Using SSH to
     *         Communicate with an Instance</a> and <a
     *         href="https://docs.aws.amazon.com/opsworks/latest/userguide/security-ssh-access.html"> Managing SSH
     *         Access</a>. You can override this setting by specifying a different key pair, or no key pair, when you <a
     *         href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-add.html"> create an
     *         instance</a>.
     */
    public String defaultSshKeyName() {
        return defaultSshKeyName;
    }

    /**
     * <p>
     * The default root device type. This value is the default for all instances in the stack, but you can override it
     * when you create an instance. The default option is <code>instance-store</code>. For more information, see <a
     * href=
     * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device">Storage for
     * the Root Device</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #defaultRootDeviceType} will return {@link RootDeviceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #defaultRootDeviceTypeAsString}.
     * </p>
     * 
     * @return The default root device type. This value is the default for all instances in the stack, but you can
     *         override it when you create an instance. The default option is <code>instance-store</code>. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device"
     *         >Storage for the Root Device</a>.
     * @see RootDeviceType
     */
    public RootDeviceType defaultRootDeviceType() {
        return RootDeviceType.fromValue(defaultRootDeviceType);
    }

    /**
     * <p>
     * The default root device type. This value is the default for all instances in the stack, but you can override it
     * when you create an instance. The default option is <code>instance-store</code>. For more information, see <a
     * href=
     * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device">Storage for
     * the Root Device</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #defaultRootDeviceType} will return {@link RootDeviceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #defaultRootDeviceTypeAsString}.
     * </p>
     * 
     * @return The default root device type. This value is the default for all instances in the stack, but you can
     *         override it when you create an instance. The default option is <code>instance-store</code>. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device"
     *         >Storage for the Root Device</a>.
     * @see RootDeviceType
     */
    public String defaultRootDeviceTypeAsString() {
        return defaultRootDeviceType;
    }

    /**
     * <p>
     * The default AWS OpsWorks Stacks agent version. You have the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Auto-update - Set this parameter to <code>LATEST</code>. AWS OpsWorks Stacks automatically installs new agent
     * versions on the stack's instances as soon as they are available.
     * </p>
     * </li>
     * <li>
     * <p>
     * Fixed version - Set this parameter to your preferred agent version. To update the agent version, you must edit
     * the stack configuration and specify a new version. AWS OpsWorks Stacks then automatically installs that version
     * on the stack's instances.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The default setting is the most recent release of the agent. To specify an agent version, you must use the
     * complete version number, not the abbreviated number shown on the console. For a list of available agent version
     * numbers, call <a>DescribeAgentVersions</a>. AgentVersion cannot be set to Chef 12.2.
     * </p>
     * <note>
     * <p>
     * You can also specify an agent version when you create or update an instance, which overrides the stack's default
     * setting.
     * </p>
     * </note>
     * 
     * @return The default AWS OpsWorks Stacks agent version. You have the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Auto-update - Set this parameter to <code>LATEST</code>. AWS OpsWorks Stacks automatically installs new
     *         agent versions on the stack's instances as soon as they are available.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Fixed version - Set this parameter to your preferred agent version. To update the agent version, you must
     *         edit the stack configuration and specify a new version. AWS OpsWorks Stacks then automatically installs
     *         that version on the stack's instances.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The default setting is the most recent release of the agent. To specify an agent version, you must use
     *         the complete version number, not the abbreviated number shown on the console. For a list of available
     *         agent version numbers, call <a>DescribeAgentVersions</a>. AgentVersion cannot be set to Chef 12.2.
     *         </p>
     *         <note>
     *         <p>
     *         You can also specify an agent version when you create or update an instance, which overrides the stack's
     *         default setting.
     *         </p>
     */
    public String agentVersion() {
        return agentVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(attributesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(serviceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(defaultInstanceProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(defaultOs());
        hashCode = 31 * hashCode + Objects.hashCode(hostnameTheme());
        hashCode = 31 * hashCode + Objects.hashCode(defaultAvailabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(defaultSubnetId());
        hashCode = 31 * hashCode + Objects.hashCode(customJson());
        hashCode = 31 * hashCode + Objects.hashCode(configurationManager());
        hashCode = 31 * hashCode + Objects.hashCode(chefConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(useCustomCookbooks());
        hashCode = 31 * hashCode + Objects.hashCode(useOpsworksSecurityGroups());
        hashCode = 31 * hashCode + Objects.hashCode(customCookbooksSource());
        hashCode = 31 * hashCode + Objects.hashCode(defaultSshKeyName());
        hashCode = 31 * hashCode + Objects.hashCode(defaultRootDeviceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(agentVersion());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStackRequest)) {
            return false;
        }
        CreateStackRequest other = (CreateStackRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(region(), other.region())
                && Objects.equals(vpcId(), other.vpcId()) && Objects.equals(attributesAsStrings(), other.attributesAsStrings())
                && Objects.equals(serviceRoleArn(), other.serviceRoleArn())
                && Objects.equals(defaultInstanceProfileArn(), other.defaultInstanceProfileArn())
                && Objects.equals(defaultOs(), other.defaultOs()) && Objects.equals(hostnameTheme(), other.hostnameTheme())
                && Objects.equals(defaultAvailabilityZone(), other.defaultAvailabilityZone())
                && Objects.equals(defaultSubnetId(), other.defaultSubnetId()) && Objects.equals(customJson(), other.customJson())
                && Objects.equals(configurationManager(), other.configurationManager())
                && Objects.equals(chefConfiguration(), other.chefConfiguration())
                && Objects.equals(useCustomCookbooks(), other.useCustomCookbooks())
                && Objects.equals(useOpsworksSecurityGroups(), other.useOpsworksSecurityGroups())
                && Objects.equals(customCookbooksSource(), other.customCookbooksSource())
                && Objects.equals(defaultSshKeyName(), other.defaultSshKeyName())
                && Objects.equals(defaultRootDeviceTypeAsString(), other.defaultRootDeviceTypeAsString())
                && Objects.equals(agentVersion(), other.agentVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateStackRequest").add("Name", name()).add("Region", region()).add("VpcId", vpcId())
                .add("Attributes", attributesAsStrings()).add("ServiceRoleArn", serviceRoleArn())
                .add("DefaultInstanceProfileArn", defaultInstanceProfileArn()).add("DefaultOs", defaultOs())
                .add("HostnameTheme", hostnameTheme()).add("DefaultAvailabilityZone", defaultAvailabilityZone())
                .add("DefaultSubnetId", defaultSubnetId()).add("CustomJson", customJson())
                .add("ConfigurationManager", configurationManager()).add("ChefConfiguration", chefConfiguration())
                .add("UseCustomCookbooks", useCustomCookbooks()).add("UseOpsworksSecurityGroups", useOpsworksSecurityGroups())
                .add("CustomCookbooksSource", customCookbooksSource()).add("DefaultSshKeyName", defaultSshKeyName())
                .add("DefaultRootDeviceType", defaultRootDeviceTypeAsString()).add("AgentVersion", agentVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Region":
            return Optional.ofNullable(clazz.cast(region()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributesAsStrings()));
        case "ServiceRoleArn":
            return Optional.ofNullable(clazz.cast(serviceRoleArn()));
        case "DefaultInstanceProfileArn":
            return Optional.ofNullable(clazz.cast(defaultInstanceProfileArn()));
        case "DefaultOs":
            return Optional.ofNullable(clazz.cast(defaultOs()));
        case "HostnameTheme":
            return Optional.ofNullable(clazz.cast(hostnameTheme()));
        case "DefaultAvailabilityZone":
            return Optional.ofNullable(clazz.cast(defaultAvailabilityZone()));
        case "DefaultSubnetId":
            return Optional.ofNullable(clazz.cast(defaultSubnetId()));
        case "CustomJson":
            return Optional.ofNullable(clazz.cast(customJson()));
        case "ConfigurationManager":
            return Optional.ofNullable(clazz.cast(configurationManager()));
        case "ChefConfiguration":
            return Optional.ofNullable(clazz.cast(chefConfiguration()));
        case "UseCustomCookbooks":
            return Optional.ofNullable(clazz.cast(useCustomCookbooks()));
        case "UseOpsworksSecurityGroups":
            return Optional.ofNullable(clazz.cast(useOpsworksSecurityGroups()));
        case "CustomCookbooksSource":
            return Optional.ofNullable(clazz.cast(customCookbooksSource()));
        case "DefaultSshKeyName":
            return Optional.ofNullable(clazz.cast(defaultSshKeyName()));
        case "DefaultRootDeviceType":
            return Optional.ofNullable(clazz.cast(defaultRootDeviceTypeAsString()));
        case "AgentVersion":
            return Optional.ofNullable(clazz.cast(agentVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateStackRequest, T> g) {
        return obj -> g.apply((CreateStackRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpsWorksRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateStackRequest> {
        /**
         * <p>
         * The stack name.
         * </p>
         * 
         * @param name
         *        The stack name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The stack's AWS region, such as <code>ap-south-1</code>. For more information about Amazon regions, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.
         * </p>
         * <note>
         * <p>
         * In the AWS CLI, this API maps to the <code>--stack-region</code> parameter. If the
         * <code>--stack-region</code> parameter and the AWS CLI common parameter <code>--region</code> are set to the
         * same value, the stack uses a <i>regional</i> endpoint. If the <code>--stack-region</code> parameter is not
         * set, but the AWS CLI <code>--region</code> parameter is, this also results in a stack with a <i>regional</i>
         * endpoint. However, if the <code>--region</code> parameter is set to <code>us-east-1</code>, and the
         * <code>--stack-region</code> parameter is set to one of the following, then the stack uses a legacy or
         * <i>classic</i> region:
         * <code>us-west-1, us-west-2, sa-east-1, eu-central-1, eu-west-1, ap-northeast-1, ap-southeast-1, ap-southeast-2</code>
         * . In this case, the actual API endpoint of the stack is in <code>us-east-1</code>. Only the preceding regions
         * are supported as classic regions in the <code>us-east-1</code> API endpoint. Because it is a best practice to
         * choose the regional endpoint that is closest to where you manage AWS, we recommend that you use regional
         * endpoints for new stacks. The AWS CLI common <code>--region</code> parameter always specifies a regional API
         * endpoint; it cannot be used to specify a classic AWS OpsWorks Stacks region.
         * </p>
         * </note>
         * 
         * @param region
         *        The stack's AWS region, such as <code>ap-south-1</code>. For more information about Amazon regions,
         *        see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.</p>
         *        <note>
         *        <p>
         *        In the AWS CLI, this API maps to the <code>--stack-region</code> parameter. If the
         *        <code>--stack-region</code> parameter and the AWS CLI common parameter <code>--region</code> are set
         *        to the same value, the stack uses a <i>regional</i> endpoint. If the <code>--stack-region</code>
         *        parameter is not set, but the AWS CLI <code>--region</code> parameter is, this also results in a stack
         *        with a <i>regional</i> endpoint. However, if the <code>--region</code> parameter is set to
         *        <code>us-east-1</code>, and the <code>--stack-region</code> parameter is set to one of the following,
         *        then the stack uses a legacy or <i>classic</i> region:
         *        <code>us-west-1, us-west-2, sa-east-1, eu-central-1, eu-west-1, ap-northeast-1, ap-southeast-1, ap-southeast-2</code>
         *        . In this case, the actual API endpoint of the stack is in <code>us-east-1</code>. Only the preceding
         *        regions are supported as classic regions in the <code>us-east-1</code> API endpoint. Because it is a
         *        best practice to choose the regional endpoint that is closest to where you manage AWS, we recommend
         *        that you use regional endpoints for new stacks. The AWS CLI common <code>--region</code> parameter
         *        always specifies a regional API endpoint; it cannot be used to specify a classic AWS OpsWorks Stacks
         *        region.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The ID of the VPC that the stack is to be launched into. The VPC must be in the stack's region. All instances
         * are launched into this VPC. You cannot change the ID later.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If your account supports EC2-Classic, the default value is <code>no VPC</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * If your account does not support EC2-Classic, the default value is the default VPC for the specified region.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If the VPC ID corresponds to a default VPC and you have specified either the
         * <code>DefaultAvailabilityZone</code> or the <code>DefaultSubnetId</code> parameter only, AWS OpsWorks Stacks
         * infers the value of the other parameter. If you specify neither parameter, AWS OpsWorks Stacks sets these
         * parameters to the first valid Availability Zone for the specified region and the corresponding default VPC
         * subnet ID, respectively.
         * </p>
         * <p>
         * If you specify a nondefault VPC ID, note the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * It must belong to a VPC in your account that is in the specified region.
         * </p>
         * </li>
         * <li>
         * <p>
         * You must specify a value for <code>DefaultSubnetId</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information about how to use AWS OpsWorks Stacks with a VPC, see <a
         * href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-vpc.html">Running a Stack in a
         * VPC</a>. For more information about default VPC and EC2-Classic, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html">Supported
         * Platforms</a>.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC that the stack is to be launched into. The VPC must be in the stack's region. All
         *        instances are launched into this VPC. You cannot change the ID later.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        If your account supports EC2-Classic, the default value is <code>no VPC</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If your account does not support EC2-Classic, the default value is the default VPC for the specified
         *        region.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If the VPC ID corresponds to a default VPC and you have specified either the
         *        <code>DefaultAvailabilityZone</code> or the <code>DefaultSubnetId</code> parameter only, AWS OpsWorks
         *        Stacks infers the value of the other parameter. If you specify neither parameter, AWS OpsWorks Stacks
         *        sets these parameters to the first valid Availability Zone for the specified region and the
         *        corresponding default VPC subnet ID, respectively.
         *        </p>
         *        <p>
         *        If you specify a nondefault VPC ID, note the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        It must belong to a VPC in your account that is in the specified region.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        You must specify a value for <code>DefaultSubnetId</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information about how to use AWS OpsWorks Stacks with a VPC, see <a
         *        href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-vpc.html">Running a Stack in
         *        a VPC</a>. For more information about default VPC and EC2-Classic, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html">Supported
         *        Platforms</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * One or more user-defined key-value pairs to be added to the stack attributes.
         * </p>
         * 
         * @param attributes
         *        One or more user-defined key-value pairs to be added to the stack attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributesWithStrings(Map<String, String> attributes);

        /**
         * <p>
         * One or more user-defined key-value pairs to be added to the stack attributes.
         * </p>
         * 
         * @param attributes
         *        One or more user-defined key-value pairs to be added to the stack attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<StackAttributesKeys, String> attributes);

        /**
         * <p>
         * The stack's AWS Identity and Access Management (IAM) role, which allows AWS OpsWorks Stacks to work with AWS
         * resources on your behalf. You must set this parameter to the Amazon Resource Name (ARN) for an existing IAM
         * role. For more information about IAM ARNs, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.
         * </p>
         * 
         * @param serviceRoleArn
         *        The stack's AWS Identity and Access Management (IAM) role, which allows AWS OpsWorks Stacks to work
         *        with AWS resources on your behalf. You must set this parameter to the Amazon Resource Name (ARN) for
         *        an existing IAM role. For more information about IAM ARNs, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRoleArn(String serviceRoleArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM profile that is the default profile for all of the stack's EC2
         * instances. For more information about IAM ARNs, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.
         * </p>
         * 
         * @param defaultInstanceProfileArn
         *        The Amazon Resource Name (ARN) of an IAM profile that is the default profile for all of the stack's
         *        EC2 instances. For more information about IAM ARNs, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultInstanceProfileArn(String defaultInstanceProfileArn);

        /**
         * <p>
         * The stack's default operating system, which is installed on every instance unless you specify a different
         * operating system when you create the instance. You can specify one of the following.
         * </p>
         * <ul>
         * <li>
         * <p>
         * A supported Linux operating system: An Amazon Linux version, such as <code>Amazon Linux 2018.03</code>,
         * <code>Amazon Linux 2017.09</code>, <code>Amazon Linux 2017.03</code>, <code>Amazon Linux 2016.09</code>,
         * <code>Amazon Linux 2016.03</code>, <code>Amazon Linux 2015.09</code>, or <code>Amazon Linux 2015.03</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * A supported Ubuntu operating system, such as <code>Ubuntu 16.04 LTS</code>, <code>Ubuntu 14.04 LTS</code>, or
         * <code>Ubuntu 12.04 LTS</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CentOS Linux 7</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Red Hat Enterprise Linux 7</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * A supported Windows operating system, such as <code>Microsoft Windows Server 2012 R2 Base</code>,
         * <code>Microsoft Windows Server 2012 R2 with SQL Server Express</code>,
         * <code>Microsoft Windows Server 2012 R2 with SQL Server Standard</code>, or
         * <code>Microsoft Windows Server 2012 R2 with SQL Server Web</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * A custom AMI: <code>Custom</code>. You specify the custom AMI you want to use when you create instances. For
         * more information, see <a
         * href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html"> Using Custom
         * AMIs</a>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The default option is the current Amazon Linux version. For more information about supported operating
         * systems, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">AWS
         * OpsWorks Stacks Operating Systems</a>.
         * </p>
         * 
         * @param defaultOs
         *        The stack's default operating system, which is installed on every instance unless you specify a
         *        different operating system when you create the instance. You can specify one of the following.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        A supported Linux operating system: An Amazon Linux version, such as <code>Amazon Linux 2018.03</code>, <code>Amazon Linux 2017.09</code>, <code>Amazon Linux 2017.03</code>,
         *        <code>Amazon Linux 2016.09</code>, <code>Amazon Linux 2016.03</code>,
         *        <code>Amazon Linux 2015.09</code>, or <code>Amazon Linux 2015.03</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A supported Ubuntu operating system, such as <code>Ubuntu 16.04 LTS</code>,
         *        <code>Ubuntu 14.04 LTS</code>, or <code>Ubuntu 12.04 LTS</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CentOS Linux 7</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Red Hat Enterprise Linux 7</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A supported Windows operating system, such as <code>Microsoft Windows Server 2012 R2 Base</code>,
         *        <code>Microsoft Windows Server 2012 R2 with SQL Server Express</code>,
         *        <code>Microsoft Windows Server 2012 R2 with SQL Server Standard</code>, or
         *        <code>Microsoft Windows Server 2012 R2 with SQL Server Web</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A custom AMI: <code>Custom</code>. You specify the custom AMI you want to use when you create
         *        instances. For more information, see <a
         *        href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html"> Using
         *        Custom AMIs</a>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The default option is the current Amazon Linux version. For more information about supported operating
         *        systems, see <a
         *        href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">AWS OpsWorks
         *        Stacks Operating Systems</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultOs(String defaultOs);

        /**
         * <p>
         * The stack's host name theme, with spaces replaced by underscores. The theme is used to generate host names
         * for the stack's instances. By default, <code>HostnameTheme</code> is set to <code>Layer_Dependent</code>,
         * which creates host names by appending integers to the layer's short name. The other themes are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Baked_Goods</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Clouds</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Europe_Cities</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Fruits</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Greek_Deities_and_Titans</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Legendary_creatures_from_Japan</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Planets_and_Moons</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Roman_Deities</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Scottish_Islands</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>US_Cities</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Wild_Cats</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * To obtain a generated host name, call <code>GetHostNameSuggestion</code>, which returns a host name based on
         * the current theme.
         * </p>
         * 
         * @param hostnameTheme
         *        The stack's host name theme, with spaces replaced by underscores. The theme is used to generate host
         *        names for the stack's instances. By default, <code>HostnameTheme</code> is set to
         *        <code>Layer_Dependent</code>, which creates host names by appending integers to the layer's short
         *        name. The other themes are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Baked_Goods</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Clouds</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Europe_Cities</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Fruits</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Greek_Deities_and_Titans</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Legendary_creatures_from_Japan</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Planets_and_Moons</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Roman_Deities</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Scottish_Islands</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>US_Cities</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Wild_Cats</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        To obtain a generated host name, call <code>GetHostNameSuggestion</code>, which returns a host name
         *        based on the current theme.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostnameTheme(String hostnameTheme);

        /**
         * <p>
         * The stack's default Availability Zone, which must be in the specified region. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>. If you also
         * specify a value for <code>DefaultSubnetId</code>, the subnet must be in the same zone. For more information,
         * see the <code>VpcId</code> parameter description.
         * </p>
         * 
         * @param defaultAvailabilityZone
         *        The stack's default Availability Zone, which must be in the specified region. For more information,
         *        see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>. If
         *        you also specify a value for <code>DefaultSubnetId</code>, the subnet must be in the same zone. For
         *        more information, see the <code>VpcId</code> parameter description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultAvailabilityZone(String defaultAvailabilityZone);

        /**
         * <p>
         * The stack's default VPC subnet ID. This parameter is required if you specify a value for the
         * <code>VpcId</code> parameter. All instances are launched into this subnet unless you specify otherwise when
         * you create the instance. If you also specify a value for <code>DefaultAvailabilityZone</code>, the subnet
         * must be in that zone. For information on default values and when this parameter is required, see the
         * <code>VpcId</code> parameter description.
         * </p>
         * 
         * @param defaultSubnetId
         *        The stack's default VPC subnet ID. This parameter is required if you specify a value for the
         *        <code>VpcId</code> parameter. All instances are launched into this subnet unless you specify otherwise
         *        when you create the instance. If you also specify a value for <code>DefaultAvailabilityZone</code>,
         *        the subnet must be in that zone. For information on default values and when this parameter is
         *        required, see the <code>VpcId</code> parameter description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultSubnetId(String defaultSubnetId);

        /**
         * <p>
         * A string that contains user-defined, custom JSON. It can be used to override the corresponding default stack
         * configuration attribute values or to pass data to recipes. The string should be in the following format:
         * </p>
         * <p>
         * <code>"{\"key1\": \"value1\", \"key2\": \"value2\",...}"</code>
         * </p>
         * <p>
         * For more information about custom JSON, see <a
         * href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html">Use Custom JSON to
         * Modify the Stack Configuration Attributes</a>.
         * </p>
         * 
         * @param customJson
         *        A string that contains user-defined, custom JSON. It can be used to override the corresponding default
         *        stack configuration attribute values or to pass data to recipes. The string should be in the following
         *        format:</p>
         *        <p>
         *        <code>"{\"key1\": \"value1\", \"key2\": \"value2\",...}"</code>
         *        </p>
         *        <p>
         *        For more information about custom JSON, see <a
         *        href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html">Use Custom JSON
         *        to Modify the Stack Configuration Attributes</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customJson(String customJson);

        /**
         * <p>
         * The configuration manager. When you create a stack we recommend that you use the configuration manager to
         * specify the Chef version: 12, 11.10, or 11.4 for Linux stacks, or 12.2 for Windows stacks. The default value
         * for Linux stacks is currently 12.
         * </p>
         * 
         * @param configurationManager
         *        The configuration manager. When you create a stack we recommend that you use the configuration manager
         *        to specify the Chef version: 12, 11.10, or 11.4 for Linux stacks, or 12.2 for Windows stacks. The
         *        default value for Linux stacks is currently 12.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationManager(StackConfigurationManager configurationManager);

        /**
         * <p>
         * The configuration manager. When you create a stack we recommend that you use the configuration manager to
         * specify the Chef version: 12, 11.10, or 11.4 for Linux stacks, or 12.2 for Windows stacks. The default value
         * for Linux stacks is currently 12.
         * </p>
         * This is a convenience that creates an instance of the {@link StackConfigurationManager.Builder} avoiding the
         * need to create one manually via {@link StackConfigurationManager#builder()}.
         *
         * When the {@link Consumer} completes, {@link StackConfigurationManager.Builder#build()} is called immediately
         * and its result is passed to {@link #configurationManager(StackConfigurationManager)}.
         * 
         * @param configurationManager
         *        a consumer that will call methods on {@link StackConfigurationManager.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configurationManager(StackConfigurationManager)
         */
        default Builder configurationManager(Consumer<StackConfigurationManager.Builder> configurationManager) {
            return configurationManager(StackConfigurationManager.builder().applyMutation(configurationManager).build());
        }

        /**
         * <p>
         * A <code>ChefConfiguration</code> object that specifies whether to enable Berkshelf and the Berkshelf version
         * on Chef 11.10 stacks. For more information, see <a
         * href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New
         * Stack</a>.
         * </p>
         * 
         * @param chefConfiguration
         *        A <code>ChefConfiguration</code> object that specifies whether to enable Berkshelf and the Berkshelf
         *        version on Chef 11.10 stacks. For more information, see <a
         *        href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New
         *        Stack</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chefConfiguration(ChefConfiguration chefConfiguration);

        /**
         * <p>
         * A <code>ChefConfiguration</code> object that specifies whether to enable Berkshelf and the Berkshelf version
         * on Chef 11.10 stacks. For more information, see <a
         * href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New
         * Stack</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link ChefConfiguration.Builder} avoiding the need to
         * create one manually via {@link ChefConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ChefConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #chefConfiguration(ChefConfiguration)}.
         * 
         * @param chefConfiguration
         *        a consumer that will call methods on {@link ChefConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #chefConfiguration(ChefConfiguration)
         */
        default Builder chefConfiguration(Consumer<ChefConfiguration.Builder> chefConfiguration) {
            return chefConfiguration(ChefConfiguration.builder().applyMutation(chefConfiguration).build());
        }

        /**
         * <p>
         * Whether the stack uses custom cookbooks.
         * </p>
         * 
         * @param useCustomCookbooks
         *        Whether the stack uses custom cookbooks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useCustomCookbooks(Boolean useCustomCookbooks);

        /**
         * <p>
         * Whether to associate the AWS OpsWorks Stacks built-in security groups with the stack's layers.
         * </p>
         * <p>
         * AWS OpsWorks Stacks provides a standard set of built-in security groups, one for each layer, which are
         * associated with layers by default. With <code>UseOpsworksSecurityGroups</code> you can instead provide your
         * own custom security groups. <code>UseOpsworksSecurityGroups</code> has the following settings:
         * </p>
         * <ul>
         * <li>
         * <p>
         * True - AWS OpsWorks Stacks automatically associates the appropriate built-in security group with each layer
         * (default setting). You can associate additional security groups with a layer after you create it, but you
         * cannot delete the built-in security group.
         * </p>
         * </li>
         * <li>
         * <p>
         * False - AWS OpsWorks Stacks does not associate built-in security groups with layers. You must create
         * appropriate EC2 security groups and associate a security group with each layer that you create. However, you
         * can still manually associate a built-in security group with a layer on creation; custom security groups are
         * required only for those layers that need custom settings.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New
         * Stack</a>.
         * </p>
         * 
         * @param useOpsworksSecurityGroups
         *        Whether to associate the AWS OpsWorks Stacks built-in security groups with the stack's layers.</p>
         *        <p>
         *        AWS OpsWorks Stacks provides a standard set of built-in security groups, one for each layer, which are
         *        associated with layers by default. With <code>UseOpsworksSecurityGroups</code> you can instead provide
         *        your own custom security groups. <code>UseOpsworksSecurityGroups</code> has the following settings:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        True - AWS OpsWorks Stacks automatically associates the appropriate built-in security group with each
         *        layer (default setting). You can associate additional security groups with a layer after you create
         *        it, but you cannot delete the built-in security group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        False - AWS OpsWorks Stacks does not associate built-in security groups with layers. You must create
         *        appropriate EC2 security groups and associate a security group with each layer that you create.
         *        However, you can still manually associate a built-in security group with a layer on creation; custom
         *        security groups are required only for those layers that need custom settings.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New
         *        Stack</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useOpsworksSecurityGroups(Boolean useOpsworksSecurityGroups);

        /**
         * <p>
         * Contains the information required to retrieve an app or cookbook from a repository. For more information, see
         * <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html">Adding Apps</a> or
         * <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook.html">Cookbooks and
         * Recipes</a>.
         * </p>
         * 
         * @param customCookbooksSource
         *        Contains the information required to retrieve an app or cookbook from a repository. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html">Adding Apps</a>
         *        or <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook.html">Cookbooks and
         *        Recipes</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customCookbooksSource(Source customCookbooksSource);

        /**
         * <p>
         * Contains the information required to retrieve an app or cookbook from a repository. For more information, see
         * <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html">Adding Apps</a> or
         * <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook.html">Cookbooks and
         * Recipes</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link Source.Builder} avoiding the need to create one
         * manually via {@link Source#builder()}.
         *
         * When the {@link Consumer} completes, {@link Source.Builder#build()} is called immediately and its result is
         * passed to {@link #customCookbooksSource(Source)}.
         * 
         * @param customCookbooksSource
         *        a consumer that will call methods on {@link Source.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customCookbooksSource(Source)
         */
        default Builder customCookbooksSource(Consumer<Source.Builder> customCookbooksSource) {
            return customCookbooksSource(Source.builder().applyMutation(customCookbooksSource).build());
        }

        /**
         * <p>
         * A default Amazon EC2 key pair name. The default value is none. If you specify a key pair name, AWS OpsWorks
         * installs the public key on the instance and you can use the private key with an SSH client to log in to the
         * instance. For more information, see <a
         * href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-ssh.html"> Using SSH to
         * Communicate with an Instance</a> and <a
         * href="https://docs.aws.amazon.com/opsworks/latest/userguide/security-ssh-access.html"> Managing SSH
         * Access</a>. You can override this setting by specifying a different key pair, or no key pair, when you <a
         * href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-add.html"> create an
         * instance</a>.
         * </p>
         * 
         * @param defaultSshKeyName
         *        A default Amazon EC2 key pair name. The default value is none. If you specify a key pair name, AWS
         *        OpsWorks installs the public key on the instance and you can use the private key with an SSH client to
         *        log in to the instance. For more information, see <a
         *        href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-ssh.html"> Using SSH to
         *        Communicate with an Instance</a> and <a
         *        href="https://docs.aws.amazon.com/opsworks/latest/userguide/security-ssh-access.html"> Managing SSH
         *        Access</a>. You can override this setting by specifying a different key pair, or no key pair, when you
         *        <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-add.html"> create an
         *        instance</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultSshKeyName(String defaultSshKeyName);

        /**
         * <p>
         * The default root device type. This value is the default for all instances in the stack, but you can override
         * it when you create an instance. The default option is <code>instance-store</code>. For more information, see
         * <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device">
         * Storage for the Root Device</a>.
         * </p>
         * 
         * @param defaultRootDeviceType
         *        The default root device type. This value is the default for all instances in the stack, but you can
         *        override it when you create an instance. The default option is <code>instance-store</code>. For more
         *        information, see <a href=
         *        "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device"
         *        >Storage for the Root Device</a>.
         * @see RootDeviceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RootDeviceType
         */
        Builder defaultRootDeviceType(String defaultRootDeviceType);

        /**
         * <p>
         * The default root device type. This value is the default for all instances in the stack, but you can override
         * it when you create an instance. The default option is <code>instance-store</code>. For more information, see
         * <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device">
         * Storage for the Root Device</a>.
         * </p>
         * 
         * @param defaultRootDeviceType
         *        The default root device type. This value is the default for all instances in the stack, but you can
         *        override it when you create an instance. The default option is <code>instance-store</code>. For more
         *        information, see <a href=
         *        "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device"
         *        >Storage for the Root Device</a>.
         * @see RootDeviceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RootDeviceType
         */
        Builder defaultRootDeviceType(RootDeviceType defaultRootDeviceType);

        /**
         * <p>
         * The default AWS OpsWorks Stacks agent version. You have the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Auto-update - Set this parameter to <code>LATEST</code>. AWS OpsWorks Stacks automatically installs new agent
         * versions on the stack's instances as soon as they are available.
         * </p>
         * </li>
         * <li>
         * <p>
         * Fixed version - Set this parameter to your preferred agent version. To update the agent version, you must
         * edit the stack configuration and specify a new version. AWS OpsWorks Stacks then automatically installs that
         * version on the stack's instances.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The default setting is the most recent release of the agent. To specify an agent version, you must use the
         * complete version number, not the abbreviated number shown on the console. For a list of available agent
         * version numbers, call <a>DescribeAgentVersions</a>. AgentVersion cannot be set to Chef 12.2.
         * </p>
         * <note>
         * <p>
         * You can also specify an agent version when you create or update an instance, which overrides the stack's
         * default setting.
         * </p>
         * </note>
         * 
         * @param agentVersion
         *        The default AWS OpsWorks Stacks agent version. You have the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Auto-update - Set this parameter to <code>LATEST</code>. AWS OpsWorks Stacks automatically installs
         *        new agent versions on the stack's instances as soon as they are available.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Fixed version - Set this parameter to your preferred agent version. To update the agent version, you
         *        must edit the stack configuration and specify a new version. AWS OpsWorks Stacks then automatically
         *        installs that version on the stack's instances.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The default setting is the most recent release of the agent. To specify an agent version, you must use
         *        the complete version number, not the abbreviated number shown on the console. For a list of available
         *        agent version numbers, call <a>DescribeAgentVersions</a>. AgentVersion cannot be set to Chef 12.2.
         *        </p>
         *        <note>
         *        <p>
         *        You can also specify an agent version when you create or update an instance, which overrides the
         *        stack's default setting.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentVersion(String agentVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpsWorksRequest.BuilderImpl implements Builder {
        private String name;

        private String region;

        private String vpcId;

        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private String serviceRoleArn;

        private String defaultInstanceProfileArn;

        private String defaultOs;

        private String hostnameTheme;

        private String defaultAvailabilityZone;

        private String defaultSubnetId;

        private String customJson;

        private StackConfigurationManager configurationManager;

        private ChefConfiguration chefConfiguration;

        private Boolean useCustomCookbooks;

        private Boolean useOpsworksSecurityGroups;

        private Source customCookbooksSource;

        private String defaultSshKeyName;

        private String defaultRootDeviceType;

        private String agentVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStackRequest model) {
            super(model);
            name(model.name);
            region(model.region);
            vpcId(model.vpcId);
            attributesWithStrings(model.attributes);
            serviceRoleArn(model.serviceRoleArn);
            defaultInstanceProfileArn(model.defaultInstanceProfileArn);
            defaultOs(model.defaultOs);
            hostnameTheme(model.hostnameTheme);
            defaultAvailabilityZone(model.defaultAvailabilityZone);
            defaultSubnetId(model.defaultSubnetId);
            customJson(model.customJson);
            configurationManager(model.configurationManager);
            chefConfiguration(model.chefConfiguration);
            useCustomCookbooks(model.useCustomCookbooks);
            useOpsworksSecurityGroups(model.useOpsworksSecurityGroups);
            customCookbooksSource(model.customCookbooksSource);
            defaultSshKeyName(model.defaultSshKeyName);
            defaultRootDeviceType(model.defaultRootDeviceType);
            agentVersion(model.agentVersion);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getRegion() {
            return region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final Map<String, String> getAttributesAsStrings() {
            return attributes;
        }

        @Override
        public final Builder attributesWithStrings(Map<String, String> attributes) {
            this.attributes = StackAttributesCopier.copy(attributes);
            return this;
        }

        @Override
        public final Builder attributes(Map<StackAttributesKeys, String> attributes) {
            this.attributes = StackAttributesCopier.copyEnumToString(attributes);
            return this;
        }

        public final void setAttributesWithStrings(Map<String, String> attributes) {
            this.attributes = StackAttributesCopier.copy(attributes);
        }

        public final String getServiceRoleArn() {
            return serviceRoleArn;
        }

        @Override
        public final Builder serviceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
            return this;
        }

        public final void setServiceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
        }

        public final String getDefaultInstanceProfileArn() {
            return defaultInstanceProfileArn;
        }

        @Override
        public final Builder defaultInstanceProfileArn(String defaultInstanceProfileArn) {
            this.defaultInstanceProfileArn = defaultInstanceProfileArn;
            return this;
        }

        public final void setDefaultInstanceProfileArn(String defaultInstanceProfileArn) {
            this.defaultInstanceProfileArn = defaultInstanceProfileArn;
        }

        public final String getDefaultOs() {
            return defaultOs;
        }

        @Override
        public final Builder defaultOs(String defaultOs) {
            this.defaultOs = defaultOs;
            return this;
        }

        public final void setDefaultOs(String defaultOs) {
            this.defaultOs = defaultOs;
        }

        public final String getHostnameTheme() {
            return hostnameTheme;
        }

        @Override
        public final Builder hostnameTheme(String hostnameTheme) {
            this.hostnameTheme = hostnameTheme;
            return this;
        }

        public final void setHostnameTheme(String hostnameTheme) {
            this.hostnameTheme = hostnameTheme;
        }

        public final String getDefaultAvailabilityZone() {
            return defaultAvailabilityZone;
        }

        @Override
        public final Builder defaultAvailabilityZone(String defaultAvailabilityZone) {
            this.defaultAvailabilityZone = defaultAvailabilityZone;
            return this;
        }

        public final void setDefaultAvailabilityZone(String defaultAvailabilityZone) {
            this.defaultAvailabilityZone = defaultAvailabilityZone;
        }

        public final String getDefaultSubnetId() {
            return defaultSubnetId;
        }

        @Override
        public final Builder defaultSubnetId(String defaultSubnetId) {
            this.defaultSubnetId = defaultSubnetId;
            return this;
        }

        public final void setDefaultSubnetId(String defaultSubnetId) {
            this.defaultSubnetId = defaultSubnetId;
        }

        public final String getCustomJson() {
            return customJson;
        }

        @Override
        public final Builder customJson(String customJson) {
            this.customJson = customJson;
            return this;
        }

        public final void setCustomJson(String customJson) {
            this.customJson = customJson;
        }

        public final StackConfigurationManager.Builder getConfigurationManager() {
            return configurationManager != null ? configurationManager.toBuilder() : null;
        }

        @Override
        public final Builder configurationManager(StackConfigurationManager configurationManager) {
            this.configurationManager = configurationManager;
            return this;
        }

        public final void setConfigurationManager(StackConfigurationManager.BuilderImpl configurationManager) {
            this.configurationManager = configurationManager != null ? configurationManager.build() : null;
        }

        public final ChefConfiguration.Builder getChefConfiguration() {
            return chefConfiguration != null ? chefConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder chefConfiguration(ChefConfiguration chefConfiguration) {
            this.chefConfiguration = chefConfiguration;
            return this;
        }

        public final void setChefConfiguration(ChefConfiguration.BuilderImpl chefConfiguration) {
            this.chefConfiguration = chefConfiguration != null ? chefConfiguration.build() : null;
        }

        public final Boolean getUseCustomCookbooks() {
            return useCustomCookbooks;
        }

        @Override
        public final Builder useCustomCookbooks(Boolean useCustomCookbooks) {
            this.useCustomCookbooks = useCustomCookbooks;
            return this;
        }

        public final void setUseCustomCookbooks(Boolean useCustomCookbooks) {
            this.useCustomCookbooks = useCustomCookbooks;
        }

        public final Boolean getUseOpsworksSecurityGroups() {
            return useOpsworksSecurityGroups;
        }

        @Override
        public final Builder useOpsworksSecurityGroups(Boolean useOpsworksSecurityGroups) {
            this.useOpsworksSecurityGroups = useOpsworksSecurityGroups;
            return this;
        }

        public final void setUseOpsworksSecurityGroups(Boolean useOpsworksSecurityGroups) {
            this.useOpsworksSecurityGroups = useOpsworksSecurityGroups;
        }

        public final Source.Builder getCustomCookbooksSource() {
            return customCookbooksSource != null ? customCookbooksSource.toBuilder() : null;
        }

        @Override
        public final Builder customCookbooksSource(Source customCookbooksSource) {
            this.customCookbooksSource = customCookbooksSource;
            return this;
        }

        public final void setCustomCookbooksSource(Source.BuilderImpl customCookbooksSource) {
            this.customCookbooksSource = customCookbooksSource != null ? customCookbooksSource.build() : null;
        }

        public final String getDefaultSshKeyName() {
            return defaultSshKeyName;
        }

        @Override
        public final Builder defaultSshKeyName(String defaultSshKeyName) {
            this.defaultSshKeyName = defaultSshKeyName;
            return this;
        }

        public final void setDefaultSshKeyName(String defaultSshKeyName) {
            this.defaultSshKeyName = defaultSshKeyName;
        }

        public final String getDefaultRootDeviceTypeAsString() {
            return defaultRootDeviceType;
        }

        @Override
        public final Builder defaultRootDeviceType(String defaultRootDeviceType) {
            this.defaultRootDeviceType = defaultRootDeviceType;
            return this;
        }

        @Override
        public final Builder defaultRootDeviceType(RootDeviceType defaultRootDeviceType) {
            this.defaultRootDeviceType(defaultRootDeviceType == null ? null : defaultRootDeviceType.toString());
            return this;
        }

        public final void setDefaultRootDeviceType(String defaultRootDeviceType) {
            this.defaultRootDeviceType = defaultRootDeviceType;
        }

        public final String getAgentVersion() {
            return agentVersion;
        }

        @Override
        public final Builder agentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
            return this;
        }

        public final void setAgentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateStackRequest build() {
            return new CreateStackRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
