/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response to a <code>DescribeOperatingSystems</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeOperatingSystemsResponse extends OpsWorksResponse implements
        ToCopyableBuilder<DescribeOperatingSystemsResponse.Builder, DescribeOperatingSystemsResponse> {
    private static final SdkField<List<OperatingSystem>> OPERATING_SYSTEMS_FIELD = SdkField
            .<List<OperatingSystem>> builder(MarshallingType.LIST)
            .getter(getter(DescribeOperatingSystemsResponse::operatingSystems))
            .setter(setter(Builder::operatingSystems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingSystems").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OperatingSystem> builder(MarshallingType.SDK_POJO)
                                            .constructor(OperatingSystem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERATING_SYSTEMS_FIELD));

    private final List<OperatingSystem> operatingSystems;

    private DescribeOperatingSystemsResponse(BuilderImpl builder) {
        super(builder);
        this.operatingSystems = builder.operatingSystems;
    }

    /**
     * Returns true if the OperatingSystems property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasOperatingSystems() {
        return operatingSystems != null && !(operatingSystems instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains information in response to a <code>DescribeOperatingSystems</code> request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOperatingSystems()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Contains information in response to a <code>DescribeOperatingSystems</code> request.
     */
    public List<OperatingSystem> operatingSystems() {
        return operatingSystems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(operatingSystems());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOperatingSystemsResponse)) {
            return false;
        }
        DescribeOperatingSystemsResponse other = (DescribeOperatingSystemsResponse) obj;
        return Objects.equals(operatingSystems(), other.operatingSystems());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeOperatingSystemsResponse").add("OperatingSystems", operatingSystems()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OperatingSystems":
            return Optional.ofNullable(clazz.cast(operatingSystems()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeOperatingSystemsResponse, T> g) {
        return obj -> g.apply((DescribeOperatingSystemsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpsWorksResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeOperatingSystemsResponse> {
        /**
         * <p>
         * Contains information in response to a <code>DescribeOperatingSystems</code> request.
         * </p>
         * 
         * @param operatingSystems
         *        Contains information in response to a <code>DescribeOperatingSystems</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operatingSystems(Collection<OperatingSystem> operatingSystems);

        /**
         * <p>
         * Contains information in response to a <code>DescribeOperatingSystems</code> request.
         * </p>
         * 
         * @param operatingSystems
         *        Contains information in response to a <code>DescribeOperatingSystems</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operatingSystems(OperatingSystem... operatingSystems);

        /**
         * <p>
         * Contains information in response to a <code>DescribeOperatingSystems</code> request.
         * </p>
         * This is a convenience that creates an instance of the {@link List<OperatingSystem>.Builder} avoiding the need
         * to create one manually via {@link List<OperatingSystem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<OperatingSystem>.Builder#build()} is called immediately and
         * its result is passed to {@link #operatingSystems(List<OperatingSystem>)}.
         * 
         * @param operatingSystems
         *        a consumer that will call methods on {@link List<OperatingSystem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #operatingSystems(List<OperatingSystem>)
         */
        Builder operatingSystems(Consumer<OperatingSystem.Builder>... operatingSystems);
    }

    static final class BuilderImpl extends OpsWorksResponse.BuilderImpl implements Builder {
        private List<OperatingSystem> operatingSystems = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOperatingSystemsResponse model) {
            super(model);
            operatingSystems(model.operatingSystems);
        }

        public final Collection<OperatingSystem.Builder> getOperatingSystems() {
            return operatingSystems != null ? operatingSystems.stream().map(OperatingSystem::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder operatingSystems(Collection<OperatingSystem> operatingSystems) {
            this.operatingSystems = OperatingSystemsCopier.copy(operatingSystems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operatingSystems(OperatingSystem... operatingSystems) {
            operatingSystems(Arrays.asList(operatingSystems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operatingSystems(Consumer<OperatingSystem.Builder>... operatingSystems) {
            operatingSystems(Stream.of(operatingSystems).map(c -> OperatingSystem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setOperatingSystems(Collection<OperatingSystem.BuilderImpl> operatingSystems) {
            this.operatingSystems = OperatingSystemsCopier.copyFromBuilder(operatingSystems);
        }

        @Override
        public DescribeOperatingSystemsResponse build() {
            return new DescribeOperatingSystemsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
