/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a time-based instance's auto scaling schedule. The schedule consists of a set of key-value pairs.
 * </p>
 * <ul>
 * <li>
 * <p>
 * The key is the time period (a UTC hour) and must be an integer from 0 - 23.
 * </p>
 * </li>
 * <li>
 * <p>
 * The value indicates whether the instance should be online or offline for the specified period, and must be set to
 * "on" or "off"
 * </p>
 * </li>
 * </ul>
 * <p>
 * The default setting for all time periods is off, so you use the following parameters primarily to specify the online
 * periods. You don't have to explicitly specify offline periods unless you want to change an online period to an
 * offline period.
 * </p>
 * <p>
 * The following example specifies that the instance should be online for four hours, from UTC 1200 - 1600. It will be
 * off for the remainder of the day.
 * </p>
 * <p>
 * <code> { "12":"on", "13":"on", "14":"on", "15":"on" } </code>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WeeklyAutoScalingSchedule implements SdkPojo, Serializable,
        ToCopyableBuilder<WeeklyAutoScalingSchedule.Builder, WeeklyAutoScalingSchedule> {
    private static final SdkField<Map<String, String>> MONDAY_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(WeeklyAutoScalingSchedule::monday))
            .setter(setter(Builder::monday))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Monday").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TUESDAY_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(WeeklyAutoScalingSchedule::tuesday))
            .setter(setter(Builder::tuesday))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tuesday").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> WEDNESDAY_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(WeeklyAutoScalingSchedule::wednesday))
            .setter(setter(Builder::wednesday))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Wednesday").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> THURSDAY_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(WeeklyAutoScalingSchedule::thursday))
            .setter(setter(Builder::thursday))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Thursday").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> FRIDAY_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(WeeklyAutoScalingSchedule::friday))
            .setter(setter(Builder::friday))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Friday").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> SATURDAY_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(WeeklyAutoScalingSchedule::saturday))
            .setter(setter(Builder::saturday))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Saturday").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> SUNDAY_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(WeeklyAutoScalingSchedule::sunday))
            .setter(setter(Builder::sunday))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sunday").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONDAY_FIELD, TUESDAY_FIELD,
            WEDNESDAY_FIELD, THURSDAY_FIELD, FRIDAY_FIELD, SATURDAY_FIELD, SUNDAY_FIELD));

    private static final long serialVersionUID = 1L;

    private final Map<String, String> monday;

    private final Map<String, String> tuesday;

    private final Map<String, String> wednesday;

    private final Map<String, String> thursday;

    private final Map<String, String> friday;

    private final Map<String, String> saturday;

    private final Map<String, String> sunday;

    private WeeklyAutoScalingSchedule(BuilderImpl builder) {
        this.monday = builder.monday;
        this.tuesday = builder.tuesday;
        this.wednesday = builder.wednesday;
        this.thursday = builder.thursday;
        this.friday = builder.friday;
        this.saturday = builder.saturday;
        this.sunday = builder.sunday;
    }

    /**
     * Returns true if the Monday property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasMonday() {
        return monday != null && !(monday instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The schedule for Monday.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMonday()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The schedule for Monday.
     */
    public Map<String, String> monday() {
        return monday;
    }

    /**
     * Returns true if the Tuesday property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTuesday() {
        return tuesday != null && !(tuesday instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The schedule for Tuesday.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTuesday()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The schedule for Tuesday.
     */
    public Map<String, String> tuesday() {
        return tuesday;
    }

    /**
     * Returns true if the Wednesday property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasWednesday() {
        return wednesday != null && !(wednesday instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The schedule for Wednesday.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasWednesday()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The schedule for Wednesday.
     */
    public Map<String, String> wednesday() {
        return wednesday;
    }

    /**
     * Returns true if the Thursday property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasThursday() {
        return thursday != null && !(thursday instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The schedule for Thursday.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasThursday()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The schedule for Thursday.
     */
    public Map<String, String> thursday() {
        return thursday;
    }

    /**
     * Returns true if the Friday property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFriday() {
        return friday != null && !(friday instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The schedule for Friday.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFriday()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The schedule for Friday.
     */
    public Map<String, String> friday() {
        return friday;
    }

    /**
     * Returns true if the Saturday property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSaturday() {
        return saturday != null && !(saturday instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The schedule for Saturday.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSaturday()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The schedule for Saturday.
     */
    public Map<String, String> saturday() {
        return saturday;
    }

    /**
     * Returns true if the Sunday property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSunday() {
        return sunday != null && !(sunday instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The schedule for Sunday.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSunday()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The schedule for Sunday.
     */
    public Map<String, String> sunday() {
        return sunday;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(monday());
        hashCode = 31 * hashCode + Objects.hashCode(tuesday());
        hashCode = 31 * hashCode + Objects.hashCode(wednesday());
        hashCode = 31 * hashCode + Objects.hashCode(thursday());
        hashCode = 31 * hashCode + Objects.hashCode(friday());
        hashCode = 31 * hashCode + Objects.hashCode(saturday());
        hashCode = 31 * hashCode + Objects.hashCode(sunday());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WeeklyAutoScalingSchedule)) {
            return false;
        }
        WeeklyAutoScalingSchedule other = (WeeklyAutoScalingSchedule) obj;
        return Objects.equals(monday(), other.monday()) && Objects.equals(tuesday(), other.tuesday())
                && Objects.equals(wednesday(), other.wednesday()) && Objects.equals(thursday(), other.thursday())
                && Objects.equals(friday(), other.friday()) && Objects.equals(saturday(), other.saturday())
                && Objects.equals(sunday(), other.sunday());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("WeeklyAutoScalingSchedule").add("Monday", monday()).add("Tuesday", tuesday())
                .add("Wednesday", wednesday()).add("Thursday", thursday()).add("Friday", friday()).add("Saturday", saturday())
                .add("Sunday", sunday()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Monday":
            return Optional.ofNullable(clazz.cast(monday()));
        case "Tuesday":
            return Optional.ofNullable(clazz.cast(tuesday()));
        case "Wednesday":
            return Optional.ofNullable(clazz.cast(wednesday()));
        case "Thursday":
            return Optional.ofNullable(clazz.cast(thursday()));
        case "Friday":
            return Optional.ofNullable(clazz.cast(friday()));
        case "Saturday":
            return Optional.ofNullable(clazz.cast(saturday()));
        case "Sunday":
            return Optional.ofNullable(clazz.cast(sunday()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WeeklyAutoScalingSchedule, T> g) {
        return obj -> g.apply((WeeklyAutoScalingSchedule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WeeklyAutoScalingSchedule> {
        /**
         * <p>
         * The schedule for Monday.
         * </p>
         * 
         * @param monday
         *        The schedule for Monday.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monday(Map<String, String> monday);

        /**
         * <p>
         * The schedule for Tuesday.
         * </p>
         * 
         * @param tuesday
         *        The schedule for Tuesday.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tuesday(Map<String, String> tuesday);

        /**
         * <p>
         * The schedule for Wednesday.
         * </p>
         * 
         * @param wednesday
         *        The schedule for Wednesday.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wednesday(Map<String, String> wednesday);

        /**
         * <p>
         * The schedule for Thursday.
         * </p>
         * 
         * @param thursday
         *        The schedule for Thursday.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thursday(Map<String, String> thursday);

        /**
         * <p>
         * The schedule for Friday.
         * </p>
         * 
         * @param friday
         *        The schedule for Friday.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder friday(Map<String, String> friday);

        /**
         * <p>
         * The schedule for Saturday.
         * </p>
         * 
         * @param saturday
         *        The schedule for Saturday.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder saturday(Map<String, String> saturday);

        /**
         * <p>
         * The schedule for Sunday.
         * </p>
         * 
         * @param sunday
         *        The schedule for Sunday.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sunday(Map<String, String> sunday);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, String> monday = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> tuesday = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> wednesday = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> thursday = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> friday = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> saturday = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> sunday = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(WeeklyAutoScalingSchedule model) {
            monday(model.monday);
            tuesday(model.tuesday);
            wednesday(model.wednesday);
            thursday(model.thursday);
            friday(model.friday);
            saturday(model.saturday);
            sunday(model.sunday);
        }

        public final Map<String, String> getMonday() {
            return monday;
        }

        @Override
        public final Builder monday(Map<String, String> monday) {
            this.monday = DailyAutoScalingScheduleCopier.copy(monday);
            return this;
        }

        public final void setMonday(Map<String, String> monday) {
            this.monday = DailyAutoScalingScheduleCopier.copy(monday);
        }

        public final Map<String, String> getTuesday() {
            return tuesday;
        }

        @Override
        public final Builder tuesday(Map<String, String> tuesday) {
            this.tuesday = DailyAutoScalingScheduleCopier.copy(tuesday);
            return this;
        }

        public final void setTuesday(Map<String, String> tuesday) {
            this.tuesday = DailyAutoScalingScheduleCopier.copy(tuesday);
        }

        public final Map<String, String> getWednesday() {
            return wednesday;
        }

        @Override
        public final Builder wednesday(Map<String, String> wednesday) {
            this.wednesday = DailyAutoScalingScheduleCopier.copy(wednesday);
            return this;
        }

        public final void setWednesday(Map<String, String> wednesday) {
            this.wednesday = DailyAutoScalingScheduleCopier.copy(wednesday);
        }

        public final Map<String, String> getThursday() {
            return thursday;
        }

        @Override
        public final Builder thursday(Map<String, String> thursday) {
            this.thursday = DailyAutoScalingScheduleCopier.copy(thursday);
            return this;
        }

        public final void setThursday(Map<String, String> thursday) {
            this.thursday = DailyAutoScalingScheduleCopier.copy(thursday);
        }

        public final Map<String, String> getFriday() {
            return friday;
        }

        @Override
        public final Builder friday(Map<String, String> friday) {
            this.friday = DailyAutoScalingScheduleCopier.copy(friday);
            return this;
        }

        public final void setFriday(Map<String, String> friday) {
            this.friday = DailyAutoScalingScheduleCopier.copy(friday);
        }

        public final Map<String, String> getSaturday() {
            return saturday;
        }

        @Override
        public final Builder saturday(Map<String, String> saturday) {
            this.saturday = DailyAutoScalingScheduleCopier.copy(saturday);
            return this;
        }

        public final void setSaturday(Map<String, String> saturday) {
            this.saturday = DailyAutoScalingScheduleCopier.copy(saturday);
        }

        public final Map<String, String> getSunday() {
            return sunday;
        }

        @Override
        public final Builder sunday(Map<String, String> sunday) {
            this.sunday = DailyAutoScalingScheduleCopier.copy(sunday);
            return this;
        }

        public final void setSunday(Map<String, String> sunday) {
            this.sunday = DailyAutoScalingScheduleCopier.copy(sunday);
        }

        @Override
        public WeeklyAutoScalingSchedule build() {
            return new WeeklyAutoScalingSchedule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
