/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEcsClustersRequest extends OpsWorksRequest implements
        ToCopyableBuilder<DescribeEcsClustersRequest.Builder, DescribeEcsClustersRequest> {
    private static final SdkField<List<String>> ECS_CLUSTER_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeEcsClustersRequest::ecsClusterArns))
            .setter(setter(Builder::ecsClusterArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EcsClusterArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STACK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeEcsClustersRequest::stackId)).setter(setter(Builder::stackId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackId").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeEcsClustersRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribeEcsClustersRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ECS_CLUSTER_ARNS_FIELD,
            STACK_ID_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final List<String> ecsClusterArns;

    private final String stackId;

    private final String nextToken;

    private final Integer maxResults;

    private DescribeEcsClustersRequest(BuilderImpl builder) {
        super(builder);
        this.ecsClusterArns = builder.ecsClusterArns;
        this.stackId = builder.stackId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * Returns true if the EcsClusterArns property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasEcsClusterArns() {
        return ecsClusterArns != null && !(ecsClusterArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of ARNs, one for each cluster to be described.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEcsClusterArns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of ARNs, one for each cluster to be described.
     */
    public List<String> ecsClusterArns() {
        return ecsClusterArns;
    }

    /**
     * <p>
     * A stack ID. <code>DescribeEcsClusters</code> returns a description of the cluster that is registered with the
     * stack.
     * </p>
     * 
     * @return A stack ID. <code>DescribeEcsClusters</code> returns a description of the cluster that is registered with
     *         the stack.
     */
    public String stackId() {
        return stackId;
    }

    /**
     * <p>
     * If the previous paginated request did not return all of the remaining results, the response object's
     * <code>NextToken</code> parameter value is set to a token. To retrieve the next set of results, call
     * <code>DescribeEcsClusters</code> again and assign that token to the request object's <code>NextToken</code>
     * parameter. If there are no remaining results, the previous response object's <code>NextToken</code> parameter is
     * set to <code>null</code>.
     * </p>
     * 
     * @return If the previous paginated request did not return all of the remaining results, the response object's
     *         <code>NextToken</code> parameter value is set to a token. To retrieve the next set of results, call
     *         <code>DescribeEcsClusters</code> again and assign that token to the request object's
     *         <code>NextToken</code> parameter. If there are no remaining results, the previous response object's
     *         <code>NextToken</code> parameter is set to <code>null</code>.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * To receive a paginated response, use this parameter to specify the maximum number of results to be returned with
     * a single call. If the number of available results exceeds this maximum, the response includes a
     * <code>NextToken</code> value that you can assign to the <code>NextToken</code> request parameter to get the next
     * set of results.
     * </p>
     * 
     * @return To receive a paginated response, use this parameter to specify the maximum number of results to be
     *         returned with a single call. If the number of available results exceeds this maximum, the response
     *         includes a <code>NextToken</code> value that you can assign to the <code>NextToken</code> request
     *         parameter to get the next set of results.
     */
    public Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ecsClusterArns());
        hashCode = 31 * hashCode + Objects.hashCode(stackId());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEcsClustersRequest)) {
            return false;
        }
        DescribeEcsClustersRequest other = (DescribeEcsClustersRequest) obj;
        return Objects.equals(ecsClusterArns(), other.ecsClusterArns()) && Objects.equals(stackId(), other.stackId())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeEcsClustersRequest").add("EcsClusterArns", ecsClusterArns()).add("StackId", stackId())
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EcsClusterArns":
            return Optional.ofNullable(clazz.cast(ecsClusterArns()));
        case "StackId":
            return Optional.ofNullable(clazz.cast(stackId()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEcsClustersRequest, T> g) {
        return obj -> g.apply((DescribeEcsClustersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpsWorksRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeEcsClustersRequest> {
        /**
         * <p>
         * A list of ARNs, one for each cluster to be described.
         * </p>
         * 
         * @param ecsClusterArns
         *        A list of ARNs, one for each cluster to be described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecsClusterArns(Collection<String> ecsClusterArns);

        /**
         * <p>
         * A list of ARNs, one for each cluster to be described.
         * </p>
         * 
         * @param ecsClusterArns
         *        A list of ARNs, one for each cluster to be described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecsClusterArns(String... ecsClusterArns);

        /**
         * <p>
         * A stack ID. <code>DescribeEcsClusters</code> returns a description of the cluster that is registered with the
         * stack.
         * </p>
         * 
         * @param stackId
         *        A stack ID. <code>DescribeEcsClusters</code> returns a description of the cluster that is registered
         *        with the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * If the previous paginated request did not return all of the remaining results, the response object's
         * <code>NextToken</code> parameter value is set to a token. To retrieve the next set of results, call
         * <code>DescribeEcsClusters</code> again and assign that token to the request object's <code>NextToken</code>
         * parameter. If there are no remaining results, the previous response object's <code>NextToken</code> parameter
         * is set to <code>null</code>.
         * </p>
         * 
         * @param nextToken
         *        If the previous paginated request did not return all of the remaining results, the response object's
         *        <code>NextToken</code> parameter value is set to a token. To retrieve the next set of results, call
         *        <code>DescribeEcsClusters</code> again and assign that token to the request object's
         *        <code>NextToken</code> parameter. If there are no remaining results, the previous response object's
         *        <code>NextToken</code> parameter is set to <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * To receive a paginated response, use this parameter to specify the maximum number of results to be returned
         * with a single call. If the number of available results exceeds this maximum, the response includes a
         * <code>NextToken</code> value that you can assign to the <code>NextToken</code> request parameter to get the
         * next set of results.
         * </p>
         * 
         * @param maxResults
         *        To receive a paginated response, use this parameter to specify the maximum number of results to be
         *        returned with a single call. If the number of available results exceeds this maximum, the response
         *        includes a <code>NextToken</code> value that you can assign to the <code>NextToken</code> request
         *        parameter to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpsWorksRequest.BuilderImpl implements Builder {
        private List<String> ecsClusterArns = DefaultSdkAutoConstructList.getInstance();

        private String stackId;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEcsClustersRequest model) {
            super(model);
            ecsClusterArns(model.ecsClusterArns);
            stackId(model.stackId);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final Collection<String> getEcsClusterArns() {
            return ecsClusterArns;
        }

        @Override
        public final Builder ecsClusterArns(Collection<String> ecsClusterArns) {
            this.ecsClusterArns = StringsCopier.copy(ecsClusterArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ecsClusterArns(String... ecsClusterArns) {
            ecsClusterArns(Arrays.asList(ecsClusterArns));
            return this;
        }

        public final void setEcsClusterArns(Collection<String> ecsClusterArns) {
            this.ecsClusterArns = StringsCopier.copy(ecsClusterArns);
        }

        public final String getStackId() {
            return stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeEcsClustersRequest build() {
            return new DescribeEcsClustersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
