/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a <code>GrantAccess</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GrantAccessResponse extends OpsWorksResponse implements
        ToCopyableBuilder<GrantAccessResponse.Builder, GrantAccessResponse> {
    private static final SdkField<TemporaryCredential> TEMPORARY_CREDENTIAL_FIELD = SdkField
            .<TemporaryCredential> builder(MarshallingType.SDK_POJO).getter(getter(GrantAccessResponse::temporaryCredential))
            .setter(setter(Builder::temporaryCredential)).constructor(TemporaryCredential::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemporaryCredential").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPORARY_CREDENTIAL_FIELD));

    private final TemporaryCredential temporaryCredential;

    private GrantAccessResponse(BuilderImpl builder) {
        super(builder);
        this.temporaryCredential = builder.temporaryCredential;
    }

    /**
     * <p>
     * A <code>TemporaryCredential</code> object that contains the data needed to log in to the instance by RDP clients,
     * such as the Microsoft Remote Desktop Connection.
     * </p>
     * 
     * @return A <code>TemporaryCredential</code> object that contains the data needed to log in to the instance by RDP
     *         clients, such as the Microsoft Remote Desktop Connection.
     */
    public TemporaryCredential temporaryCredential() {
        return temporaryCredential;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(temporaryCredential());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GrantAccessResponse)) {
            return false;
        }
        GrantAccessResponse other = (GrantAccessResponse) obj;
        return Objects.equals(temporaryCredential(), other.temporaryCredential());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GrantAccessResponse").add("TemporaryCredential", temporaryCredential()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TemporaryCredential":
            return Optional.ofNullable(clazz.cast(temporaryCredential()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GrantAccessResponse, T> g) {
        return obj -> g.apply((GrantAccessResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpsWorksResponse.Builder, SdkPojo, CopyableBuilder<Builder, GrantAccessResponse> {
        /**
         * <p>
         * A <code>TemporaryCredential</code> object that contains the data needed to log in to the instance by RDP
         * clients, such as the Microsoft Remote Desktop Connection.
         * </p>
         * 
         * @param temporaryCredential
         *        A <code>TemporaryCredential</code> object that contains the data needed to log in to the instance by
         *        RDP clients, such as the Microsoft Remote Desktop Connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder temporaryCredential(TemporaryCredential temporaryCredential);

        /**
         * <p>
         * A <code>TemporaryCredential</code> object that contains the data needed to log in to the instance by RDP
         * clients, such as the Microsoft Remote Desktop Connection.
         * </p>
         * This is a convenience that creates an instance of the {@link TemporaryCredential.Builder} avoiding the need
         * to create one manually via {@link TemporaryCredential#builder()}.
         *
         * When the {@link Consumer} completes, {@link TemporaryCredential.Builder#build()} is called immediately and
         * its result is passed to {@link #temporaryCredential(TemporaryCredential)}.
         * 
         * @param temporaryCredential
         *        a consumer that will call methods on {@link TemporaryCredential.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #temporaryCredential(TemporaryCredential)
         */
        default Builder temporaryCredential(Consumer<TemporaryCredential.Builder> temporaryCredential) {
            return temporaryCredential(TemporaryCredential.builder().applyMutation(temporaryCredential).build());
        }
    }

    static final class BuilderImpl extends OpsWorksResponse.BuilderImpl implements Builder {
        private TemporaryCredential temporaryCredential;

        private BuilderImpl() {
        }

        private BuilderImpl(GrantAccessResponse model) {
            super(model);
            temporaryCredential(model.temporaryCredential);
        }

        public final TemporaryCredential.Builder getTemporaryCredential() {
            return temporaryCredential != null ? temporaryCredential.toBuilder() : null;
        }

        @Override
        public final Builder temporaryCredential(TemporaryCredential temporaryCredential) {
            this.temporaryCredential = temporaryCredential;
            return this;
        }

        public final void setTemporaryCredential(TemporaryCredential.BuilderImpl temporaryCredential) {
            this.temporaryCredential = temporaryCredential != null ? temporaryCredential.build() : null;
        }

        @Override
        public GrantAccessResponse build() {
            return new GrantAccessResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
