/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A registered instance's reported operating system.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReportedOs implements SdkPojo, Serializable, ToCopyableBuilder<ReportedOs.Builder, ReportedOs> {
    private static final SdkField<String> FAMILY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ReportedOs::family)).setter(setter(Builder::family))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Family").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ReportedOs::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ReportedOs::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAMILY_FIELD, NAME_FIELD,
            VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String family;

    private final String name;

    private final String version;

    private ReportedOs(BuilderImpl builder) {
        this.family = builder.family;
        this.name = builder.name;
        this.version = builder.version;
    }

    /**
     * <p>
     * The operating system family.
     * </p>
     * 
     * @return The operating system family.
     */
    public String family() {
        return family;
    }

    /**
     * <p>
     * The operating system name.
     * </p>
     * 
     * @return The operating system name.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The operating system version.
     * </p>
     * 
     * @return The operating system version.
     */
    public String version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(family());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportedOs)) {
            return false;
        }
        ReportedOs other = (ReportedOs) obj;
        return Objects.equals(family(), other.family()) && Objects.equals(name(), other.name())
                && Objects.equals(version(), other.version());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ReportedOs").add("Family", family()).add("Name", name()).add("Version", version()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Family":
            return Optional.ofNullable(clazz.cast(family()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReportedOs, T> g) {
        return obj -> g.apply((ReportedOs) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReportedOs> {
        /**
         * <p>
         * The operating system family.
         * </p>
         * 
         * @param family
         *        The operating system family.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder family(String family);

        /**
         * <p>
         * The operating system name.
         * </p>
         * 
         * @param name
         *        The operating system name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The operating system version.
         * </p>
         * 
         * @param version
         *        The operating system version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);
    }

    static final class BuilderImpl implements Builder {
        private String family;

        private String name;

        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(ReportedOs model) {
            family(model.family);
            name(model.name);
            version(model.version);
        }

        public final String getFamily() {
            return family;
        }

        @Override
        public final Builder family(String family) {
            this.family = family;
            return this;
        }

        public final void setFamily(String family) {
            this.family = family;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getVersion() {
            return version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public ReportedOs build() {
            return new ReportedOs(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
