/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a <code>DescribeStackSummary</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeStackSummaryResponse extends OpsWorksResponse implements
        ToCopyableBuilder<DescribeStackSummaryResponse.Builder, DescribeStackSummaryResponse> {
    private static final SdkField<StackSummary> STACK_SUMMARY_FIELD = SdkField.<StackSummary> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeStackSummaryResponse::stackSummary)).setter(setter(Builder::stackSummary))
            .constructor(StackSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackSummary").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_SUMMARY_FIELD));

    private final StackSummary stackSummary;

    private DescribeStackSummaryResponse(BuilderImpl builder) {
        super(builder);
        this.stackSummary = builder.stackSummary;
    }

    /**
     * <p>
     * A <code>StackSummary</code> object that contains the results.
     * </p>
     * 
     * @return A <code>StackSummary</code> object that contains the results.
     */
    public StackSummary stackSummary() {
        return stackSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stackSummary());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStackSummaryResponse)) {
            return false;
        }
        DescribeStackSummaryResponse other = (DescribeStackSummaryResponse) obj;
        return Objects.equals(stackSummary(), other.stackSummary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeStackSummaryResponse").add("StackSummary", stackSummary()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackSummary":
            return Optional.ofNullable(clazz.cast(stackSummary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeStackSummaryResponse, T> g) {
        return obj -> g.apply((DescribeStackSummaryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpsWorksResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeStackSummaryResponse> {
        /**
         * <p>
         * A <code>StackSummary</code> object that contains the results.
         * </p>
         * 
         * @param stackSummary
         *        A <code>StackSummary</code> object that contains the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackSummary(StackSummary stackSummary);

        /**
         * <p>
         * A <code>StackSummary</code> object that contains the results.
         * </p>
         * This is a convenience that creates an instance of the {@link StackSummary.Builder} avoiding the need to
         * create one manually via {@link StackSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link StackSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #stackSummary(StackSummary)}.
         * 
         * @param stackSummary
         *        a consumer that will call methods on {@link StackSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stackSummary(StackSummary)
         */
        default Builder stackSummary(Consumer<StackSummary.Builder> stackSummary) {
            return stackSummary(StackSummary.builder().applyMutation(stackSummary).build());
        }
    }

    static final class BuilderImpl extends OpsWorksResponse.BuilderImpl implements Builder {
        private StackSummary stackSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStackSummaryResponse model) {
            super(model);
            stackSummary(model.stackSummary);
        }

        public final StackSummary.Builder getStackSummary() {
            return stackSummary != null ? stackSummary.toBuilder() : null;
        }

        @Override
        public final Builder stackSummary(StackSummary stackSummary) {
            this.stackSummary = stackSummary;
            return this;
        }

        public final void setStackSummary(StackSummary.BuilderImpl stackSummary) {
            this.stackSummary = stackSummary != null ? stackSummary.build() : null;
        }

        @Override
        public DescribeStackSummaryResponse build() {
            return new DescribeStackSummaryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
