/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.opsworks.OpsWorksClient;
import software.amazon.awssdk.services.opsworks.model.DescribeEcsClustersRequest;
import software.amazon.awssdk.services.opsworks.model.DescribeEcsClustersResponse;
import software.amazon.awssdk.services.opsworks.model.EcsCluster;

public class DescribeEcsClustersIterable
implements SdkIterable<DescribeEcsClustersResponse> {
    private final OpsWorksClient client;
    private final DescribeEcsClustersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeEcsClustersIterable(OpsWorksClient client, DescribeEcsClustersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeEcsClustersResponseFetcher();
    }

    public Iterator<DescribeEcsClustersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<EcsCluster> ecsClusters() {
        Function<DescribeEcsClustersResponse, Iterator> getIterator = response -> {
            if (response != null && response.ecsClusters() != null) {
                return response.ecsClusters().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeEcsClustersResponseFetcher
    implements SyncPageFetcher<DescribeEcsClustersResponse> {
        private DescribeEcsClustersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeEcsClustersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeEcsClustersResponse nextPage(DescribeEcsClustersResponse previousPage) {
            if (previousPage == null) {
                return DescribeEcsClustersIterable.this.client.describeEcsClusters(DescribeEcsClustersIterable.this.firstRequest);
            }
            return DescribeEcsClustersIterable.this.client.describeEcsClusters((DescribeEcsClustersRequest)((Object)DescribeEcsClustersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

