/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeUserProfilesRequest extends OpsWorksRequest implements
        ToCopyableBuilder<DescribeUserProfilesRequest.Builder, DescribeUserProfilesRequest> {
    private static final SdkField<List<String>> IAM_USER_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeUserProfilesRequest::iamUserArns))
            .setter(setter(Builder::iamUserArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamUserArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IAM_USER_ARNS_FIELD));

    private final List<String> iamUserArns;

    private DescribeUserProfilesRequest(BuilderImpl builder) {
        super(builder);
        this.iamUserArns = builder.iamUserArns;
    }

    /**
     * Returns true if the IamUserArns property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasIamUserArns() {
        return iamUserArns != null && !(iamUserArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of IAM or federated user ARNs that identify the users to be described.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIamUserArns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of IAM or federated user ARNs that identify the users to be described.
     */
    public List<String> iamUserArns() {
        return iamUserArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(iamUserArns());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeUserProfilesRequest)) {
            return false;
        }
        DescribeUserProfilesRequest other = (DescribeUserProfilesRequest) obj;
        return Objects.equals(iamUserArns(), other.iamUserArns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeUserProfilesRequest").add("IamUserArns", iamUserArns()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IamUserArns":
            return Optional.ofNullable(clazz.cast(iamUserArns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeUserProfilesRequest, T> g) {
        return obj -> g.apply((DescribeUserProfilesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpsWorksRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeUserProfilesRequest> {
        /**
         * <p>
         * An array of IAM or federated user ARNs that identify the users to be described.
         * </p>
         * 
         * @param iamUserArns
         *        An array of IAM or federated user ARNs that identify the users to be described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamUserArns(Collection<String> iamUserArns);

        /**
         * <p>
         * An array of IAM or federated user ARNs that identify the users to be described.
         * </p>
         * 
         * @param iamUserArns
         *        An array of IAM or federated user ARNs that identify the users to be described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamUserArns(String... iamUserArns);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpsWorksRequest.BuilderImpl implements Builder {
        private List<String> iamUserArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeUserProfilesRequest model) {
            super(model);
            iamUserArns(model.iamUserArns);
        }

        public final Collection<String> getIamUserArns() {
            return iamUserArns;
        }

        @Override
        public final Builder iamUserArns(Collection<String> iamUserArns) {
            this.iamUserArns = StringsCopier.copy(iamUserArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder iamUserArns(String... iamUserArns) {
            iamUserArns(Arrays.asList(iamUserArns));
            return this;
        }

        public final void setIamUserArns(Collection<String> iamUserArns) {
            this.iamUserArns = StringsCopier.copy(iamUserArns);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeUserProfilesRequest build() {
            return new DescribeUserProfilesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
