/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.opsworks.model.AppAttributesCopier;
import software.amazon.awssdk.services.opsworks.model.AppAttributesKeys;
import software.amazon.awssdk.services.opsworks.model.AppType;
import software.amazon.awssdk.services.opsworks.model.DataSource;
import software.amazon.awssdk.services.opsworks.model.DataSourcesCopier;
import software.amazon.awssdk.services.opsworks.model.EnvironmentVariable;
import software.amazon.awssdk.services.opsworks.model.EnvironmentVariablesCopier;
import software.amazon.awssdk.services.opsworks.model.OpsWorksRequest;
import software.amazon.awssdk.services.opsworks.model.Source;
import software.amazon.awssdk.services.opsworks.model.SslConfiguration;
import software.amazon.awssdk.services.opsworks.model.StringsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAppRequest
extends OpsWorksRequest
implements ToCopyableBuilder<Builder, CreateAppRequest> {
    private static final SdkField<String> STACK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateAppRequest.getter(CreateAppRequest::stackId)).setter(CreateAppRequest.setter(Builder::stackId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackId").build()}).build();
    private static final SdkField<String> SHORTNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateAppRequest.getter(CreateAppRequest::shortname)).setter(CreateAppRequest.setter(Builder::shortname)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Shortname").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateAppRequest.getter(CreateAppRequest::name)).setter(CreateAppRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateAppRequest.getter(CreateAppRequest::description)).setter(CreateAppRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<DataSource>> DATA_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateAppRequest.getter(CreateAppRequest::dataSources)).setter(CreateAppRequest.setter(Builder::dataSources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateAppRequest.getter(CreateAppRequest::typeAsString)).setter(CreateAppRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<Source> APP_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateAppRequest.getter(CreateAppRequest::appSource)).setter(CreateAppRequest.setter(Builder::appSource)).constructor(Source::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppSource").build()}).build();
    private static final SdkField<List<String>> DOMAINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateAppRequest.getter(CreateAppRequest::domains)).setter(CreateAppRequest.setter(Builder::domains)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domains").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ENABLE_SSL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(CreateAppRequest.getter(CreateAppRequest::enableSsl)).setter(CreateAppRequest.setter(Builder::enableSsl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableSsl").build()}).build();
    private static final SdkField<SslConfiguration> SSL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateAppRequest.getter(CreateAppRequest::sslConfiguration)).setter(CreateAppRequest.setter(Builder::sslConfiguration)).constructor(SslConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SslConfiguration").build()}).build();
    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(CreateAppRequest.getter(CreateAppRequest::attributesAsStrings)).setter(CreateAppRequest.setter(Builder::attributesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<EnvironmentVariable>> ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateAppRequest.getter(CreateAppRequest::environment)).setter(CreateAppRequest.setter(Builder::environment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Environment").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EnvironmentVariable::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_ID_FIELD, SHORTNAME_FIELD, NAME_FIELD, DESCRIPTION_FIELD, DATA_SOURCES_FIELD, TYPE_FIELD, APP_SOURCE_FIELD, DOMAINS_FIELD, ENABLE_SSL_FIELD, SSL_CONFIGURATION_FIELD, ATTRIBUTES_FIELD, ENVIRONMENT_FIELD));
    private final String stackId;
    private final String shortname;
    private final String name;
    private final String description;
    private final List<DataSource> dataSources;
    private final String type;
    private final Source appSource;
    private final List<String> domains;
    private final Boolean enableSsl;
    private final SslConfiguration sslConfiguration;
    private final Map<String, String> attributes;
    private final List<EnvironmentVariable> environment;

    private CreateAppRequest(BuilderImpl builder) {
        super(builder);
        this.stackId = builder.stackId;
        this.shortname = builder.shortname;
        this.name = builder.name;
        this.description = builder.description;
        this.dataSources = builder.dataSources;
        this.type = builder.type;
        this.appSource = builder.appSource;
        this.domains = builder.domains;
        this.enableSsl = builder.enableSsl;
        this.sslConfiguration = builder.sslConfiguration;
        this.attributes = builder.attributes;
        this.environment = builder.environment;
    }

    public String stackId() {
        return this.stackId;
    }

    public String shortname() {
        return this.shortname;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public boolean hasDataSources() {
        return this.dataSources != null && !(this.dataSources instanceof SdkAutoConstructList);
    }

    public List<DataSource> dataSources() {
        return this.dataSources;
    }

    public AppType type() {
        return AppType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public Source appSource() {
        return this.appSource;
    }

    public boolean hasDomains() {
        return this.domains != null && !(this.domains instanceof SdkAutoConstructList);
    }

    public List<String> domains() {
        return this.domains;
    }

    public Boolean enableSsl() {
        return this.enableSsl;
    }

    public SslConfiguration sslConfiguration() {
        return this.sslConfiguration;
    }

    public Map<AppAttributesKeys, String> attributes() {
        return AppAttributesCopier.copyStringToEnum(this.attributes);
    }

    public boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructMap);
    }

    public Map<String, String> attributesAsStrings() {
        return this.attributes;
    }

    public boolean hasEnvironment() {
        return this.environment != null && !(this.environment instanceof SdkAutoConstructList);
    }

    public List<EnvironmentVariable> environment() {
        return this.environment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.stackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.shortname());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSources());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.appSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.domains());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableSsl());
        hashCode = 31 * hashCode + Objects.hashCode(this.sslConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.environment());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAppRequest)) {
            return false;
        }
        CreateAppRequest other = (CreateAppRequest)((Object)obj);
        return Objects.equals(this.stackId(), other.stackId()) && Objects.equals(this.shortname(), other.shortname()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.dataSources(), other.dataSources()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.appSource(), other.appSource()) && Objects.equals(this.domains(), other.domains()) && Objects.equals(this.enableSsl(), other.enableSsl()) && Objects.equals(this.sslConfiguration(), other.sslConfiguration()) && Objects.equals(this.attributesAsStrings(), other.attributesAsStrings()) && Objects.equals(this.environment(), other.environment());
    }

    public String toString() {
        return ToString.builder((String)"CreateAppRequest").add("StackId", (Object)this.stackId()).add("Shortname", (Object)this.shortname()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("DataSources", this.dataSources()).add("Type", (Object)this.typeAsString()).add("AppSource", (Object)this.appSource()).add("Domains", this.domains()).add("EnableSsl", (Object)this.enableSsl()).add("SslConfiguration", (Object)this.sslConfiguration()).add("Attributes", this.attributesAsStrings()).add("Environment", this.environment()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackId": {
                return Optional.ofNullable(clazz.cast(this.stackId()));
            }
            case "Shortname": {
                return Optional.ofNullable(clazz.cast(this.shortname()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DataSources": {
                return Optional.ofNullable(clazz.cast(this.dataSources()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "AppSource": {
                return Optional.ofNullable(clazz.cast(this.appSource()));
            }
            case "Domains": {
                return Optional.ofNullable(clazz.cast(this.domains()));
            }
            case "EnableSsl": {
                return Optional.ofNullable(clazz.cast(this.enableSsl()));
            }
            case "SslConfiguration": {
                return Optional.ofNullable(clazz.cast(this.sslConfiguration()));
            }
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributesAsStrings()));
            }
            case "Environment": {
                return Optional.ofNullable(clazz.cast(this.environment()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAppRequest, T> g) {
        return obj -> g.apply((CreateAppRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpsWorksRequest.BuilderImpl
    implements Builder {
        private String stackId;
        private String shortname;
        private String name;
        private String description;
        private List<DataSource> dataSources = DefaultSdkAutoConstructList.getInstance();
        private String type;
        private Source appSource;
        private List<String> domains = DefaultSdkAutoConstructList.getInstance();
        private Boolean enableSsl;
        private SslConfiguration sslConfiguration;
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();
        private List<EnvironmentVariable> environment = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAppRequest model) {
            super(model);
            this.stackId(model.stackId);
            this.shortname(model.shortname);
            this.name(model.name);
            this.description(model.description);
            this.dataSources(model.dataSources);
            this.type(model.type);
            this.appSource(model.appSource);
            this.domains(model.domains);
            this.enableSsl(model.enableSsl);
            this.sslConfiguration(model.sslConfiguration);
            this.attributesWithStrings(model.attributes);
            this.environment(model.environment);
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getShortname() {
            return this.shortname;
        }

        @Override
        public final Builder shortname(String shortname) {
            this.shortname = shortname;
            return this;
        }

        public final void setShortname(String shortname) {
            this.shortname = shortname;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<DataSource.Builder> getDataSources() {
            return this.dataSources != null ? (Collection)this.dataSources.stream().map(DataSource::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dataSources(Collection<DataSource> dataSources) {
            this.dataSources = DataSourcesCopier.copy(dataSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSources(DataSource ... dataSources) {
            this.dataSources(Arrays.asList(dataSources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSources(Consumer<DataSource.Builder> ... dataSources) {
            this.dataSources(Stream.of(dataSources).map(c -> (DataSource)((DataSource.Builder)DataSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDataSources(Collection<DataSource.BuilderImpl> dataSources) {
            this.dataSources = DataSourcesCopier.copyFromBuilder(dataSources);
        }

        public final String getTypeAsString() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(AppType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Source.Builder getAppSource() {
            return this.appSource != null ? this.appSource.toBuilder() : null;
        }

        @Override
        public final Builder appSource(Source appSource) {
            this.appSource = appSource;
            return this;
        }

        public final void setAppSource(Source.BuilderImpl appSource) {
            this.appSource = appSource != null ? appSource.build() : null;
        }

        public final Collection<String> getDomains() {
            return this.domains;
        }

        @Override
        public final Builder domains(Collection<String> domains) {
            this.domains = StringsCopier.copy(domains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domains(String ... domains) {
            this.domains(Arrays.asList(domains));
            return this;
        }

        public final void setDomains(Collection<String> domains) {
            this.domains = StringsCopier.copy(domains);
        }

        public final Boolean getEnableSsl() {
            return this.enableSsl;
        }

        @Override
        public final Builder enableSsl(Boolean enableSsl) {
            this.enableSsl = enableSsl;
            return this;
        }

        public final void setEnableSsl(Boolean enableSsl) {
            this.enableSsl = enableSsl;
        }

        public final SslConfiguration.Builder getSslConfiguration() {
            return this.sslConfiguration != null ? this.sslConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder sslConfiguration(SslConfiguration sslConfiguration) {
            this.sslConfiguration = sslConfiguration;
            return this;
        }

        public final void setSslConfiguration(SslConfiguration.BuilderImpl sslConfiguration) {
            this.sslConfiguration = sslConfiguration != null ? sslConfiguration.build() : null;
        }

        public final Map<String, String> getAttributesAsStrings() {
            return this.attributes;
        }

        @Override
        public final Builder attributesWithStrings(Map<String, String> attributes) {
            this.attributes = AppAttributesCopier.copy(attributes);
            return this;
        }

        @Override
        public final Builder attributes(Map<AppAttributesKeys, String> attributes) {
            this.attributes = AppAttributesCopier.copyEnumToString(attributes);
            return this;
        }

        public final void setAttributesWithStrings(Map<String, String> attributes) {
            this.attributes = AppAttributesCopier.copy(attributes);
        }

        public final Collection<EnvironmentVariable.Builder> getEnvironment() {
            return this.environment != null ? (Collection)this.environment.stream().map(EnvironmentVariable::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder environment(Collection<EnvironmentVariable> environment) {
            this.environment = EnvironmentVariablesCopier.copy(environment);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environment(EnvironmentVariable ... environment) {
            this.environment(Arrays.asList(environment));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environment(Consumer<EnvironmentVariable.Builder> ... environment) {
            this.environment(Stream.of(environment).map(c -> (EnvironmentVariable)((EnvironmentVariable.Builder)EnvironmentVariable.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEnvironment(Collection<EnvironmentVariable.BuilderImpl> environment) {
            this.environment = EnvironmentVariablesCopier.copyFromBuilder(environment);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAppRequest build() {
            return new CreateAppRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OpsWorksRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAppRequest> {
        public Builder stackId(String var1);

        public Builder shortname(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder dataSources(Collection<DataSource> var1);

        public Builder dataSources(DataSource ... var1);

        public Builder dataSources(Consumer<DataSource.Builder> ... var1);

        public Builder type(String var1);

        public Builder type(AppType var1);

        public Builder appSource(Source var1);

        default public Builder appSource(Consumer<Source.Builder> appSource) {
            return this.appSource((Source)((Source.Builder)Source.builder().applyMutation(appSource)).build());
        }

        public Builder domains(Collection<String> var1);

        public Builder domains(String ... var1);

        public Builder enableSsl(Boolean var1);

        public Builder sslConfiguration(SslConfiguration var1);

        default public Builder sslConfiguration(Consumer<SslConfiguration.Builder> sslConfiguration) {
            return this.sslConfiguration((SslConfiguration)((SslConfiguration.Builder)SslConfiguration.builder().applyMutation(sslConfiguration)).build());
        }

        public Builder attributesWithStrings(Map<String, String> var1);

        public Builder attributes(Map<AppAttributesKeys, String> var1);

        public Builder environment(Collection<EnvironmentVariable> var1);

        public Builder environment(EnvironmentVariable ... var1);

        public Builder environment(Consumer<EnvironmentVariable.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

