/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SetPermissionRequest extends OpsWorksRequest implements
        ToCopyableBuilder<SetPermissionRequest.Builder, SetPermissionRequest> {
    private static final SdkField<String> STACK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SetPermissionRequest::stackId)).setter(setter(Builder::stackId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackId").build()).build();

    private static final SdkField<String> IAM_USER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SetPermissionRequest::iamUserArn)).setter(setter(Builder::iamUserArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamUserArn").build()).build();

    private static final SdkField<Boolean> ALLOW_SSH_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(SetPermissionRequest::allowSsh)).setter(setter(Builder::allowSsh))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowSsh").build()).build();

    private static final SdkField<Boolean> ALLOW_SUDO_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(SetPermissionRequest::allowSudo)).setter(setter(Builder::allowSudo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowSudo").build()).build();

    private static final SdkField<String> LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SetPermissionRequest::level)).setter(setter(Builder::level))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Level").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_ID_FIELD,
            IAM_USER_ARN_FIELD, ALLOW_SSH_FIELD, ALLOW_SUDO_FIELD, LEVEL_FIELD));

    private final String stackId;

    private final String iamUserArn;

    private final Boolean allowSsh;

    private final Boolean allowSudo;

    private final String level;

    private SetPermissionRequest(BuilderImpl builder) {
        super(builder);
        this.stackId = builder.stackId;
        this.iamUserArn = builder.iamUserArn;
        this.allowSsh = builder.allowSsh;
        this.allowSudo = builder.allowSudo;
        this.level = builder.level;
    }

    /**
     * <p>
     * The stack ID.
     * </p>
     * 
     * @return The stack ID.
     */
    public String stackId() {
        return stackId;
    }

    /**
     * <p>
     * The user's IAM ARN. This can also be a federated user's ARN.
     * </p>
     * 
     * @return The user's IAM ARN. This can also be a federated user's ARN.
     */
    public String iamUserArn() {
        return iamUserArn;
    }

    /**
     * <p>
     * The user is allowed to use SSH to communicate with the instance.
     * </p>
     * 
     * @return The user is allowed to use SSH to communicate with the instance.
     */
    public Boolean allowSsh() {
        return allowSsh;
    }

    /**
     * <p>
     * The user is allowed to use <b>sudo</b> to elevate privileges.
     * </p>
     * 
     * @return The user is allowed to use <b>sudo</b> to elevate privileges.
     */
    public Boolean allowSudo() {
        return allowSudo;
    }

    /**
     * <p>
     * The user's permission level, which must be set to one of the following strings. You cannot set your own
     * permissions level.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>deny</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>show</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>deploy</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>manage</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>iam_only</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about the permissions associated with these levels, see <a
     * href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>.
     * </p>
     * 
     * @return The user's permission level, which must be set to one of the following strings. You cannot set your own
     *         permissions level.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>deny</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>show</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>deploy</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>manage</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>iam_only</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information about the permissions associated with these levels, see <a
     *         href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     *         Permissions</a>.
     */
    public String level() {
        return level;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stackId());
        hashCode = 31 * hashCode + Objects.hashCode(iamUserArn());
        hashCode = 31 * hashCode + Objects.hashCode(allowSsh());
        hashCode = 31 * hashCode + Objects.hashCode(allowSudo());
        hashCode = 31 * hashCode + Objects.hashCode(level());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetPermissionRequest)) {
            return false;
        }
        SetPermissionRequest other = (SetPermissionRequest) obj;
        return Objects.equals(stackId(), other.stackId()) && Objects.equals(iamUserArn(), other.iamUserArn())
                && Objects.equals(allowSsh(), other.allowSsh()) && Objects.equals(allowSudo(), other.allowSudo())
                && Objects.equals(level(), other.level());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SetPermissionRequest").add("StackId", stackId()).add("IamUserArn", iamUserArn())
                .add("AllowSsh", allowSsh()).add("AllowSudo", allowSudo()).add("Level", level()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackId":
            return Optional.ofNullable(clazz.cast(stackId()));
        case "IamUserArn":
            return Optional.ofNullable(clazz.cast(iamUserArn()));
        case "AllowSsh":
            return Optional.ofNullable(clazz.cast(allowSsh()));
        case "AllowSudo":
            return Optional.ofNullable(clazz.cast(allowSudo()));
        case "Level":
            return Optional.ofNullable(clazz.cast(level()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SetPermissionRequest, T> g) {
        return obj -> g.apply((SetPermissionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpsWorksRequest.Builder, SdkPojo, CopyableBuilder<Builder, SetPermissionRequest> {
        /**
         * <p>
         * The stack ID.
         * </p>
         * 
         * @param stackId
         *        The stack ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * The user's IAM ARN. This can also be a federated user's ARN.
         * </p>
         * 
         * @param iamUserArn
         *        The user's IAM ARN. This can also be a federated user's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamUserArn(String iamUserArn);

        /**
         * <p>
         * The user is allowed to use SSH to communicate with the instance.
         * </p>
         * 
         * @param allowSsh
         *        The user is allowed to use SSH to communicate with the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowSsh(Boolean allowSsh);

        /**
         * <p>
         * The user is allowed to use <b>sudo</b> to elevate privileges.
         * </p>
         * 
         * @param allowSudo
         *        The user is allowed to use <b>sudo</b> to elevate privileges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowSudo(Boolean allowSudo);

        /**
         * <p>
         * The user's permission level, which must be set to one of the following strings. You cannot set your own
         * permissions level.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>deny</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>show</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>deploy</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>manage</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>iam_only</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information about the permissions associated with these levels, see <a
         * href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
         * Permissions</a>.
         * </p>
         * 
         * @param level
         *        The user's permission level, which must be set to one of the following strings. You cannot set your
         *        own permissions level.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>deny</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>show</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>deploy</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>manage</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>iam_only</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information about the permissions associated with these levels, see <a
         *        href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing
         *        User Permissions</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder level(String level);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpsWorksRequest.BuilderImpl implements Builder {
        private String stackId;

        private String iamUserArn;

        private Boolean allowSsh;

        private Boolean allowSudo;

        private String level;

        private BuilderImpl() {
        }

        private BuilderImpl(SetPermissionRequest model) {
            super(model);
            stackId(model.stackId);
            iamUserArn(model.iamUserArn);
            allowSsh(model.allowSsh);
            allowSudo(model.allowSudo);
            level(model.level);
        }

        public final String getStackId() {
            return stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getIamUserArn() {
            return iamUserArn;
        }

        @Override
        public final Builder iamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
            return this;
        }

        public final void setIamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
        }

        public final Boolean getAllowSsh() {
            return allowSsh;
        }

        @Override
        public final Builder allowSsh(Boolean allowSsh) {
            this.allowSsh = allowSsh;
            return this;
        }

        public final void setAllowSsh(Boolean allowSsh) {
            this.allowSsh = allowSsh;
        }

        public final Boolean getAllowSudo() {
            return allowSudo;
        }

        @Override
        public final Builder allowSudo(Boolean allowSudo) {
            this.allowSudo = allowSudo;
            return this;
        }

        public final void setAllowSudo(Boolean allowSudo) {
            this.allowSudo = allowSudo;
        }

        public final String getLevel() {
            return level;
        }

        @Override
        public final Builder level(String level) {
            this.level = level;
            return this;
        }

        public final void setLevel(String level) {
            this.level = level;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetPermissionRequest build() {
            return new SetPermissionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
