/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an instance's RAID array.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RaidArray implements SdkPojo, Serializable, ToCopyableBuilder<RaidArray.Builder, RaidArray> {
    private static final SdkField<String> RAID_ARRAY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RaidArray::raidArrayId)).setter(setter(Builder::raidArrayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RaidArrayId").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RaidArray::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RaidArray::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Integer> RAID_LEVEL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(RaidArray::raidLevel)).setter(setter(Builder::raidLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RaidLevel").build()).build();

    private static final SdkField<Integer> NUMBER_OF_DISKS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(RaidArray::numberOfDisks)).setter(setter(Builder::numberOfDisks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfDisks").build()).build();

    private static final SdkField<Integer> SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(RaidArray::size)).setter(setter(Builder::size))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Size").build()).build();

    private static final SdkField<String> DEVICE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RaidArray::device)).setter(setter(Builder::device))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Device").build()).build();

    private static final SdkField<String> MOUNT_POINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RaidArray::mountPoint)).setter(setter(Builder::mountPoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MountPoint").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RaidArray::availabilityZone)).setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()).build();

    private static final SdkField<String> CREATED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RaidArray::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<String> STACK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RaidArray::stackId)).setter(setter(Builder::stackId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackId").build()).build();

    private static final SdkField<String> VOLUME_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RaidArray::volumeType)).setter(setter(Builder::volumeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeType").build()).build();

    private static final SdkField<Integer> IOPS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(RaidArray::iops)).setter(setter(Builder::iops))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iops").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RAID_ARRAY_ID_FIELD,
            INSTANCE_ID_FIELD, NAME_FIELD, RAID_LEVEL_FIELD, NUMBER_OF_DISKS_FIELD, SIZE_FIELD, DEVICE_FIELD, MOUNT_POINT_FIELD,
            AVAILABILITY_ZONE_FIELD, CREATED_AT_FIELD, STACK_ID_FIELD, VOLUME_TYPE_FIELD, IOPS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String raidArrayId;

    private final String instanceId;

    private final String name;

    private final Integer raidLevel;

    private final Integer numberOfDisks;

    private final Integer size;

    private final String device;

    private final String mountPoint;

    private final String availabilityZone;

    private final String createdAt;

    private final String stackId;

    private final String volumeType;

    private final Integer iops;

    private RaidArray(BuilderImpl builder) {
        this.raidArrayId = builder.raidArrayId;
        this.instanceId = builder.instanceId;
        this.name = builder.name;
        this.raidLevel = builder.raidLevel;
        this.numberOfDisks = builder.numberOfDisks;
        this.size = builder.size;
        this.device = builder.device;
        this.mountPoint = builder.mountPoint;
        this.availabilityZone = builder.availabilityZone;
        this.createdAt = builder.createdAt;
        this.stackId = builder.stackId;
        this.volumeType = builder.volumeType;
        this.iops = builder.iops;
    }

    /**
     * <p>
     * The array ID.
     * </p>
     * 
     * @return The array ID.
     */
    public String raidArrayId() {
        return raidArrayId;
    }

    /**
     * <p>
     * The instance ID.
     * </p>
     * 
     * @return The instance ID.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The array name.
     * </p>
     * 
     * @return The array name.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The <a href="http://en.wikipedia.org/wiki/Standard_RAID_levels">RAID level</a>.
     * </p>
     * 
     * @return The <a href="http://en.wikipedia.org/wiki/Standard_RAID_levels">RAID level</a>.
     */
    public Integer raidLevel() {
        return raidLevel;
    }

    /**
     * <p>
     * The number of disks in the array.
     * </p>
     * 
     * @return The number of disks in the array.
     */
    public Integer numberOfDisks() {
        return numberOfDisks;
    }

    /**
     * <p>
     * The array's size.
     * </p>
     * 
     * @return The array's size.
     */
    public Integer size() {
        return size;
    }

    /**
     * <p>
     * The array's Linux device. For example /dev/mdadm0.
     * </p>
     * 
     * @return The array's Linux device. For example /dev/mdadm0.
     */
    public String device() {
        return device;
    }

    /**
     * <p>
     * The array's mount point.
     * </p>
     * 
     * @return The array's mount point.
     */
    public String mountPoint() {
        return mountPoint;
    }

    /**
     * <p>
     * The array's Availability Zone. For more information, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.
     * </p>
     * 
     * @return The array's Availability Zone. For more information, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * When the RAID array was created.
     * </p>
     * 
     * @return When the RAID array was created.
     */
    public String createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The stack ID.
     * </p>
     * 
     * @return The stack ID.
     */
    public String stackId() {
        return stackId;
    }

    /**
     * <p>
     * The volume type, standard or PIOPS.
     * </p>
     * 
     * @return The volume type, standard or PIOPS.
     */
    public String volumeType() {
        return volumeType;
    }

    /**
     * <p>
     * For PIOPS volumes, the IOPS per disk.
     * </p>
     * 
     * @return For PIOPS volumes, the IOPS per disk.
     */
    public Integer iops() {
        return iops;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(raidArrayId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(raidLevel());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfDisks());
        hashCode = 31 * hashCode + Objects.hashCode(size());
        hashCode = 31 * hashCode + Objects.hashCode(device());
        hashCode = 31 * hashCode + Objects.hashCode(mountPoint());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(stackId());
        hashCode = 31 * hashCode + Objects.hashCode(volumeType());
        hashCode = 31 * hashCode + Objects.hashCode(iops());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RaidArray)) {
            return false;
        }
        RaidArray other = (RaidArray) obj;
        return Objects.equals(raidArrayId(), other.raidArrayId()) && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(name(), other.name()) && Objects.equals(raidLevel(), other.raidLevel())
                && Objects.equals(numberOfDisks(), other.numberOfDisks()) && Objects.equals(size(), other.size())
                && Objects.equals(device(), other.device()) && Objects.equals(mountPoint(), other.mountPoint())
                && Objects.equals(availabilityZone(), other.availabilityZone()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(stackId(), other.stackId()) && Objects.equals(volumeType(), other.volumeType())
                && Objects.equals(iops(), other.iops());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RaidArray").add("RaidArrayId", raidArrayId()).add("InstanceId", instanceId())
                .add("Name", name()).add("RaidLevel", raidLevel()).add("NumberOfDisks", numberOfDisks()).add("Size", size())
                .add("Device", device()).add("MountPoint", mountPoint()).add("AvailabilityZone", availabilityZone())
                .add("CreatedAt", createdAt()).add("StackId", stackId()).add("VolumeType", volumeType()).add("Iops", iops())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RaidArrayId":
            return Optional.ofNullable(clazz.cast(raidArrayId()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "RaidLevel":
            return Optional.ofNullable(clazz.cast(raidLevel()));
        case "NumberOfDisks":
            return Optional.ofNullable(clazz.cast(numberOfDisks()));
        case "Size":
            return Optional.ofNullable(clazz.cast(size()));
        case "Device":
            return Optional.ofNullable(clazz.cast(device()));
        case "MountPoint":
            return Optional.ofNullable(clazz.cast(mountPoint()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "StackId":
            return Optional.ofNullable(clazz.cast(stackId()));
        case "VolumeType":
            return Optional.ofNullable(clazz.cast(volumeType()));
        case "Iops":
            return Optional.ofNullable(clazz.cast(iops()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RaidArray, T> g) {
        return obj -> g.apply((RaidArray) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RaidArray> {
        /**
         * <p>
         * The array ID.
         * </p>
         * 
         * @param raidArrayId
         *        The array ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder raidArrayId(String raidArrayId);

        /**
         * <p>
         * The instance ID.
         * </p>
         * 
         * @param instanceId
         *        The instance ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The array name.
         * </p>
         * 
         * @param name
         *        The array name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The <a href="http://en.wikipedia.org/wiki/Standard_RAID_levels">RAID level</a>.
         * </p>
         * 
         * @param raidLevel
         *        The <a href="http://en.wikipedia.org/wiki/Standard_RAID_levels">RAID level</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder raidLevel(Integer raidLevel);

        /**
         * <p>
         * The number of disks in the array.
         * </p>
         * 
         * @param numberOfDisks
         *        The number of disks in the array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfDisks(Integer numberOfDisks);

        /**
         * <p>
         * The array's size.
         * </p>
         * 
         * @param size
         *        The array's size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder size(Integer size);

        /**
         * <p>
         * The array's Linux device. For example /dev/mdadm0.
         * </p>
         * 
         * @param device
         *        The array's Linux device. For example /dev/mdadm0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder device(String device);

        /**
         * <p>
         * The array's mount point.
         * </p>
         * 
         * @param mountPoint
         *        The array's mount point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mountPoint(String mountPoint);

        /**
         * <p>
         * The array's Availability Zone. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.
         * </p>
         * 
         * @param availabilityZone
         *        The array's Availability Zone. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * When the RAID array was created.
         * </p>
         * 
         * @param createdAt
         *        When the RAID array was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(String createdAt);

        /**
         * <p>
         * The stack ID.
         * </p>
         * 
         * @param stackId
         *        The stack ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * The volume type, standard or PIOPS.
         * </p>
         * 
         * @param volumeType
         *        The volume type, standard or PIOPS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeType(String volumeType);

        /**
         * <p>
         * For PIOPS volumes, the IOPS per disk.
         * </p>
         * 
         * @param iops
         *        For PIOPS volumes, the IOPS per disk.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iops(Integer iops);
    }

    static final class BuilderImpl implements Builder {
        private String raidArrayId;

        private String instanceId;

        private String name;

        private Integer raidLevel;

        private Integer numberOfDisks;

        private Integer size;

        private String device;

        private String mountPoint;

        private String availabilityZone;

        private String createdAt;

        private String stackId;

        private String volumeType;

        private Integer iops;

        private BuilderImpl() {
        }

        private BuilderImpl(RaidArray model) {
            raidArrayId(model.raidArrayId);
            instanceId(model.instanceId);
            name(model.name);
            raidLevel(model.raidLevel);
            numberOfDisks(model.numberOfDisks);
            size(model.size);
            device(model.device);
            mountPoint(model.mountPoint);
            availabilityZone(model.availabilityZone);
            createdAt(model.createdAt);
            stackId(model.stackId);
            volumeType(model.volumeType);
            iops(model.iops);
        }

        public final String getRaidArrayId() {
            return raidArrayId;
        }

        @Override
        public final Builder raidArrayId(String raidArrayId) {
            this.raidArrayId = raidArrayId;
            return this;
        }

        public final void setRaidArrayId(String raidArrayId) {
            this.raidArrayId = raidArrayId;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Integer getRaidLevel() {
            return raidLevel;
        }

        @Override
        public final Builder raidLevel(Integer raidLevel) {
            this.raidLevel = raidLevel;
            return this;
        }

        public final void setRaidLevel(Integer raidLevel) {
            this.raidLevel = raidLevel;
        }

        public final Integer getNumberOfDisks() {
            return numberOfDisks;
        }

        @Override
        public final Builder numberOfDisks(Integer numberOfDisks) {
            this.numberOfDisks = numberOfDisks;
            return this;
        }

        public final void setNumberOfDisks(Integer numberOfDisks) {
            this.numberOfDisks = numberOfDisks;
        }

        public final Integer getSize() {
            return size;
        }

        @Override
        public final Builder size(Integer size) {
            this.size = size;
            return this;
        }

        public final void setSize(Integer size) {
            this.size = size;
        }

        public final String getDevice() {
            return device;
        }

        @Override
        public final Builder device(String device) {
            this.device = device;
            return this;
        }

        public final void setDevice(String device) {
            this.device = device;
        }

        public final String getMountPoint() {
            return mountPoint;
        }

        @Override
        public final Builder mountPoint(String mountPoint) {
            this.mountPoint = mountPoint;
            return this;
        }

        public final void setMountPoint(String mountPoint) {
            this.mountPoint = mountPoint;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        public final String getStackId() {
            return stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getVolumeType() {
            return volumeType;
        }

        @Override
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        public final Integer getIops() {
            return iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        @Override
        public RaidArray build() {
            return new RaidArray(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
