/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SslConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SslConfiguration> {
    private static final SdkField<String> CERTIFICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SslConfiguration.getter(SslConfiguration::certificate)).setter(SslConfiguration.setter(Builder::certificate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Certificate").build()}).build();
    private static final SdkField<String> PRIVATE_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SslConfiguration.getter(SslConfiguration::privateKey)).setter(SslConfiguration.setter(Builder::privateKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateKey").build()}).build();
    private static final SdkField<String> CHAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SslConfiguration.getter(SslConfiguration::chain)).setter(SslConfiguration.setter(Builder::chain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Chain").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_FIELD, PRIVATE_KEY_FIELD, CHAIN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String certificate;
    private final String privateKey;
    private final String chain;

    private SslConfiguration(BuilderImpl builder) {
        this.certificate = builder.certificate;
        this.privateKey = builder.privateKey;
        this.chain = builder.chain;
    }

    public String certificate() {
        return this.certificate;
    }

    public String privateKey() {
        return this.privateKey;
    }

    public String chain() {
        return this.chain;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.certificate());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.chain());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SslConfiguration)) {
            return false;
        }
        SslConfiguration other = (SslConfiguration)obj;
        return Objects.equals(this.certificate(), other.certificate()) && Objects.equals(this.privateKey(), other.privateKey()) && Objects.equals(this.chain(), other.chain());
    }

    public String toString() {
        return ToString.builder((String)"SslConfiguration").add("Certificate", (Object)this.certificate()).add("PrivateKey", (Object)this.privateKey()).add("Chain", (Object)this.chain()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Certificate": {
                return Optional.ofNullable(clazz.cast(this.certificate()));
            }
            case "PrivateKey": {
                return Optional.ofNullable(clazz.cast(this.privateKey()));
            }
            case "Chain": {
                return Optional.ofNullable(clazz.cast(this.chain()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SslConfiguration, T> g) {
        return obj -> g.apply((SslConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String certificate;
        private String privateKey;
        private String chain;

        private BuilderImpl() {
        }

        private BuilderImpl(SslConfiguration model) {
            this.certificate(model.certificate);
            this.privateKey(model.privateKey);
            this.chain(model.chain);
        }

        public final String getCertificate() {
            return this.certificate;
        }

        @Override
        public final Builder certificate(String certificate) {
            this.certificate = certificate;
            return this;
        }

        public final void setCertificate(String certificate) {
            this.certificate = certificate;
        }

        public final String getPrivateKey() {
            return this.privateKey;
        }

        @Override
        public final Builder privateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public final void setPrivateKey(String privateKey) {
            this.privateKey = privateKey;
        }

        public final String getChain() {
            return this.chain;
        }

        @Override
        public final Builder chain(String chain) {
            this.chain = chain;
            return this;
        }

        public final void setChain(String chain) {
            this.chain = chain;
        }

        public SslConfiguration build() {
            return new SslConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SslConfiguration> {
        public Builder certificate(String var1);

        public Builder privateKey(String var1);

        public Builder chain(String var1);
    }
}

