/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a <code>CreateUserProfile</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateUserProfileResponse extends OpsWorksResponse implements
        ToCopyableBuilder<CreateUserProfileResponse.Builder, CreateUserProfileResponse> {
    private static final SdkField<String> IAM_USER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IamUserArn").getter(getter(CreateUserProfileResponse::iamUserArn)).setter(setter(Builder::iamUserArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamUserArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IAM_USER_ARN_FIELD));

    private final String iamUserArn;

    private CreateUserProfileResponse(BuilderImpl builder) {
        super(builder);
        this.iamUserArn = builder.iamUserArn;
    }

    /**
     * <p>
     * The user's IAM ARN.
     * </p>
     * 
     * @return The user's IAM ARN.
     */
    public String iamUserArn() {
        return iamUserArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(iamUserArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUserProfileResponse)) {
            return false;
        }
        CreateUserProfileResponse other = (CreateUserProfileResponse) obj;
        return Objects.equals(iamUserArn(), other.iamUserArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateUserProfileResponse").add("IamUserArn", iamUserArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IamUserArn":
            return Optional.ofNullable(clazz.cast(iamUserArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateUserProfileResponse, T> g) {
        return obj -> g.apply((CreateUserProfileResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpsWorksResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateUserProfileResponse> {
        /**
         * <p>
         * The user's IAM ARN.
         * </p>
         * 
         * @param iamUserArn
         *        The user's IAM ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamUserArn(String iamUserArn);
    }

    static final class BuilderImpl extends OpsWorksResponse.BuilderImpl implements Builder {
        private String iamUserArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateUserProfileResponse model) {
            super(model);
            iamUserArn(model.iamUserArn);
        }

        public final String getIamUserArn() {
            return iamUserArn;
        }

        @Override
        public final Builder iamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
            return this;
        }

        public final void setIamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
        }

        @Override
        public CreateUserProfileResponse build() {
            return new CreateUserProfileResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
