/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.opsworks.model.OperatingSystem;
import software.amazon.awssdk.services.opsworks.model.OperatingSystemsCopier;
import software.amazon.awssdk.services.opsworks.model.OpsWorksResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeOperatingSystemsResponse
extends OpsWorksResponse
implements ToCopyableBuilder<Builder, DescribeOperatingSystemsResponse> {
    private static final SdkField<List<OperatingSystem>> OPERATING_SYSTEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OperatingSystems").getter(DescribeOperatingSystemsResponse.getter(DescribeOperatingSystemsResponse::operatingSystems)).setter(DescribeOperatingSystemsResponse.setter(Builder::operatingSystems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingSystems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OperatingSystem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERATING_SYSTEMS_FIELD));
    private final List<OperatingSystem> operatingSystems;

    private DescribeOperatingSystemsResponse(BuilderImpl builder) {
        super(builder);
        this.operatingSystems = builder.operatingSystems;
    }

    public boolean hasOperatingSystems() {
        return this.operatingSystems != null && !(this.operatingSystems instanceof SdkAutoConstructList);
    }

    public List<OperatingSystem> operatingSystems() {
        return this.operatingSystems;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.operatingSystems());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOperatingSystemsResponse)) {
            return false;
        }
        DescribeOperatingSystemsResponse other = (DescribeOperatingSystemsResponse)((Object)obj);
        return Objects.equals(this.operatingSystems(), other.operatingSystems());
    }

    public String toString() {
        return ToString.builder((String)"DescribeOperatingSystemsResponse").add("OperatingSystems", this.operatingSystems()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OperatingSystems": {
                return Optional.ofNullable(clazz.cast(this.operatingSystems()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeOperatingSystemsResponse, T> g) {
        return obj -> g.apply((DescribeOperatingSystemsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpsWorksResponse.BuilderImpl
    implements Builder {
        private List<OperatingSystem> operatingSystems = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOperatingSystemsResponse model) {
            super(model);
            this.operatingSystems(model.operatingSystems);
        }

        public final Collection<OperatingSystem.Builder> getOperatingSystems() {
            return this.operatingSystems != null ? (Collection)this.operatingSystems.stream().map(OperatingSystem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder operatingSystems(Collection<OperatingSystem> operatingSystems) {
            this.operatingSystems = OperatingSystemsCopier.copy(operatingSystems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operatingSystems(OperatingSystem ... operatingSystems) {
            this.operatingSystems(Arrays.asList(operatingSystems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operatingSystems(Consumer<OperatingSystem.Builder> ... operatingSystems) {
            this.operatingSystems(Stream.of(operatingSystems).map(c -> (OperatingSystem)((OperatingSystem.Builder)OperatingSystem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOperatingSystems(Collection<OperatingSystem.BuilderImpl> operatingSystems) {
            this.operatingSystems = OperatingSystemsCopier.copyFromBuilder(operatingSystems);
        }

        @Override
        public DescribeOperatingSystemsResponse build() {
            return new DescribeOperatingSystemsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OpsWorksResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeOperatingSystemsResponse> {
        public Builder operatingSystems(Collection<OperatingSystem> var1);

        public Builder operatingSystems(OperatingSystem ... var1);

        public Builder operatingSystems(Consumer<OperatingSystem.Builder> ... var1);
    }
}

